require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MMINTRIN_H_INCLUDED)) {
    eval 'sub _MMINTRIN_H_INCLUDED () {1;}' unless defined(&_MMINTRIN_H_INCLUDED);
    unless(defined(&__IWMMXT__)) {
	die("mmintrin\.h\ included\ without\ enabling\ WMMX\/WMMX2\ instructions\ \(e\.g\.\ \-march\=iwmmxt\ or\ \-march\=iwmmxt2\)");
    }
    if(defined (&__cplusplus)) {
    }
    eval 'sub _mm_cvtm64_si64 {
        my($__i) = @_;
	    eval q({ $__i; });
    }' unless defined(&_mm_cvtm64_si64);
    eval 'sub _mm_cvtsi64_si32 {
        my($__i) = @_;
	    eval q({ $__i; });
    }' unless defined(&_mm_cvtsi64_si32);
    eval 'sub _mm_cvtsi32_si64 {
        my($__i) = @_;
	    eval q({ ($__i & 0xffffffff); });
    }' unless defined(&_mm_cvtsi32_si64);
    eval 'sub _mm_slli_pi16 {
        my($__m,$__count) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wsllhi (( &__v4hi)$__m, $__count); });
    }' unless defined(&_mm_slli_pi16);
    eval 'sub _mm_slli_pi32 {
        my($__m,$__count) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wsllwi (( &__v2si)$__m, $__count); });
    }' unless defined(&_mm_slli_pi32);
    eval 'sub _mm_slli_si64 {
        my($__m,$__count) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wslldi ($__m, $__count); });
    }' unless defined(&_mm_slli_si64);
    eval 'sub _mm_srai_pi16 {
        my($__m,$__count) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wsrahi (( &__v4hi)$__m, $__count); });
    }' unless defined(&_mm_srai_pi16);
    eval 'sub _mm_srai_pi32 {
        my($__m,$__count) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wsrawi (( &__v2si)$__m, $__count); });
    }' unless defined(&_mm_srai_pi32);
    eval 'sub _mm_srai_si64 {
        my($__m,$__count) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wsradi ($__m, $__count); });
    }' unless defined(&_mm_srai_si64);
    eval 'sub _mm_srli_pi16 {
        my($__m,$__count) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wsrlhi (( &__v4hi)$__m, $__count); });
    }' unless defined(&_mm_srli_pi16);
    eval 'sub _mm_srli_pi32 {
        my($__m,$__count) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wsrlwi (( &__v2si)$__m, $__count); });
    }' unless defined(&_mm_srli_pi32);
    eval 'sub _mm_srli_si64 {
        my($__m,$__count) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wsrldi ($__m, $__count); });
    }' unless defined(&_mm_srli_si64);
    eval 'sub _mm_rori_pi16 {
        my($__m,$__count) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wrorhi (( &__v4hi)$__m, $__count); });
    }' unless defined(&_mm_rori_pi16);
    eval 'sub _mm_rori_pi32 {
        my($__m,$__count) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wrorwi (( &__v2si)$__m, $__count); });
    }' unless defined(&_mm_rori_pi32);
    eval 'sub _mm_rori_si64 {
        my($__m,$__count) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wrordi ($__m, $__count); });
    }' unless defined(&_mm_rori_si64);
    eval 'sub _mm_cmpgt_pi8 {
        my($__m1,$__m2) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wcmpgtsb (( &__v8qi)$__m1, ( &__v8qi)$__m2); });
    }' unless defined(&_mm_cmpgt_pi8);
    eval 'sub _mm_cmpgt_pu8 {
        my($__m1,$__m2) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wcmpgtub (( &__v8qi)$__m1, ( &__v8qi)$__m2); });
    }' unless defined(&_mm_cmpgt_pu8);
    eval 'sub _mm_cmpgt_pi16 {
        my($__m1,$__m2) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wcmpgtsh (( &__v4hi)$__m1, ( &__v4hi)$__m2); });
    }' unless defined(&_mm_cmpgt_pi16);
    eval 'sub _mm_cmpgt_pu16 {
        my($__m1,$__m2) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wcmpgtuh (( &__v4hi)$__m1, ( &__v4hi)$__m2); });
    }' unless defined(&_mm_cmpgt_pu16);
    eval 'sub _mm_cmpgt_pi32 {
        my($__m1,$__m2) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wcmpgtsw (( &__v2si)$__m1, ( &__v2si)$__m2); });
    }' unless defined(&_mm_cmpgt_pi32);
    eval 'sub _mm_cmpgt_pu32 {
        my($__m1,$__m2) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wcmpgtuw (( &__v2si)$__m1, ( &__v2si)$__m2); });
    }' unless defined(&_mm_cmpgt_pu32);
    eval 'sub _mm_mia_si64 {
        my($__A,$__B,$__C) = @_;
	    eval q({  &__builtin_arm_tmia ($__A, $__B, $__C); });
    }' unless defined(&_mm_mia_si64);
    eval 'sub _mm_miaph_si64 {
        my($__A,$__B,$__C) = @_;
	    eval q({  &__builtin_arm_tmiaph ($__A, $__B, $__C); });
    }' unless defined(&_mm_miaph_si64);
    eval 'sub _mm_miabb_si64 {
        my($__A,$__B,$__C) = @_;
	    eval q({  &__builtin_arm_tmiabb ($__A, $__B, $__C); });
    }' unless defined(&_mm_miabb_si64);
    eval 'sub _mm_miabt_si64 {
        my($__A,$__B,$__C) = @_;
	    eval q({  &__builtin_arm_tmiabt ($__A, $__B, $__C); });
    }' unless defined(&_mm_miabt_si64);
    eval 'sub _mm_miatb_si64 {
        my($__A,$__B,$__C) = @_;
	    eval q({  &__builtin_arm_tmiatb ($__A, $__B, $__C); });
    }' unless defined(&_mm_miatb_si64);
    eval 'sub _mm_miatt_si64 {
        my($__A,$__B,$__C) = @_;
	    eval q({  &__builtin_arm_tmiatt ($__A, $__B, $__C); });
    }' unless defined(&_mm_miatt_si64);
    eval 'sub _mm_extract_pi8 {
        my($A, $N) = @_;
	    eval q( &__builtin_arm_textrmsb (( &__v8qi)($A), ($N)));
    }' unless defined(&_mm_extract_pi8);
    eval 'sub _mm_extract_pi16 {
        my($A, $N) = @_;
	    eval q( &__builtin_arm_textrmsh (( &__v4hi)($A), ($N)));
    }' unless defined(&_mm_extract_pi16);
    eval 'sub _mm_extract_pi32 {
        my($A, $N) = @_;
	    eval q( &__builtin_arm_textrmsw (( &__v2si)($A), ($N)));
    }' unless defined(&_mm_extract_pi32);
    eval 'sub _mm_extract_pu8 {
        my($A, $N) = @_;
	    eval q( &__builtin_arm_textrmub (( &__v8qi)($A), ($N)));
    }' unless defined(&_mm_extract_pu8);
    eval 'sub _mm_extract_pu16 {
        my($A, $N) = @_;
	    eval q( &__builtin_arm_textrmuh (( &__v4hi)($A), ($N)));
    }' unless defined(&_mm_extract_pu16);
    eval 'sub _mm_extract_pu32 {
        my($A, $N) = @_;
	    eval q( &__builtin_arm_textrmuw (( &__v2si)($A), ($N)));
    }' unless defined(&_mm_extract_pu32);
    eval 'sub _mm_insert_pi8 {
        my($A, $D, $N) = @_;
	    eval q((( &__m64)  &__builtin_arm_tinsrb (( &__v8qi)($A), ($D), ($N))));
    }' unless defined(&_mm_insert_pi8);
    eval 'sub _mm_insert_pi16 {
        my($A, $D, $N) = @_;
	    eval q((( &__m64)  &__builtin_arm_tinsrh (( &__v4hi)($A), ($D), ($N))));
    }' unless defined(&_mm_insert_pi16);
    eval 'sub _mm_insert_pi32 {
        my($A, $D, $N) = @_;
	    eval q((( &__m64)  &__builtin_arm_tinsrw (( &__v2si)($A), ($D), ($N))));
    }' unless defined(&_mm_insert_pi32);
    eval 'sub _mm_shuffle_pi16 {
        my($A, $N) = @_;
	    eval q((( &__m64)  &__builtin_arm_wshufh (( &__v4hi)($A), ($N))));
    }' unless defined(&_mm_shuffle_pi16);
    eval 'sub _mm_sada_pu8 {
        my($__A,$__B,$__C) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wsadb (( &__v2si)$__A, ( &__v8qi)$__B, ( &__v8qi)$__C); });
    }' unless defined(&_mm_sada_pu8);
    eval 'sub _mm_sada_pu16 {
        my($__A,$__B,$__C) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_wsadh (( &__v2si)$__A, ( &__v4hi)$__B, ( &__v4hi)$__C); });
    }' unless defined(&_mm_sada_pu16);
    eval 'sub _mm_align_si64 {
        my($__A,$__B, $N) = @_;
	    eval q(( &__m64)  &__builtin_arm_walign (( &__v8qi) ($__A),( &__v8qi) ($__B), ($N)));
    }' unless defined(&_mm_align_si64);
    eval 'sub _mm_getwcx {
        my($__regno) = @_;
	    eval q({ \'int\'  &__value;  &switch ($__regno) {  &case 0:  &__asm  &__volatile (\\"tmrc %0, wcid\\" : \\"=r\\"( &__value));  &break;  &case 1:  &__asm  &__volatile (\\"tmrc %0, wcon\\" : \\"=r\\"( &__value));  &break;  &case 2:  &__asm  &__volatile (\\"tmrc %0, wcssf\\" : \\"=r\\"( &__value));  &break;  &case 3:  &__asm  &__volatile (\\"tmrc %0, wcasf\\" : \\"=r\\"( &__value));  &break;  &case 8:  &__builtin_arm_getwcgr0 ();  &case 9:  &__builtin_arm_getwcgr1 ();  &case 10:  &__builtin_arm_getwcgr2 ();  &case 11:  &__builtin_arm_getwcgr3 ();  &default:  &break; }  &__value; });
    }' unless defined(&_mm_getwcx);
    eval 'sub _mm_setr_pi16 {
        my($__w0,$__w1,$__w2,$__w3) = @_;
	    eval q({  &_mm_set_pi16 ($__w3, $__w2, $__w1, $__w0); });
    }' unless defined(&_mm_setr_pi16);
    eval 'sub _mm_setr_pi8 {
        my($__b0,$__b1,$__b2,$__b3,$__b4,$__b5,$__b6,$__b7) = @_;
	    eval q({  &_mm_set_pi8 ($__b7, $__b6, $__b5, $__b4, $__b3, $__b2, $__b1, $__b0); });
    }' unless defined(&_mm_setr_pi8);
    if(defined(&__IWMMXT2__)) {
	eval 'sub _mm_abs_pi8 {
	    my($m1) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wabsb (( &__v8qi)$m1); });
	}' unless defined(&_mm_abs_pi8);
	eval 'sub _mm_abs_pi16 {
	    my($m1) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wabsh (( &__v4hi)$m1); });
	}' unless defined(&_mm_abs_pi16);
	eval 'sub _mm_abs_pi32 {
	    my($m1) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wabsw (( &__v2si)$m1); });
	}' unless defined(&_mm_abs_pi32);
	eval 'sub _mm_addsubhx_pi16 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_waddsubhx (( &__v4hi)$a, ( &__v4hi)$b); });
	}' unless defined(&_mm_addsubhx_pi16);
	eval 'sub _mm_absdiff_pu8 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wabsdiffb (( &__v8qi)$a, ( &__v8qi)$b); });
	}' unless defined(&_mm_absdiff_pu8);
	eval 'sub _mm_absdiff_pu16 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wabsdiffh (( &__v4hi)$a, ( &__v4hi)$b); });
	}' unless defined(&_mm_absdiff_pu16);
	eval 'sub _mm_absdiff_pu32 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wabsdiffw (( &__v2si)$a, ( &__v2si)$b); });
	}' unless defined(&_mm_absdiff_pu32);
	eval 'sub _mm_addc_pu16 {
	    my($a,$b) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&_mm_addc_pu16);
	eval 'sub _mm_addc_pu32 {
	    my($a,$b) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&_mm_addc_pu32);
	eval 'sub _mm_avg4_pu8 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wavg4 (( &__v8qi)$a, ( &__v8qi)$b); });
	}' unless defined(&_mm_avg4_pu8);
	eval 'sub _mm_avg4r_pu8 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wavg4r (( &__v8qi)$a, ( &__v8qi)$b); });
	}' unless defined(&_mm_avg4r_pu8);
	eval 'sub _mm_maddx_pi16 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wmaddsx (( &__v4hi)$a, ( &__v4hi)$b); });
	}' unless defined(&_mm_maddx_pi16);
	eval 'sub _mm_maddx_pu16 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wmaddux (( &__v4hi)$a, ( &__v4hi)$b); });
	}' unless defined(&_mm_maddx_pu16);
	eval 'sub _mm_msub_pi16 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wmaddsn (( &__v4hi)$a, ( &__v4hi)$b); });
	}' unless defined(&_mm_msub_pi16);
	eval 'sub _mm_msub_pu16 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wmaddun (( &__v4hi)$a, ( &__v4hi)$b); });
	}' unless defined(&_mm_msub_pu16);
	eval 'sub _mm_mulhi_pi32 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wmulwsm (( &__v2si)$a, ( &__v2si)$b); });
	}' unless defined(&_mm_mulhi_pi32);
	eval 'sub _mm_mulhi_pu32 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wmulwum (( &__v2si)$a, ( &__v2si)$b); });
	}' unless defined(&_mm_mulhi_pu32);
	eval 'sub _mm_mulhir_pi16 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wmulsmr (( &__v4hi)$a, ( &__v4hi)$b); });
	}' unless defined(&_mm_mulhir_pi16);
	eval 'sub _mm_mulhir_pi32 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wmulwsmr (( &__v2si)$a, ( &__v2si)$b); });
	}' unless defined(&_mm_mulhir_pi32);
	eval 'sub _mm_mulhir_pu16 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wmulumr (( &__v4hi)$a, ( &__v4hi)$b); });
	}' unless defined(&_mm_mulhir_pu16);
	eval 'sub _mm_mulhir_pu32 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wmulwumr (( &__v2si)$a, ( &__v2si)$b); });
	}' unless defined(&_mm_mulhir_pu32);
	eval 'sub _mm_mullo_pi32 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wmulwl (( &__v2si)$a, ( &__v2si)$b); });
	}' unless defined(&_mm_mullo_pi32);
	eval 'sub _mm_qmulm_pi16 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wqmulm (( &__v4hi)$a, ( &__v4hi)$b); });
	}' unless defined(&_mm_qmulm_pi16);
	eval 'sub _mm_qmulm_pi32 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wqmulwm (( &__v2si)$a, ( &__v2si)$b); });
	}' unless defined(&_mm_qmulm_pi32);
	eval 'sub _mm_qmulmr_pi16 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wqmulmr (( &__v4hi)$a, ( &__v4hi)$b); });
	}' unless defined(&_mm_qmulmr_pi16);
	eval 'sub _mm_qmulmr_pi32 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wqmulwmr (( &__v2si)$a, ( &__v2si)$b); });
	}' unless defined(&_mm_qmulmr_pi32);
	eval 'sub _mm_subaddhx_pi16 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_wsubaddhx (( &__v4hi)$a, ( &__v4hi)$b); });
	}' unless defined(&_mm_subaddhx_pi16);
	eval 'sub _mm_addbhusl_pu8 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_waddbhusl (( &__v4hi)$a, ( &__v8qi)$b); });
	}' unless defined(&_mm_addbhusl_pu8);
	eval 'sub _mm_addbhusm_pu8 {
	    my($a,$b) = @_;
    	    eval q({ ( &__m64)  &__builtin_arm_waddbhusm (( &__v4hi)$a, ( &__v8qi)$b); });
	}' unless defined(&_mm_addbhusm_pu8);
	eval 'sub _mm_qmiabb_pi32 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wqmiabb (( &__v2si) &_acc, ( &__v4hi) &_m1, ( &__v4hi) &_m2);  &_acc; }));
	}' unless defined(&_mm_qmiabb_pi32);
	eval 'sub _mm_qmiabbn_pi32 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wqmiabbn (( &__v2si) &_acc, ( &__v4hi) &_m1, ( &__v4hi) &_m2);  &_acc; }));
	}' unless defined(&_mm_qmiabbn_pi32);
	eval 'sub _mm_qmiabt_pi32 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wqmiabt (( &__v2si) &_acc, ( &__v4hi) &_m1, ( &__v4hi) &_m2);  &_acc; }));
	}' unless defined(&_mm_qmiabt_pi32);
	eval 'sub _mm_qmiabtn_pi32 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc=$acc;  &__m64  &_m1=$m1;  &__m64  &_m2=$m2;  &_acc = ( &__m64)  &__builtin_arm_wqmiabtn (( &__v2si) &_acc, ( &__v4hi) &_m1, ( &__v4hi) &_m2);  &_acc; }));
	}' unless defined(&_mm_qmiabtn_pi32);
	eval 'sub _mm_qmiatb_pi32 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wqmiatb (( &__v2si) &_acc, ( &__v4hi) &_m1, ( &__v4hi) &_m2);  &_acc; }));
	}' unless defined(&_mm_qmiatb_pi32);
	eval 'sub _mm_qmiatbn_pi32 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wqmiatbn (( &__v2si) &_acc, ( &__v4hi) &_m1, ( &__v4hi) &_m2);  &_acc; }));
	}' unless defined(&_mm_qmiatbn_pi32);
	eval 'sub _mm_qmiatt_pi32 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wqmiatt (( &__v2si) &_acc, ( &__v4hi) &_m1, ( &__v4hi) &_m2);  &_acc; }));
	}' unless defined(&_mm_qmiatt_pi32);
	eval 'sub _mm_qmiattn_pi32 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wqmiattn (( &__v2si) &_acc, ( &__v4hi) &_m1, ( &__v4hi) &_m2);  &_acc; }));
	}' unless defined(&_mm_qmiattn_pi32);
	eval 'sub _mm_wmiabb_si64 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wmiabb ( &_acc, ( &__v4hi) &_m1, ( &__v4hi) &_m2);  &_acc; }));
	}' unless defined(&_mm_wmiabb_si64);
	eval 'sub _mm_wmiabbn_si64 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wmiabbn ( &_acc, ( &__v4hi) &_m1, ( &__v4hi) &_m2);  &_acc; }));
	}' unless defined(&_mm_wmiabbn_si64);
	eval 'sub _mm_wmiabt_si64 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wmiabt ( &_acc, ( &__v4hi) &_m1, ( &__v4hi) &_m2);  &_acc; }));
	}' unless defined(&_mm_wmiabt_si64);
	eval 'sub _mm_wmiabtn_si64 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wmiabtn ( &_acc, ( &__v4hi) &_m1, ( &__v4hi) &_m2);  &_acc; }));
	}' unless defined(&_mm_wmiabtn_si64);
	eval 'sub _mm_wmiatb_si64 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wmiatb ( &_acc, ( &__v4hi) &_m1, ( &__v4hi) &_m2);  &_acc; }));
	}' unless defined(&_mm_wmiatb_si64);
	eval 'sub _mm_wmiatbn_si64 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wmiatbn ( &_acc, ( &__v4hi) &_m1, ( &__v4hi) &_m2);  &_acc; }));
	}' unless defined(&_mm_wmiatbn_si64);
	eval 'sub _mm_wmiatt_si64 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wmiatt ( &_acc, ( &__v4hi) &_m1, ( &__v4hi) &_m2);  &_acc; }));
	}' unless defined(&_mm_wmiatt_si64);
	eval 'sub _mm_wmiattn_si64 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wmiattn ( &_acc, ( &__v4hi) &_m1, ( &__v4hi) &_m2);  &_acc; }));
	}' unless defined(&_mm_wmiattn_si64);
	eval 'sub _mm_wmiawbb_si64 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wmiawbb ( &_acc, ( &__v2si) &_m1, ( &__v2si) &_m2);  &_acc; }));
	}' unless defined(&_mm_wmiawbb_si64);
	eval 'sub _mm_wmiawbbn_si64 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wmiawbbn ( &_acc, ( &__v2si) &_m1, ( &__v2si) &_m2);  &_acc; }));
	}' unless defined(&_mm_wmiawbbn_si64);
	eval 'sub _mm_wmiawbt_si64 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wmiawbt ( &_acc, ( &__v2si) &_m1, ( &__v2si) &_m2);  &_acc; }));
	}' unless defined(&_mm_wmiawbt_si64);
	eval 'sub _mm_wmiawbtn_si64 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wmiawbtn ( &_acc, ( &__v2si) &_m1, ( &__v2si) &_m2);  &_acc; }));
	}' unless defined(&_mm_wmiawbtn_si64);
	eval 'sub _mm_wmiawtb_si64 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wmiawtb ( &_acc, ( &__v2si) &_m1, ( &__v2si) &_m2);  &_acc; }));
	}' unless defined(&_mm_wmiawtb_si64);
	eval 'sub _mm_wmiawtbn_si64 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wmiawtbn ( &_acc, ( &__v2si) &_m1, ( &__v2si) &_m2);  &_acc; }));
	}' unless defined(&_mm_wmiawtbn_si64);
	eval 'sub _mm_wmiawtt_si64 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wmiawtt ( &_acc, ( &__v2si) &_m1, ( &__v2si) &_m2);  &_acc; }));
	}' unless defined(&_mm_wmiawtt_si64);
	eval 'sub _mm_wmiawttn_si64 {
	    my($acc, $m1, $m2) = @_;
    	    eval q(({  &__m64  &_acc = $acc;  &__m64  &_m1 = $m1;  &__m64  &_m2 = $m2;  &_acc = ( &__m64)  &__builtin_arm_wmiawttn ( &_acc, ( &__v2si) &_m1, ( &__v2si) &_m2);  &_acc; }));
	}' unless defined(&_mm_wmiawttn_si64);
	eval 'sub _mm_merge_si64 {
	    my($a, $b, $n) = @_;
    	    eval q(({  &__m64  &result;  &result = ( &__m64)  &__builtin_arm_wmerge (( &__m64) ($a), ( &__m64) ($b), ($n));  &result; }));
	}' unless defined(&_mm_merge_si64);
    }
    eval 'sub _mm_alignr0_si64 {
        my($a,$b) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_walignr0 (( &__v8qi) $a, ( &__v8qi) $b); });
    }' unless defined(&_mm_alignr0_si64);
    eval 'sub _mm_alignr1_si64 {
        my($a,$b) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_walignr1 (( &__v8qi) $a, ( &__v8qi) $b); });
    }' unless defined(&_mm_alignr1_si64);
    eval 'sub _mm_alignr2_si64 {
        my($a,$b) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_walignr2 (( &__v8qi) $a, ( &__v8qi) $b); });
    }' unless defined(&_mm_alignr2_si64);
    eval 'sub _mm_alignr3_si64 {
        my($a,$b) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_walignr3 (( &__v8qi) $a, ( &__v8qi) $b); });
    }' unless defined(&_mm_alignr3_si64);
    eval 'sub _mm_tandcb () {
        eval q({  &__asm  &__volatile (\\"tandcb r15\\"); });
    }' unless defined(&_mm_tandcb);
    eval 'sub _mm_tandch () {
        eval q({  &__asm  &__volatile (\\"tandch r15\\"); });
    }' unless defined(&_mm_tandch);
    eval 'sub _mm_tandcw () {
        eval q({  &__asm  &__volatile (\\"tandcw r15\\"); });
    }' unless defined(&_mm_tandcw);
    eval 'sub _mm_textrcb {
        my($n) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&_mm_textrcb);
    eval 'sub _mm_textrch {
        my($n) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&_mm_textrch);
    eval 'sub _mm_textrcw {
        my($n) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&_mm_textrcw);
    eval 'sub _mm_torcb () {
        eval q({  &__asm  &__volatile (\\"torcb r15\\"); });
    }' unless defined(&_mm_torcb);
    eval 'sub _mm_torch () {
        eval q({  &__asm  &__volatile (\\"torch r15\\"); });
    }' unless defined(&_mm_torch);
    eval 'sub _mm_torcw () {
        eval q({  &__asm  &__volatile (\\"torcw r15\\"); });
    }' unless defined(&_mm_torcw);
    if(defined(&__IWMMXT2__)) {
	eval 'sub _mm_torvscb () {
	    eval q({  &__asm  &__volatile (\\"torvscb r15\\"); });
	}' unless defined(&_mm_torvscb);
	eval 'sub _mm_torvsch () {
	    eval q({  &__asm  &__volatile (\\"torvsch r15\\"); });
	}' unless defined(&_mm_torvsch);
	eval 'sub _mm_torvscw () {
	    eval q({  &__asm  &__volatile (\\"torvscw r15\\"); });
	}' unless defined(&_mm_torvscw);
    }
    eval 'sub _mm_tbcst_pi8 {
        my($value) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_tbcstb ( $value); });
    }' unless defined(&_mm_tbcst_pi8);
    eval 'sub _mm_tbcst_pi16 {
        my($value) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_tbcsth ( $value); });
    }' unless defined(&_mm_tbcst_pi16);
    eval 'sub _mm_tbcst_pi32 {
        my($value) = @_;
	    eval q({ ( &__m64)  &__builtin_arm_tbcstw ($value); });
    }' unless defined(&_mm_tbcst_pi32);
    eval 'sub _m_empty () { &_mm_empty;}' unless defined(&_m_empty);
    eval 'sub _m_packsswb () { &_mm_packs_pi16;}' unless defined(&_m_packsswb);
    eval 'sub _m_packssdw () { &_mm_packs_pi32;}' unless defined(&_m_packssdw);
    eval 'sub _m_packuswb () { &_mm_packs_pu16;}' unless defined(&_m_packuswb);
    eval 'sub _m_packusdw () { &_mm_packs_pu32;}' unless defined(&_m_packusdw);
    eval 'sub _m_packssqd () { &_mm_packs_pi64;}' unless defined(&_m_packssqd);
    eval 'sub _m_packusqd () { &_mm_packs_pu64;}' unless defined(&_m_packusqd);
    eval 'sub _mm_packs_si64 () { &_mm_packs_pi64;}' unless defined(&_mm_packs_si64);
    eval 'sub _mm_packs_su64 () { &_mm_packs_pu64;}' unless defined(&_mm_packs_su64);
    eval 'sub _m_punpckhbw () { &_mm_unpackhi_pi8;}' unless defined(&_m_punpckhbw);
    eval 'sub _m_punpckhwd () { &_mm_unpackhi_pi16;}' unless defined(&_m_punpckhwd);
    eval 'sub _m_punpckhdq () { &_mm_unpackhi_pi32;}' unless defined(&_m_punpckhdq);
    eval 'sub _m_punpcklbw () { &_mm_unpacklo_pi8;}' unless defined(&_m_punpcklbw);
    eval 'sub _m_punpcklwd () { &_mm_unpacklo_pi16;}' unless defined(&_m_punpcklwd);
    eval 'sub _m_punpckldq () { &_mm_unpacklo_pi32;}' unless defined(&_m_punpckldq);
    eval 'sub _m_punpckehsbw () { &_mm_unpackeh_pi8;}' unless defined(&_m_punpckehsbw);
    eval 'sub _m_punpckehswd () { &_mm_unpackeh_pi16;}' unless defined(&_m_punpckehswd);
    eval 'sub _m_punpckehsdq () { &_mm_unpackeh_pi32;}' unless defined(&_m_punpckehsdq);
    eval 'sub _m_punpckehubw () { &_mm_unpackeh_pu8;}' unless defined(&_m_punpckehubw);
    eval 'sub _m_punpckehuwd () { &_mm_unpackeh_pu16;}' unless defined(&_m_punpckehuwd);
    eval 'sub _m_punpckehudq () { &_mm_unpackeh_pu32;}' unless defined(&_m_punpckehudq);
    eval 'sub _m_punpckelsbw () { &_mm_unpackel_pi8;}' unless defined(&_m_punpckelsbw);
    eval 'sub _m_punpckelswd () { &_mm_unpackel_pi16;}' unless defined(&_m_punpckelswd);
    eval 'sub _m_punpckelsdq () { &_mm_unpackel_pi32;}' unless defined(&_m_punpckelsdq);
    eval 'sub _m_punpckelubw () { &_mm_unpackel_pu8;}' unless defined(&_m_punpckelubw);
    eval 'sub _m_punpckeluwd () { &_mm_unpackel_pu16;}' unless defined(&_m_punpckeluwd);
    eval 'sub _m_punpckeludq () { &_mm_unpackel_pu32;}' unless defined(&_m_punpckeludq);
    eval 'sub _m_paddb () { &_mm_add_pi8;}' unless defined(&_m_paddb);
    eval 'sub _m_paddw () { &_mm_add_pi16;}' unless defined(&_m_paddw);
    eval 'sub _m_paddd () { &_mm_add_pi32;}' unless defined(&_m_paddd);
    eval 'sub _m_paddsb () { &_mm_adds_pi8;}' unless defined(&_m_paddsb);
    eval 'sub _m_paddsw () { &_mm_adds_pi16;}' unless defined(&_m_paddsw);
    eval 'sub _m_paddsd () { &_mm_adds_pi32;}' unless defined(&_m_paddsd);
    eval 'sub _m_paddusb () { &_mm_adds_pu8;}' unless defined(&_m_paddusb);
    eval 'sub _m_paddusw () { &_mm_adds_pu16;}' unless defined(&_m_paddusw);
    eval 'sub _m_paddusd () { &_mm_adds_pu32;}' unless defined(&_m_paddusd);
    eval 'sub _m_psubb () { &_mm_sub_pi8;}' unless defined(&_m_psubb);
    eval 'sub _m_psubw () { &_mm_sub_pi16;}' unless defined(&_m_psubw);
    eval 'sub _m_psubd () { &_mm_sub_pi32;}' unless defined(&_m_psubd);
    eval 'sub _m_psubsb () { &_mm_subs_pi8;}' unless defined(&_m_psubsb);
    eval 'sub _m_psubsw () { &_mm_subs_pi16;}' unless defined(&_m_psubsw);
    eval 'sub _m_psubuw () { &_mm_subs_pi32;}' unless defined(&_m_psubuw);
    eval 'sub _m_psubusb () { &_mm_subs_pu8;}' unless defined(&_m_psubusb);
    eval 'sub _m_psubusw () { &_mm_subs_pu16;}' unless defined(&_m_psubusw);
    eval 'sub _m_psubusd () { &_mm_subs_pu32;}' unless defined(&_m_psubusd);
    eval 'sub _m_pmaddwd () { &_mm_madd_pi16;}' unless defined(&_m_pmaddwd);
    eval 'sub _m_pmadduwd () { &_mm_madd_pu16;}' unless defined(&_m_pmadduwd);
    eval 'sub _m_pmulhw () { &_mm_mulhi_pi16;}' unless defined(&_m_pmulhw);
    eval 'sub _m_pmulhuw () { &_mm_mulhi_pu16;}' unless defined(&_m_pmulhuw);
    eval 'sub _m_pmullw () { &_mm_mullo_pi16;}' unless defined(&_m_pmullw);
    eval 'sub _m_pmacsw () { &_mm_mac_pi16;}' unless defined(&_m_pmacsw);
    eval 'sub _m_pmacuw () { &_mm_mac_pu16;}' unless defined(&_m_pmacuw);
    eval 'sub _m_pmacszw () { &_mm_macz_pi16;}' unless defined(&_m_pmacszw);
    eval 'sub _m_pmacuzw () { &_mm_macz_pu16;}' unless defined(&_m_pmacuzw);
    eval 'sub _m_paccb () { &_mm_acc_pu8;}' unless defined(&_m_paccb);
    eval 'sub _m_paccw () { &_mm_acc_pu16;}' unless defined(&_m_paccw);
    eval 'sub _m_paccd () { &_mm_acc_pu32;}' unless defined(&_m_paccd);
    eval 'sub _m_pmia () { &_mm_mia_si64;}' unless defined(&_m_pmia);
    eval 'sub _m_pmiaph () { &_mm_miaph_si64;}' unless defined(&_m_pmiaph);
    eval 'sub _m_pmiabb () { &_mm_miabb_si64;}' unless defined(&_m_pmiabb);
    eval 'sub _m_pmiabt () { &_mm_miabt_si64;}' unless defined(&_m_pmiabt);
    eval 'sub _m_pmiatb () { &_mm_miatb_si64;}' unless defined(&_m_pmiatb);
    eval 'sub _m_pmiatt () { &_mm_miatt_si64;}' unless defined(&_m_pmiatt);
    eval 'sub _m_psllw () { &_mm_sll_pi16;}' unless defined(&_m_psllw);
    eval 'sub _m_psllwi () { &_mm_slli_pi16;}' unless defined(&_m_psllwi);
    eval 'sub _m_pslld () { &_mm_sll_pi32;}' unless defined(&_m_pslld);
    eval 'sub _m_pslldi () { &_mm_slli_pi32;}' unless defined(&_m_pslldi);
    eval 'sub _m_psllq () { &_mm_sll_si64;}' unless defined(&_m_psllq);
    eval 'sub _m_psllqi () { &_mm_slli_si64;}' unless defined(&_m_psllqi);
    eval 'sub _m_psraw () { &_mm_sra_pi16;}' unless defined(&_m_psraw);
    eval 'sub _m_psrawi () { &_mm_srai_pi16;}' unless defined(&_m_psrawi);
    eval 'sub _m_psrad () { &_mm_sra_pi32;}' unless defined(&_m_psrad);
    eval 'sub _m_psradi () { &_mm_srai_pi32;}' unless defined(&_m_psradi);
    eval 'sub _m_psraq () { &_mm_sra_si64;}' unless defined(&_m_psraq);
    eval 'sub _m_psraqi () { &_mm_srai_si64;}' unless defined(&_m_psraqi);
    eval 'sub _m_psrlw () { &_mm_srl_pi16;}' unless defined(&_m_psrlw);
    eval 'sub _m_psrlwi () { &_mm_srli_pi16;}' unless defined(&_m_psrlwi);
    eval 'sub _m_psrld () { &_mm_srl_pi32;}' unless defined(&_m_psrld);
    eval 'sub _m_psrldi () { &_mm_srli_pi32;}' unless defined(&_m_psrldi);
    eval 'sub _m_psrlq () { &_mm_srl_si64;}' unless defined(&_m_psrlq);
    eval 'sub _m_psrlqi () { &_mm_srli_si64;}' unless defined(&_m_psrlqi);
    eval 'sub _m_prorw () { &_mm_ror_pi16;}' unless defined(&_m_prorw);
    eval 'sub _m_prorwi () { &_mm_rori_pi16;}' unless defined(&_m_prorwi);
    eval 'sub _m_prord () { &_mm_ror_pi32;}' unless defined(&_m_prord);
    eval 'sub _m_prordi () { &_mm_rori_pi32;}' unless defined(&_m_prordi);
    eval 'sub _m_prorq () { &_mm_ror_si64;}' unless defined(&_m_prorq);
    eval 'sub _m_prorqi () { &_mm_rori_si64;}' unless defined(&_m_prorqi);
    eval 'sub _m_pand () { &_mm_and_si64;}' unless defined(&_m_pand);
    eval 'sub _m_pandn () { &_mm_andnot_si64;}' unless defined(&_m_pandn);
    eval 'sub _m_por () { &_mm_or_si64;}' unless defined(&_m_por);
    eval 'sub _m_pxor () { &_mm_xor_si64;}' unless defined(&_m_pxor);
    eval 'sub _m_pcmpeqb () { &_mm_cmpeq_pi8;}' unless defined(&_m_pcmpeqb);
    eval 'sub _m_pcmpeqw () { &_mm_cmpeq_pi16;}' unless defined(&_m_pcmpeqw);
    eval 'sub _m_pcmpeqd () { &_mm_cmpeq_pi32;}' unless defined(&_m_pcmpeqd);
    eval 'sub _m_pcmpgtb () { &_mm_cmpgt_pi8;}' unless defined(&_m_pcmpgtb);
    eval 'sub _m_pcmpgtub () { &_mm_cmpgt_pu8;}' unless defined(&_m_pcmpgtub);
    eval 'sub _m_pcmpgtw () { &_mm_cmpgt_pi16;}' unless defined(&_m_pcmpgtw);
    eval 'sub _m_pcmpgtuw () { &_mm_cmpgt_pu16;}' unless defined(&_m_pcmpgtuw);
    eval 'sub _m_pcmpgtd () { &_mm_cmpgt_pi32;}' unless defined(&_m_pcmpgtd);
    eval 'sub _m_pcmpgtud () { &_mm_cmpgt_pu32;}' unless defined(&_m_pcmpgtud);
    eval 'sub _m_pextrb () { &_mm_extract_pi8;}' unless defined(&_m_pextrb);
    eval 'sub _m_pextrw () { &_mm_extract_pi16;}' unless defined(&_m_pextrw);
    eval 'sub _m_pextrd () { &_mm_extract_pi32;}' unless defined(&_m_pextrd);
    eval 'sub _m_pextrub () { &_mm_extract_pu8;}' unless defined(&_m_pextrub);
    eval 'sub _m_pextruw () { &_mm_extract_pu16;}' unless defined(&_m_pextruw);
    eval 'sub _m_pextrud () { &_mm_extract_pu32;}' unless defined(&_m_pextrud);
    eval 'sub _m_pinsrb () { &_mm_insert_pi8;}' unless defined(&_m_pinsrb);
    eval 'sub _m_pinsrw () { &_mm_insert_pi16;}' unless defined(&_m_pinsrw);
    eval 'sub _m_pinsrd () { &_mm_insert_pi32;}' unless defined(&_m_pinsrd);
    eval 'sub _m_pmaxsb () { &_mm_max_pi8;}' unless defined(&_m_pmaxsb);
    eval 'sub _m_pmaxsw () { &_mm_max_pi16;}' unless defined(&_m_pmaxsw);
    eval 'sub _m_pmaxsd () { &_mm_max_pi32;}' unless defined(&_m_pmaxsd);
    eval 'sub _m_pmaxub () { &_mm_max_pu8;}' unless defined(&_m_pmaxub);
    eval 'sub _m_pmaxuw () { &_mm_max_pu16;}' unless defined(&_m_pmaxuw);
    eval 'sub _m_pmaxud () { &_mm_max_pu32;}' unless defined(&_m_pmaxud);
    eval 'sub _m_pminsb () { &_mm_min_pi8;}' unless defined(&_m_pminsb);
    eval 'sub _m_pminsw () { &_mm_min_pi16;}' unless defined(&_m_pminsw);
    eval 'sub _m_pminsd () { &_mm_min_pi32;}' unless defined(&_m_pminsd);
    eval 'sub _m_pminub () { &_mm_min_pu8;}' unless defined(&_m_pminub);
    eval 'sub _m_pminuw () { &_mm_min_pu16;}' unless defined(&_m_pminuw);
    eval 'sub _m_pminud () { &_mm_min_pu32;}' unless defined(&_m_pminud);
    eval 'sub _m_pmovmskb () { &_mm_movemask_pi8;}' unless defined(&_m_pmovmskb);
    eval 'sub _m_pmovmskw () { &_mm_movemask_pi16;}' unless defined(&_m_pmovmskw);
    eval 'sub _m_pmovmskd () { &_mm_movemask_pi32;}' unless defined(&_m_pmovmskd);
    eval 'sub _m_pshufw () { &_mm_shuffle_pi16;}' unless defined(&_m_pshufw);
    eval 'sub _m_pavgb () { &_mm_avg_pu8;}' unless defined(&_m_pavgb);
    eval 'sub _m_pavgw () { &_mm_avg_pu16;}' unless defined(&_m_pavgw);
    eval 'sub _m_pavg2b () { &_mm_avg2_pu8;}' unless defined(&_m_pavg2b);
    eval 'sub _m_pavg2w () { &_mm_avg2_pu16;}' unless defined(&_m_pavg2w);
    eval 'sub _m_psadbw () { &_mm_sad_pu8;}' unless defined(&_m_psadbw);
    eval 'sub _m_psadwd () { &_mm_sad_pu16;}' unless defined(&_m_psadwd);
    eval 'sub _m_psadzbw () { &_mm_sadz_pu8;}' unless defined(&_m_psadzbw);
    eval 'sub _m_psadzwd () { &_mm_sadz_pu16;}' unless defined(&_m_psadzwd);
    eval 'sub _m_paligniq () { &_mm_align_si64;}' unless defined(&_m_paligniq);
    eval 'sub _m_cvt_si2pi () { &_mm_cvtsi64_m64;}' unless defined(&_m_cvt_si2pi);
    eval 'sub _m_cvt_pi2si () { &_mm_cvtm64_si64;}' unless defined(&_m_cvt_pi2si);
    eval 'sub _m_from_int () { &_mm_cvtsi32_si64;}' unless defined(&_m_from_int);
    eval 'sub _m_to_int () { &_mm_cvtsi64_si32;}' unless defined(&_m_to_int);
    if(defined (&__cplusplus)) {
    }
}
1;
