require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_GCQ_H)) {
    eval 'sub _GCQ_H () {1;}' unless defined(&_GCQ_H);
    if(defined(&_KERNEL)) {
	require 'sys/types.ph';
	require 'sys/null.ph';
	require 'lib/libkern/libkern.ph';
    } else {
	require 'stdbool.ph';
	require 'stdint.ph';
	require 'stddef.ph';
	require 'assert.ph';
    }
    if(defined(&GCQ_USE_ASSERT)) {
	eval 'sub GCQ_ASSERT {
	    my($x) = @_;
    	    eval q( &assert($x));
	}' unless defined(&GCQ_ASSERT);
    } else {
	if(defined(&_KERNEL)) {
	    eval 'sub GCQ_ASSERT {
	        my($x) = @_;
    		eval q( &KASSERT($x));
	    }' unless defined(&GCQ_ASSERT);
	} else {
	    eval 'sub GCQ_ASSERT {
	        my($x) = @_;
    		eval q( &_DIAGASSERT($x));
	    }' unless defined(&GCQ_ASSERT);
	}
    }
    eval 'sub GCQ_INIT {
        my($q) = @_;
	    eval q({ ($q), ($q) });
    }' unless defined(&GCQ_INIT);
    eval 'sub GCQ_INIT_HEAD {
        my($head) = @_;
	    eval q({  &GCQ_INIT(($head). &hq) });
    }' unless defined(&GCQ_INIT_HEAD);
    eval 'sub gcq_q {
        my($q) = @_;
	    eval q({ $q; });
    }' unless defined(&gcq_q);
    eval 'sub gcq_hq {
        my($head) = @_;
	    eval q({ $head; });
    }' unless defined(&gcq_hq);
    eval 'sub gcq_head {
        my($q) = @_;
	    eval q({ $q; });
    }' unless defined(&gcq_head);
    eval 'sub gcq_onlist {
        my($q) = @_;
	    eval q({ ( ($q->{q_next}) != $q); });
    }' unless defined(&gcq_onlist);
    eval 'sub gcq_empty {
        my($head) = @_;
	    eval q({ (! &gcq_onlist( &gcq_hq($head))); });
    }' unless defined(&gcq_empty);
    eval 'sub gcq_linked {
        my($prev,$next) = @_;
	    eval q({ ( ($prev->{q_next}) == $next  &&  ($next->{q_prev}) == $prev); });
    }' unless defined(&gcq_linked);
    if(defined(&GCQ_UNCONDITIONAL_MERGE)) {
    } else {
    }
    eval 'sub GCQ_ITEM {
        my($q, $type, $name) = @_;
	    eval q((($type *)( &void *)(( &uint8_t *) &gcq_q($q) -  &offsetof($type, $name))));
    }' unless defined(&GCQ_ITEM);
    eval 'sub _GCQ_GDQ {
        my($var, $h, $ptr, $fn) = @_;
	    eval q(( &gcq_hq($h)->$ptr !=  &gcq_hq($h) ? ($var = $fn( &gcq_hq($h)->$ptr),  &true) : ($var =  &NULL,  &false)));
    }' unless defined(&_GCQ_GDQ);
    eval 'sub _GCQ_GDQ_TYPED {
        my($tvar, $h, $type, $name, $ptr, $fn) = @_;
	    eval q(( &gcq_hq($h)->$ptr !=  &gcq_hq($h) ? ($tvar =  &GCQ_ITEM($fn( &gcq_hq($h)->$ptr), $type, $name),  &true) : ($tvar =  &NULL,  &false)));
    }' unless defined(&_GCQ_GDQ_TYPED);
    eval 'sub _GCQ_NP {
        my($var, $current, $head, $start, $np, $fn) = @_;
	    eval q(($np($current, $head, $start) != ($start) ? ($var = $fn($np($current, $head, $start)),  &true) : ($var =  &NULL,  &false)));
    }' unless defined(&_GCQ_NP);
    eval 'sub _GCQ_NP_TYPED {
        my($tvar, $current, $head, $start, $type, $name, $np, $fn) = @_;
	    eval q(($np($current, $head, $start) != ($start) ? ($tvar =  &GCQ_ITEM($fn($np($current, $head, $start)), $type, $name),  &true) : ($tvar =  &NULL,  &false)));
    }' unless defined(&_GCQ_NP_TYPED);
    eval 'sub _GCQ_GDQ_COND {
        my($var, $h, $ptr, $rem, $cond) = @_;
	    eval q(( &gcq_hq($h)->$ptr !=  &gcq_hq($h) ? ($var =  &gcq_hq($h)->$ptr, (($cond) ? ($rem,  &true) : ($var =  &NULL,  &false))) : ($var =  &NULL,  &false)));
    }' unless defined(&_GCQ_GDQ_COND);
    eval 'sub _GCQ_GDQ_COND_TYPED {
        my($tvar, $h, $type, $name, $ptr, $rem, $cond) = @_;
	    eval q(( &gcq_hq($h)->$ptr !=  &gcq_hq($h) ? ($tvar =  &GCQ_ITEM( &gcq_hq($h)->$ptr, $type, $name), (($cond) ? ($rem,  &true) : ($tvar =  &NULL,  &false))) : ($tvar =  &NULL,  &false)));
    }' unless defined(&_GCQ_GDQ_COND_TYPED);
    eval 'sub _GCQ_NP_COND {
        my($var, $current, $head, $start, $np, $rem, $cond) = @_;
	    eval q(($np($current, $head, $start) != ($start) ? ($var =  &fn($np($current, $head, $start)), (($cond) ? ($rem),  &true) : ($var =  &NULL,  &false))) : ($var =  &NULL,  &false)));
    }' unless defined(&_GCQ_NP_COND);
    eval 'sub _GCQ_NP_COND_TYPED {
        my($tvar, $current, $head, $start, $type, $name, $np, 	    $rem, $cond) = @_;
	    eval q(($np($current, $head, $start) != ($start) ? ($tvar =  &GCQ_ITEM( &fn($np($current, $head, $start)), $type, $name), (($cond) ? ($rem,  &true) : ( &var =  &NULL,  &false))) : ($tvar =  &NULL,  &false)));
    }' unless defined(&_GCQ_NP_COND_TYPED);
    eval 'sub GCQ_GOT_FIRST {
        my($var, $h) = @_;
	    eval q( &_GCQ_GDQ($var, $h,  &q_next,  &gcq_q));
    }' unless defined(&GCQ_GOT_FIRST);
    eval 'sub GCQ_GOT_LAST {
        my($var, $h) = @_;
	    eval q( &_GCQ_GDQ($var, $h,  &q_prev,  &gcq_q));
    }' unless defined(&GCQ_GOT_LAST);
    eval 'sub GCQ_DEQUEUED_FIRST {
        my($var, $h) = @_;
	    eval q( &_GCQ_GDQ($var, $h,  &q_next,  &gcq_remove));
    }' unless defined(&GCQ_DEQUEUED_FIRST);
    eval 'sub GCQ_DEQUEUED_LAST {
        my($var, $h) = @_;
	    eval q( &_GCQ_GDQ($var, $h,  &q_prev,  &gcq_remove));
    }' unless defined(&GCQ_DEQUEUED_LAST);
    eval 'sub GCQ_GOT_FIRST_TYPED {
        my($tvar, $h, $type, $name) = @_;
	    eval q( &_GCQ_GDQ_TYPED($tvar, $h, $type, $name,  &q_next,  &gcq_q));
    }' unless defined(&GCQ_GOT_FIRST_TYPED);
    eval 'sub GCQ_GOT_LAST_TYPED {
        my($tvar, $h, $type, $name) = @_;
	    eval q( &_GCQ_GDQ_TYPED($tvar, $h, $type, $name,  &q_prev,  &gcq_q));
    }' unless defined(&GCQ_GOT_LAST_TYPED);
    eval 'sub GCQ_DEQUEUED_FIRST_TYPED {
        my($tvar, $h, $type, $name) = @_;
	    eval q( &_GCQ_GDQ_TYPED($tvar, $h, $type, $name,  &q_next,  &gcq_remove));
    }' unless defined(&GCQ_DEQUEUED_FIRST_TYPED);
    eval 'sub GCQ_DEQUEUED_LAST_TYPED {
        my($tvar, $h, $type, $name) = @_;
	    eval q( &_GCQ_GDQ_TYPED($tvar, $h, $type, $name,  &q_prev,  &gcq_remove));
    }' unless defined(&GCQ_DEQUEUED_LAST_TYPED);
    eval 'sub GCQ_GOT_NEXT {
        my($var, $current, $head, $start) = @_;
	    eval q( &_GCQ_NP($var, $current, $head, $start,  &_gcq_next,  &gcq_q));
    }' unless defined(&GCQ_GOT_NEXT);
    eval 'sub GCQ_GOT_PREV {
        my($var, $current, $head, $start) = @_;
	    eval q( &_GCQ_NP($var, $current, $head, $start,  &_gcq_prev,  &gcq_q));
    }' unless defined(&GCQ_GOT_PREV);
    eval 'sub GCQ_DEQUEUED_NEXT {
        my($var, $current, $head, $start) = @_;
	    eval q( &_GCQ_NP($var, $current, $head, $start,  &_gcq_next,  &gcq_remove));
    }' unless defined(&GCQ_DEQUEUED_NEXT);
    eval 'sub GCQ_DEQUEUED_PREV {
        my($var, $current, $head, $start) = @_;
	    eval q( &_GCQ_NP($var, $current, $head, $start,  &_gcq_prev,  &gcq_remove));
    }' unless defined(&GCQ_DEQUEUED_PREV);
    eval 'sub GCQ_GOT_NEXT_TYPED {
        my($tvar, $current, $head, $start, $type, $name) = @_;
	    eval q( &_GCQ_NP_TYPED($tvar, $current, $head, $start, $type, $name,  &_gcq_next,  &gcq_q));
    }' unless defined(&GCQ_GOT_NEXT_TYPED);
    eval 'sub GCQ_GOT_PREV_TYPED {
        my($tvar, $current, $head, $start, $type, $name) = @_;
	    eval q( &_GCQ_NP_TYPED($tvar, $current, $head, $start, $type, $name,  &_gcq_prev,  &gcq_q));
    }' unless defined(&GCQ_GOT_PREV_TYPED);
    eval 'sub GCQ_DEQUEUED_NEXT_TYPED {
        my($tvar, $current, $head, $start, $type, $name) = @_;
	    eval q( &_GCQ_NP_TYPED($tvar, $current, $head, $start, $type, $name,  &_gcq_next,  &gcq_remove));
    }' unless defined(&GCQ_DEQUEUED_NEXT_TYPED);
    eval 'sub GCQ_DEQUEUED_PREV_TYPED {
        my($tvar, $current, $head, $start, $type, $name) = @_;
	    eval q( &_GCQ_NP_TYPED($tvar, $current, $head, $start, $type, $name,  &_gcq_prev,  &gcq_remove));
    }' unless defined(&GCQ_DEQUEUED_PREV_TYPED);
    eval 'sub GCQ_GOT_FIRST_COND {
        my($var, $h, $cond) = @_;
	    eval q( &_GCQ_GDQ_COND($var, $h,  &q_next, (( &void)0), $cond));
    }' unless defined(&GCQ_GOT_FIRST_COND);
    eval 'sub GCQ_GOT_LAST_COND {
        my($var, $h, $cond) = @_;
	    eval q( &_GCQ_GDQ_COND($var, $h,  &q_prev, (( &void)0), $cond));
    }' unless defined(&GCQ_GOT_LAST_COND);
    eval 'sub GCQ_DEQUEUED_FIRST_COND {
        my($var, $h, $cond) = @_;
	    eval q( &_GCQ_GDQ_COND($var, $h,  &q_next,  &gcq_remove($var), $cond));
    }' unless defined(&GCQ_DEQUEUED_FIRST_COND);
    eval 'sub GCQ_DEQUEUED_LAST_COND {
        my($var, $h, $cond) = @_;
	    eval q( &_GCQ_GDQ_COND($var, $h,  &q_prev,  &gcq_remove($var), $cond));
    }' unless defined(&GCQ_DEQUEUED_LAST_COND);
    eval 'sub GCQ_GOT_FIRST_COND_TYPED {
        my($tvar, $h, $type, $name, $cond) = @_;
	    eval q( &_GCQ_GDQ_COND_TYPED($tvar, $h, $type, $name,  &q_next, (( &void)0), $cond));
    }' unless defined(&GCQ_GOT_FIRST_COND_TYPED);
    eval 'sub GCQ_GOT_LAST_COND_TYPED {
        my($tvar, $h, $type, $name, $cond) = @_;
	    eval q( &_GCQ_GDQ_COND_TYPED($tvar, $h, $type, $name,  &q_prev, (( &void)0), $cond));
    }' unless defined(&GCQ_GOT_LAST_COND_TYPED);
    eval 'sub GCQ_DEQUEUED_FIRST_COND_TYPED {
        my($tvar, $h, $type, $name, $cond) = @_;
	    eval q( &_GCQ_GDQ_COND_TYPED($tvar, $h, $type, $name,  &q_next,  &gcq_remove(($tvar)->$name), $cond));
    }' unless defined(&GCQ_DEQUEUED_FIRST_COND_TYPED);
    eval 'sub GCQ_DEQUEUED_LAST_COND_TYPED {
        my($tvar, $h, $type, $name, $cond) = @_;
	    eval q( &_GCQ_GDQ_COND_TYPED($tvar, $h, $type, $name,  &q_prev,  &gcq_remove(($tvar)->$name), $cond));
    }' unless defined(&GCQ_DEQUEUED_LAST_COND_TYPED);
    eval 'sub GCQ_GOT_NEXT_COND {
        my($var, $current, $head, $start, $cond) = @_;
	    eval q( &_GCQ_NP_COND($var, $current, $head, $start,  &_gcq_next, (( &void)0), $cond));
    }' unless defined(&GCQ_GOT_NEXT_COND);
    eval 'sub GCQ_GOT_PREV_COND {
        my($var, $current, $head, $start, $cond) = @_;
	    eval q( &_GCQ_NP_COND($var, $current, $head, $start,  &_gcq_prev, (( &void)0), $cond));
    }' unless defined(&GCQ_GOT_PREV_COND);
    eval 'sub GCQ_DEQUEUED_NEXT_COND {
        my($var, $current, $head, $start, $cond) = @_;
	    eval q( &_GCQ_NP_COND($var, $current, $head, $start,  &_gcq_next,  &gcq_remove($var), $cond));
    }' unless defined(&GCQ_DEQUEUED_NEXT_COND);
    eval 'sub GCQ_DEQUEUED_PREV_COND {
        my($var, $current, $head, $start, $cond) = @_;
	    eval q( &_GCQ_NP_COND($var, $current, $head, $start,  &_gcq_prev,  &gcq_remove($var), $cond));
    }' unless defined(&GCQ_DEQUEUED_PREV_COND);
    eval 'sub GCQ_GOT_NEXT_COND_TYPED {
        my($tvar, $current, $head, $start, $type, $name,     $cond) = @_;
	    eval q( &_GCQ_NP_COND_TYPED($tvar, $current, $head, $start, $type, $name,  &_gcq_next, (( &void)0), $cond));
    }' unless defined(&GCQ_GOT_NEXT_COND_TYPED);
    eval 'sub GCQ_GOT_PREV_COND_TYPED {
        my($tvar, $current, $head, $start, $type, $name,     $cond) = @_;
	    eval q( &_GCQ_NP_COND_TYPED($tvar, $current, $head, $start, $type, $name,  &_gcq_prev, (( &void)0), $cond));
    }' unless defined(&GCQ_GOT_PREV_COND_TYPED);
    eval 'sub GCQ_DEQUEUED_NEXT_COND_TYPED {
        my($tvar, $current, $head, $start, $type, 	    $name, $cond) = @_;
	    eval q( &_GCQ_NP_COND_TYPED($tvar, $current, $head, $start, $type, $name,  &_gcq_next,  &gcq_remove(($tvar)->$name), $cond));
    }' unless defined(&GCQ_DEQUEUED_NEXT_COND_TYPED);
    eval 'sub GCQ_DEQUEUED_PREV_COND_TYPED {
        my($tvar, $current, $head, $start, $type, 	    $name, $cond) = @_;
	    eval q( &_GCQ_NP_COND_TYPED($tvar, $current, $head, $start, $type, $name,  &_gcq_prev,  &gcq_remove(($tvar)->$name), $cond));
    }' unless defined(&GCQ_DEQUEUED_PREV_COND_TYPED);
    eval 'sub _GCQ_FOREACH {
        my($var, $h, $tnull, $item, $ptr) = @_;
	    eval q( &for (($var)= &gcq_hq($h)->$ptr; (($var) !=  &gcq_hq($h)  && ( &GCQ_ASSERT( &gcq_onlist($var)), $item,  &true)) || ($tnull,  &false); ($var)=($var)->$ptr));
    }' unless defined(&_GCQ_FOREACH);
    eval 'sub _GCQ_FOREACH_NVAR {
        my($var, $nvar, $h, $tnull, $item, $ptr, $ol, $rem, $ro) = @_;
	    eval q( &for (($nvar)= &gcq_hq($h)->$ptr; ((($var)=($nvar), ($nvar) !=  &gcq_hq($h))  && ($ol, ($nvar)=($nvar)->$ptr, $rem, $item,  &true)) || ($tnull,  &false); $ro));
    }' unless defined(&_GCQ_FOREACH_NVAR);
    eval 'sub GCQ_FOREACH {
        my($var, $h) = @_;
	    eval q( &_GCQ_FOREACH($var, $h, (( &void)0), (( &void)0),  &q_next));
    }' unless defined(&GCQ_FOREACH);
    eval 'sub GCQ_FOREACH_REV {
        my($var, $h) = @_;
	    eval q( &_GCQ_FOREACH($var, $h, (( &void)0), (( &void)0),  &q_prev));
    }' unless defined(&GCQ_FOREACH_REV);
    eval 'sub GCQ_FOREACH_NVAR {
        my($var, $nvar, $h) = @_;
	    eval q( &_GCQ_FOREACH_NVAR($var, $nvar, $h, (( &void)0), (( &void)0),  &q_next,  &GCQ_ASSERT( &gcq_onlist($nvar)), (( &void)0), (( &void)0)));
    }' unless defined(&GCQ_FOREACH_NVAR);
    eval 'sub GCQ_FOREACH_NVAR_REV {
        my($var, $nvar, $h) = @_;
	    eval q( &_GCQ_FOREACH_NVAR($var, $nvar, $h, (( &void)0), (( &void)0),  &q_prev,  &GCQ_ASSERT( &gcq_onlist($nvar)), (( &void)0), (( &void)0)));
    }' unless defined(&GCQ_FOREACH_NVAR_REV);
    eval 'sub GCQ_FOREACH_RO {
        my($var, $nvar, $h) = @_;
	    eval q( &_GCQ_FOREACH_NVAR($var, $nvar, $h, (( &void)0), (( &void)0),  &q_next, (( &void)0), (( &void)0),  &GCQ_ASSERT( &gcq_linked($var, $nvar))));
    }' unless defined(&GCQ_FOREACH_RO);
    eval 'sub GCQ_FOREACH_RO_REV {
        my($var, $nvar, $h) = @_;
	    eval q( &_GCQ_FOREACH_NVAR($var, $nvar, $h, (( &void)0), (( &void)0),  &q_prev, (( &void)0), (( &void)0),  &GCQ_ASSERT( &gcq_linked($nvar, $var))));
    }' unless defined(&GCQ_FOREACH_RO_REV);
    eval 'sub GCQ_FOREACH_DEQUEUED {
        my($var, $nvar, $h) = @_;
	    eval q( &_GCQ_FOREACH_NVAR($var, $nvar, $h, (( &void)0), (( &void)0),  &q_next,  &GCQ_ASSERT( &gcq_onlist($nvar)),  &gcq_remove($var), (( &void)0));
    }' unless defined(&GCQ_FOREACH_DEQUEUED);
    eval 'sub GCQ_FOREACH_DEQUEUED_REV {
        my($var, $nvar, $h) = @_;
	    eval q( &_GCQ_FOREACH_NVAR($var, $nvar, $h, (( &void)0), (( &void)0),  &q_prev,  &GCQ_ASSERT( &gcq_onlist($nvar)),  &gcq_remove($var), (( &void)0));
    }' unless defined(&GCQ_FOREACH_DEQUEUED_REV);
    eval 'sub GCQ_FOREACH_TYPED {
        my($var, $h, $tvar, $type, $name) = @_;
	    eval q( &_GCQ_FOREACH($var, $h, ($tvar)= &NULL, ($tvar)= &GCQ_ITEM($var, $type, $name),  &q_next));
    }' unless defined(&GCQ_FOREACH_TYPED);
    eval 'sub GCQ_FOREACH_TYPED_REV {
        my($var, $h, $tvar, $type, $name) = @_;
	    eval q( &_GCQ_FOREACH($var, $h, ($tvar)= &NULL, ($tvar)= &GCQ_ITEM($var, $type, $name),  &q_prev));
    }' unless defined(&GCQ_FOREACH_TYPED_REV);
    eval 'sub GCQ_FOREACH_NVAR_TYPED {
        my($var, $nvar, $h, $tvar, $type, $name) = @_;
	    eval q( &_GCQ_FOREACH_NVAR($var, $nvar, $h, ($tvar)= &NULL, ($tvar)= &GCQ_ITEM($var, $type, $name),  &q_next,  &GCQ_ASSERT( &gcq_onlist($nvar)), (( &void)0), (( &void)0)));
    }' unless defined(&GCQ_FOREACH_NVAR_TYPED);
    eval 'sub GCQ_FOREACH_NVAR_REV_TYPED {
        my($var, $nvar, $h, $tvar, $type, $name) = @_;
	    eval q( &_GCQ_FOREACH_NVAR($var, $nvar, $h, ($tvar)= &NULL, ($tvar)= &GCQ_ITEM($var, $type, $name),  &q_prev,  &GCQ_ASSERT( &gcq_onlist($nvar)), (( &void)0), (( &void)0)));
    }' unless defined(&GCQ_FOREACH_NVAR_REV_TYPED);
    eval 'sub GCQ_FOREACH_RO_TYPED {
        my($var, $nvar, $h, $tvar, $type, $name) = @_;
	    eval q( &_GCQ_FOREACH_NVAR($var, $nvar, $h, ($tvar)= &NULL, ($tvar)= &GCQ_ITEM($var, $type, $name),  &q_next, (( &void)0), (( &void)0),  &GCQ_ASSERT( &gcq_lined($var, $nvar))));
    }' unless defined(&GCQ_FOREACH_RO_TYPED);
    eval 'sub GCQ_FOREACH_RO_REV_TYPED {
        my($var, $nvar, $h, $tvar, $type, $name) = @_;
	    eval q( &_GCQ_FOREACH_NVAR($var, $nvar, $h, ($tvar)= &NULL, ($tvar)= &GCQ_ITEM($var, $type, $name),  &q_prev, (( &void)0), (( &void)0),  &GCQ_ASSERT( &gcq_linked($nvar, $var))));
    }' unless defined(&GCQ_FOREACH_RO_REV_TYPED);
    eval 'sub GCQ_FOREACH_DEQUEUED_TYPED {
        my($var, $nvar, $h, $tvar, $type, $name) = @_;
	    eval q( &_GCQ_FOREACH_NVAR($var, $nvar, $h, ($tvar)= &NULL, ($tvar)= &GCQ_ITEM($var, $type, $name),  &q_next,  &GCQ_ASSERT( &gcq_onlist($nvar)),  &gcq_remove($var), (( &void)0)));
    }' unless defined(&GCQ_FOREACH_DEQUEUED_TYPED);
    eval 'sub GCQ_FOREACH_DEQUEUED_REV_TYPED {
        my($var, $nvar, $h, $tvar, $type, $name) = @_;
	    eval q( &_GCQ_FOREACH_NVAR($var, $nvar, $h, ($tvar)= &NULL, ($tvar)= &GCQ_ITEM($var, $type, $name),  &q_prev,  &GCQ_ASSERT( &gcq_onlist($nvar)),  &gcq_remove($var), (( &void)0)));
    }' unless defined(&GCQ_FOREACH_DEQUEUED_REV_TYPED);
    eval 'sub _GCQ_COND {
        my($fe, $cond) = @_;
	    eval q( &do { $fe {  &if ($cond)  &break; } }  &while (0));
    }' unless defined(&_GCQ_COND);
    eval 'sub GCQ_FIND {
        my($var, $h, $cond) = @_;
	    eval q( &_GCQ_COND( &GCQ_FOREACH($var, $h), $cond));
    }' unless defined(&GCQ_FIND);
    eval 'sub GCQ_FIND_REV {
        my($var, $h, $cond) = @_;
	    eval q( &_GCQ_COND( &GCQ_FOREACH_REV($var, $h), $cond));
    }' unless defined(&GCQ_FIND_REV);
    eval 'sub GCQ_FIND_TYPED {
        my($var, $h, $tvar, $type, $name, $cond) = @_;
	    eval q( &_GCQ_COND( &GCQ_FOREACH_TYPED($var, $h, $tvar, $type, $name), $cond));
    }' unless defined(&GCQ_FIND_TYPED);
    eval 'sub GCQ_FIND_TYPED_REV {
        my($var, $h, $tvar, $type, $name, $cond) = @_;
	    eval q( &_GCQ_COND( &GCQ_FOREACH_REV_TYPED($var, $h, $tvar, $type, $name), $cond));
    }' unless defined(&GCQ_FIND_TYPED_REV);
}
1;
