/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.network.SSLConnector;
import org.parosproxy.paros.view.AboutWindow;
import org.parosproxy.paros.view.LicenseFrame;
import org.parosproxy.paros.view.View;

public class Paros {
    private static Log log;
    private CommandLine cmdLine = null;
    static /* synthetic */ Class class$org$parosproxy$paros$Paros;

    public static void main(String[] stringArray) throws Exception {
        Paros paros = new Paros();
        paros.init(stringArray);
        Constant.getInstance();
        String string = "Paros 3.2.13 started.";
        log = LogFactory.getLog(class$org$parosproxy$paros$Paros == null ? (class$org$parosproxy$paros$Paros = Paros.class$("org.parosproxy.paros.Paros")) : class$org$parosproxy$paros$Paros);
        log.info(string);
        try {
            paros.run();
        }
        catch (Exception exception) {
            log.fatal(exception.getStackTrace());
            throw exception;
        }
    }

    private void init(String[] stringArray) {
        HttpSender.setUserAgent("Paros/3.2.13");
        try {
            this.cmdLine = new CommandLine(stringArray);
        }
        catch (Exception exception) {
            System.out.println(CommandLine.getHelpGeneral());
            System.exit(1);
        }
        Locale.setDefault(Locale.ENGLISH);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void run() throws Exception {
        this.checkUpdate();
        AboutWindow aboutWindow = null;
        if (this.cmdLine.isGUI()) {
            this.showLicense();
            aboutWindow = new AboutWindow();
            aboutWindow.setVisible(true);
        }
        Model.getSingleton().init();
        Model.getSingleton().getOptionsParam().setGUI(this.cmdLine.isGUI());
        if (Model.getSingleton().getOptionsParam().isGUI()) {
            this.runGUI();
            aboutWindow.dispose();
        } else {
            this.runCommandLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCommandLine() {
        int n = 0;
        String string = "";
        Control.initSingletonWithoutView();
        Control control = Control.getSingleton();
        try {
            control.getExtensionLoader().hookCommandLineListener(this.cmdLine);
            if (this.cmdLine.isEnabled("-help") || this.cmdLine.isEnabled("-h")) {
                string = this.cmdLine.getHelp();
                System.out.println(string);
            } else {
                control.runCommandLineNewSession(this.cmdLine.getArgument("-newsession"));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            n = 0;
        }
        catch (Exception exception) {
            log.error(exception.getMessage());
            System.out.println(exception.getMessage());
            n = 1;
        }
        finally {
            control.shutdown(false);
            log.info("Paros 3.2.13 terminated.");
        }
        System.exit(n);
    }

    private void runGUI() throws ClassNotFoundException, Exception {
        Control.initSingletonWithView();
        Control control = Control.getSingleton();
        View view = View.getSingleton();
        view.postInit();
        view.getMainFrame().setExtendedState(6);
        view.getMainFrame().setVisible(true);
        view.setStatus("");
        control.getMenuFileControl().newSession(false);
    }

    private void showLicense() {
        Object object;
        if (!new File(Constant.getInstance().ACCEPTED_LICENSE).exists()) {
            object = new LicenseFrame();
            ((LicenseFrame)object).setVisible(true);
            while (!((LicenseFrame)object).isAccepted()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            object = new FileWriter(Constant.getInstance().ACCEPTED_LICENSE);
            ((OutputStreamWriter)object).close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(new JFrame(), "Unknown Error. Please report to the author.");
            System.exit(1);
        }
    }

    private void checkUpdate() {
        if (!Constant.isWindows()) {
            return;
        }
        File file = new File(System.getProperty("user.dir") + File.separator + "parosnew.exe");
        String string = System.getProperty("user.dir");
        String[] stringArray = new String[]{"cmd.exe", "/C", "autoupd.bat", "\"" + string + "\""};
        if (file.exists()) {
            try {
                Process process = Runtime.getRuntime().exec(stringArray, null, new File(string));
                System.exit(0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ProtocolSocketFactory protocolSocketFactory = null;
        try {
            Protocol protocol = Protocol.getProtocol("https");
            protocolSocketFactory = protocol.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (protocolSocketFactory == null || !(protocolSocketFactory instanceof SSLConnector)) {
            Protocol.registerProtocol("https", new Protocol("https", (ProtocolSocketFactory)new SSLConnector(), 443));
        }
        log = null;
    }
}

