/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.library;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesNode;
import com.intellij.ide.projectView.impl.nodes.SyntheticLibraryElementNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.pom.NavigatableWithText;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExternalLibrariesNodePatcher
implements TreeStructureProvider,
DumbAware {
    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        if (parent == null) {
            PhpExternalLibrariesNodePatcher.$$$reportNull$$$0(0);
        }
        if (children == null) {
            PhpExternalLibrariesNodePatcher.$$$reportNull$$$0(1);
        }
        if (!PlatformUtils.isPhpStorm()) {
            Collection<AbstractTreeNode> collection = children;
            if (collection == null) {
                PhpExternalLibrariesNodePatcher.$$$reportNull$$$0(2);
            }
            return collection;
        }
        List list = ContainerUtil.map(children, abstractTreeNode -> PhpExternalLibrariesNodePatcher.patch(abstractTreeNode));
        if (list == null) {
            PhpExternalLibrariesNodePatcher.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static AbstractTreeNode patch(AbstractTreeNode node) {
        if (node instanceof ExternalLibrariesNode) {
            return new PatchedExternalLibrariesNode(node.getProject(), ((ExternalLibrariesNode)node).getSettings());
        }
        SyntheticLibraryElementNode libraryElementNode = PhpExternalLibrariesNodePatcher.getAsPhpLibraryNode(node);
        if (libraryElementNode != null && libraryElementNode.getValue() instanceof ItemPresentation && libraryElementNode.getProject() != null) {
            return new PatchedLibraryNode(libraryElementNode.getProject(), (SyntheticLibrary)libraryElementNode.getValue(), (ItemPresentation)libraryElementNode.getValue(), libraryElementNode.getSettings());
        }
        return node;
    }

    @Nullable
    public static SyntheticLibraryElementNode getAsPhpLibraryNode(AbstractTreeNode node) {
        if (node instanceof SyntheticLibraryElementNode && "PHP".equals(node.getName())) {
            return (SyntheticLibraryElementNode)node;
        }
        return null;
    }

    private static void openSettings(Project project) {
        PhpProjectConfigurable.createFix(project).run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/library/PhpExternalLibrariesNodePatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/library/PhpExternalLibrariesNodePatcher";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PatchedLibraryNode
    extends SyntheticLibraryElementNode
    implements NavigatableWithText {
        PatchedLibraryNode(@NotNull Project project, @NotNull SyntheticLibrary library, @NotNull ItemPresentation itemPresentation, ViewSettings settings) {
            if (project == null) {
                PatchedLibraryNode.$$$reportNull$$$0(0);
            }
            if (library == null) {
                PatchedLibraryNode.$$$reportNull$$$0(1);
            }
            if (itemPresentation == null) {
                PatchedLibraryNode.$$$reportNull$$$0(2);
            }
            super(project, library, itemPresentation, settings);
        }

        public boolean canNavigate() {
            return true;
        }

        public void navigate(boolean requestFocus) {
            PhpExternalLibrariesNodePatcher.openSettings(this.myProject);
        }

        public String getNavigateActionText(boolean focusEditor) {
            return PhpBundle.message("configure.php.include.paths", new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "library";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "itemPresentation";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/config/library/PhpExternalLibrariesNodePatcher$PatchedLibraryNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PatchedExternalLibrariesNode
    extends ExternalLibrariesNode
    implements NavigatableWithText {
        PatchedExternalLibrariesNode(Project project, ViewSettings viewSettings) {
            super(project, viewSettings);
        }

        public boolean canNavigate() {
            return true;
        }

        public void navigate(boolean requestFocus) {
            PhpExternalLibrariesNodePatcher.openSettings(this.myProject);
        }

        public String getNavigateActionText(boolean focusEditor) {
            return PhpBundle.message("configure.php.include.paths", new Object[0]);
        }
    }
}

