/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phar;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.jetbrains.php.phar.PharCompression;
import com.jetbrains.php.phar.PharHandler;
import com.jetbrains.php.phar.TarHandler;
import org.jetbrains.annotations.NotNull;

public class PharHandlers {
    public static int fileNameEndIndex(@NotNull String path) {
        if (path == null) {
            PharHandlers.$$$reportNull$$$0(0);
        }
        path = FileUtil.toSystemIndependentName((String)path);
        int p = path.indexOf(".phar");
        while (p > 0) {
            if ((p += ".phar".length()) == path.length() || path.charAt(p) == '/') {
                return p;
            }
            if (PharHandlers.fileNameEndsWith(path, p, ".gz")) {
                return p + 3;
            }
            if (PharHandlers.fileNameEndsWith(path, p, ".bz2") || PharHandlers.fileNameEndsWith(path, p, ".zip") || PharHandlers.fileNameEndsWith(path, p, ".tar")) {
                return p + 4;
            }
            if (PharHandlers.fileNameEndsWith(path, p, ".tar.gz")) {
                return p + 7;
            }
            if (PharHandlers.fileNameEndsWith(path, p, ".tar.bz2")) {
                return p + 8;
            }
            p = path.indexOf(".phar", p);
        }
        return -1;
    }

    private static boolean fileNameEndsWith(String path, int p, String ext) {
        int end = p + ext.length();
        return path.length() >= end && (path.length() == end || path.charAt(end) == '/') && path.regionMatches(p, ext, 0, ext.length());
    }

    @NotNull
    public static ArchiveHandler create(@NotNull String path) {
        if (path == null) {
            PharHandlers.$$$reportNull$$$0(1);
        }
        if (path.endsWith(".phar")) {
            PharHandler pharHandler = new PharHandler(path, PharCompression.NONE);
            if (pharHandler == null) {
                PharHandlers.$$$reportNull$$$0(2);
            }
            return pharHandler;
        }
        if (path.endsWith(".phar.gz")) {
            PharHandler pharHandler = new PharHandler(path, PharCompression.GZ);
            if (pharHandler == null) {
                PharHandlers.$$$reportNull$$$0(3);
            }
            return pharHandler;
        }
        if (path.endsWith(".phar.bz2")) {
            PharHandler pharHandler = new PharHandler(path, PharCompression.BZ2);
            if (pharHandler == null) {
                PharHandlers.$$$reportNull$$$0(4);
            }
            return pharHandler;
        }
        if (path.endsWith(".phar.tar")) {
            TarHandler tarHandler = new TarHandler(path, PharCompression.NONE);
            if (tarHandler == null) {
                PharHandlers.$$$reportNull$$$0(5);
            }
            return tarHandler;
        }
        if (path.endsWith(".phar.tar.gz")) {
            TarHandler tarHandler = new TarHandler(path, PharCompression.GZ);
            if (tarHandler == null) {
                PharHandlers.$$$reportNull$$$0(6);
            }
            return tarHandler;
        }
        if (path.endsWith(".phar.tar.bz2")) {
            TarHandler tarHandler = new TarHandler(path, PharCompression.BZ2);
            if (tarHandler == null) {
                PharHandlers.$$$reportNull$$$0(7);
            }
            return tarHandler;
        }
        if (path.endsWith(".phar.zip")) {
            ZipHandler zipHandler = new ZipHandler(path);
            if (zipHandler == null) {
                PharHandlers.$$$reportNull$$$0(8);
            }
            return zipHandler;
        }
        throw new IllegalArgumentException("Unsupported format: " + path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phar/PharHandlers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phar/PharHandlers";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fileNameEndIndex";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

