/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class PhpNameStyle {
    public static final PhpNameStyle DEFAULT = new PhpNameStyle();
    public static final PhpNameStyle CAPITALIZE = DEFAULT.withCapitalization(Capitalization.CAPITALIZE);
    public static final PhpNameStyle DECAPITALIZE = DEFAULT.withCapitalization(Capitalization.DECAPITALIZE);
    public static final PhpNameStyle UPPERCASE = DEFAULT.withCapitalization(Capitalization.UPPERCASE);
    private final Capitalization myCapitalization;
    private final Pluralization myPluralization;
    private final Style myStyle;

    private PhpNameStyle() {
        this(Capitalization.IGNORE, Pluralization.IGNORE, Style.MIXED);
    }

    private PhpNameStyle(@NotNull Capitalization capitalization, @NotNull Pluralization pluralization, @NotNull Style style) {
        if (capitalization == null) {
            PhpNameStyle.$$$reportNull$$$0(0);
        }
        if (pluralization == null) {
            PhpNameStyle.$$$reportNull$$$0(1);
        }
        if (style == null) {
            PhpNameStyle.$$$reportNull$$$0(2);
        }
        this.myCapitalization = capitalization;
        this.myPluralization = pluralization;
        this.myStyle = style;
    }

    @NotNull
    public PhpNameStyle withCapitalization(@NotNull Capitalization capitalization) {
        if (capitalization == null) {
            PhpNameStyle.$$$reportNull$$$0(3);
        }
        PhpNameStyle phpNameStyle = new PhpNameStyle(capitalization, this.myPluralization, this.myStyle);
        if (phpNameStyle == null) {
            PhpNameStyle.$$$reportNull$$$0(4);
        }
        return phpNameStyle;
    }

    @NotNull
    public PhpNameStyle withPluralization(@NotNull Pluralization pluralization) {
        if (pluralization == null) {
            PhpNameStyle.$$$reportNull$$$0(5);
        }
        PhpNameStyle phpNameStyle = new PhpNameStyle(this.myCapitalization, pluralization, this.myStyle);
        if (phpNameStyle == null) {
            PhpNameStyle.$$$reportNull$$$0(6);
        }
        return phpNameStyle;
    }

    @NotNull
    public PhpNameStyle withStyle(@NotNull Style style) {
        if (style == null) {
            PhpNameStyle.$$$reportNull$$$0(7);
        }
        PhpNameStyle phpNameStyle = new PhpNameStyle(this.myCapitalization, this.myPluralization, style);
        if (phpNameStyle == null) {
            PhpNameStyle.$$$reportNull$$$0(8);
        }
        return phpNameStyle;
    }

    @NotNull
    public List<String> generateNames(@NotNull List<String> nameParts) {
        if (nameParts == null) {
            PhpNameStyle.$$$reportNull$$$0(9);
        }
        Function<String, String> capitalizer = this.getCapitalizer();
        Function<String, String> pluralizer = this.getPluralizer();
        List generatedNames = ContainerUtil.newSmartList();
        for (int i = 0; i < nameParts.size(); ++i) {
            String generatedName;
            String firstNamePart = nameParts.get(i);
            if (firstNamePart.charAt(0) == '_' || !Character.isLetter(firstNamePart.charAt(0))) continue;
            switch (this.myStyle) {
                case CAMEL_CASE: {
                    generatedName = ((StreamEx)StreamEx.of(nameParts).skip((long)i)).without((Object)"_").map(StringUtil::capitalize).joining();
                    generatedName = capitalizer.andThen(pluralizer).apply(generatedName);
                    break;
                }
                case SNAKE_CASE: {
                    generatedName = ((StreamEx)StreamEx.of(nameParts).skip((long)i)).without((Object)"_").map(capitalizer).joining((CharSequence)"_");
                    generatedName = pluralizer.apply(generatedName);
                    break;
                }
                default: {
                    generatedName = ((StreamEx)StreamEx.of(nameParts).skip((long)i)).joining();
                    generatedName = capitalizer.andThen(pluralizer).apply(generatedName);
                }
            }
            if (!StringUtil.isNotEmpty((String)generatedName)) continue;
            generatedNames.add(generatedName);
        }
        List list = generatedNames;
        if (list == null) {
            PhpNameStyle.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private Function<String, String> getCapitalizer() {
        switch (this.myCapitalization) {
            case CAPITALIZE: {
                Function<String, String> function = StringUtil::capitalize;
                if (function == null) {
                    PhpNameStyle.$$$reportNull$$$0(11);
                }
                return function;
            }
            case DECAPITALIZE: {
                Function<String, String> function = StringUtil::decapitalize;
                if (function == null) {
                    PhpNameStyle.$$$reportNull$$$0(12);
                }
                return function;
            }
            case UPPERCASE: {
                Function<String, String> function = StringUtil::toUpperCase;
                if (function == null) {
                    PhpNameStyle.$$$reportNull$$$0(13);
                }
                return function;
            }
        }
        Function<String, String> function = Function.identity();
        if (function == null) {
            PhpNameStyle.$$$reportNull$$$0(14);
        }
        return function;
    }

    @NotNull
    private Function<String, String> getPluralizer() {
        switch (this.myPluralization) {
            case PLURALIZE: {
                Function<String, String> function = StringUtil::pluralize;
                if (function == null) {
                    PhpNameStyle.$$$reportNull$$$0(15);
                }
                return function;
            }
            case UNPLURALIZE: {
                Function<String, String> function = StringUtil::unpluralize;
                if (function == null) {
                    PhpNameStyle.$$$reportNull$$$0(16);
                }
                return function;
            }
        }
        Function<String, String> function = Function.identity();
        if (function == null) {
            PhpNameStyle.$$$reportNull$$$0(17);
        }
        return function;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capitalization";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluralization";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/PhpNameStyle";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameParts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/PhpNameStyle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withCapitalization";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withPluralization";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withStyle";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNames";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapitalizer";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluralizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withCapitalization";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withPluralization";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withStyle";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Style {
        MIXED,
        CAMEL_CASE,
        SNAKE_CASE;

    }

    public static enum Pluralization {
        IGNORE,
        PLURALIZE,
        UNPLURALIZE;

    }

    public static enum Capitalization {
        IGNORE,
        CAPITALIZE,
        DECAPITALIZE,
        UPPERCASE;

    }
}

