/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.LogMessageEx;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Layout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogMessage
extends AbstractMessage {
    private final Throwable myThrowable;
    private final String myMessage;
    private final List<Attachment> myAttachments;

    LogMessage(Throwable throwable, String message, List<Attachment> attachments) {
        this.myThrowable = ThrowableInterner.intern((Throwable)throwable);
        String str = message;
        if (str != null && throwable.getMessage() != null && (str = StringUtil.trimStart((String)str, (String)throwable.getMessage())) != message) {
            str = StringUtil.trimStart((String)str, (String)": ");
        }
        if ("null".equals(str)) {
            str = null;
        }
        this.myMessage = StringUtil.nullize((String)str, (boolean)true);
        this.myAttachments = new ArrayList<Attachment>(ContainerUtil.filter(attachments, attachment -> attachment != null));
    }

    @Override
    @NotNull
    public Throwable getThrowable() {
        Throwable throwable = this.myThrowable;
        if (throwable == null) {
            LogMessage.$$$reportNull$$$0(0);
        }
        return throwable;
    }

    @Override
    @NotNull
    public String getThrowableText() {
        String string = StringUtil.join((String[])IdeaLogger.getThrowableRenderer().doRender(this.myThrowable), (String)Layout.LINE_SEP);
        if (string == null) {
            LogMessage.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getMessage() {
        String string = this.myMessage != null ? this.myMessage : "";
        if (string == null) {
            LogMessage.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public List<Attachment> getAllAttachments() {
        List<Attachment> list2 = Collections.unmodifiableList(this.myAttachments);
        if (list2 == null) {
            LogMessage.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Deprecated
    public synchronized void addAttachment(@NotNull Attachment attachment) {
        if (attachment == null) {
            LogMessage.$$$reportNull$$$0(4);
        }
        this.myAttachments.add(attachment);
    }

    public static IdeaLoggingEvent createEvent(@NotNull Throwable throwable, @Nullable String userMessage, Attachment ... attachments) {
        if (throwable == null) {
            LogMessage.$$$reportNull$$$0(5);
        }
        if (attachments == null) {
            LogMessage.$$$reportNull$$$0(6);
        }
        LogMessageEx message = new LogMessageEx(throwable, userMessage, Arrays.asList(attachments), null);
        return new IdeaLoggingEvent(userMessage, throwable, (Object)message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/LogMessage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachment";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAttachments";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/LogMessage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAttachment";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createEvent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

