/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.charset.Charset;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ChooseEncodingDialog
extends DialogWrapper {
    private final Charset[] myCharsets;
    private final Charset myDefaultCharset;
    private JList myList;
    private JPanel myPanel;

    protected ChooseEncodingDialog(Charset[] charsets, Charset defaultCharset, VirtualFile virtualFile) {
        super(false);
        this.myCharsets = charsets;
        this.myDefaultCharset = defaultCharset;
        this.$$$setupUI$$$();
        this.setTitle("Choose Encoding for the '" + virtualFile.getName() + "'");
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        AbstractListModel model = new AbstractListModel(){

            @Override
            public int getSize() {
                return ChooseEncodingDialog.this.myCharsets.length;
            }

            @Override
            public Object getElementAt(int i) {
                return ChooseEncodingDialog.this.myCharsets[i];
            }
        };
        this.myList.setModel(model);
        TreeUIHelper.getInstance().installListSpeedSearch(this.myList);
        this.myList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
                Charset charset = (Charset)value;
                this.setText(charset.displayName());
                return component;
            }
        });
        if (this.myDefaultCharset != null) {
            this.myList.setSelectedValue(this.myDefaultCharset, true);
        }
        return this.myPanel;
    }

    protected Charset getChosen() {
        return (Charset)this.myList.getSelectedValue();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "#com.intellij.openapi.vfs.encoding.ChooseEncodingDialog";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this.myList = jBList;
        jBScrollPane.setViewportView((Component)jBList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

