/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import java.awt.Toolkit;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;
import sun.misc.Unsafe;

public class X11UiUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.X11UiUtil");
    private static final int True = 1;
    private static final int False = 0;
    private static final long None = 0L;
    private static final long XA_ATOM = 4L;
    private static final long XA_WINDOW = 33L;
    private static final int CLIENT_MESSAGE = 33;
    private static final int FORMAT_BYTE = 8;
    private static final int FORMAT_LONG = 32;
    private static final long EVENT_MASK = 0x180000L;
    private static final long NET_WM_STATE_TOGGLE = 2L;
    @Nullable
    private static final Xlib X11 = Xlib.access$400();

    @Nullable
    public static String getWmName() {
        if (X11 == null) {
            return null;
        }
        try {
            Long netWmWindow = X11UiUtil.X11.getNetWmWindow();
            if (netWmWindow != null) {
                return X11UiUtil.X11.getUtfStringProperty(netWmWindow, X11.NET_WM_NAME);
            }
        }
        catch (Throwable t) {
            LOG.info("cannot get WM name", t);
        }
        return null;
    }

    public static void patchDetectedWm(String wmName) {
        if (X11 == null || !Registry.is((String)"ide.x11.override.wm")) {
            return;
        }
        try {
            if (wmName.startsWith("Mutter") || "Muffin".equals(wmName) || "GNOME Shell".equals(wmName)) {
                X11UiUtil.setWM("MUTTER_WM", "METACITY_WM");
            } else if ("Marco".equals(wmName)) {
                X11UiUtil.setWM("MARCO_WM", "METACITY_WM");
            } else if ("awesome".equals(wmName)) {
                String version = X11UiUtil.getAwesomeWMVersion();
                if (StringUtil.compareVersionNumbers((String)version, (String)"3.5") >= 0) {
                    X11UiUtil.setWM("SAWFISH_WM");
                } else if (version != null) {
                    X11UiUtil.setWM("OTHER_NONREPARENTING_WM", "LG3D_WM");
                }
            }
        }
        catch (Throwable t) {
            LOG.warn(t);
        }
    }

    private static void setWM(String ... wmConstants) throws Exception {
        Class<?> xwmClass = Class.forName("sun.awt.X11.XWM");
        Object xwm = X11UiUtil.method(xwmClass, "getWM", new Class[0]).invoke(null, new Object[0]);
        if (xwm != null) {
            for (String wmConstant : wmConstants) {
                try {
                    Field wm = X11UiUtil.field(xwmClass, wmConstant);
                    Object id = wm.get(null);
                    if (id == null) continue;
                    X11UiUtil.field(xwmClass, "awt_wmgr").set(null, id);
                    X11UiUtil.field(xwmClass, "WMID").set(xwm, id);
                    LOG.info("impersonated WM: " + wmConstant);
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
        }
    }

    @Nullable
    private static String getAwesomeWMVersion() {
        try {
            Matcher m;
            String version = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"awesome", "--version"}));
            if (version != null && (m = Pattern.compile("awesome v([0-9.]+)").matcher(version)).find()) {
                return m.group(1);
            }
        }
        catch (Throwable t) {
            LOG.warn(t);
        }
        return null;
    }

    public static boolean isFullScreenSupported() {
        if (X11 == null) {
            return false;
        }
        IdeFrame[] frames = WindowManager.getInstance().getAllProjectFrames();
        if (frames.length == 0) {
            return true;
        }
        return frames[0] instanceof JFrame && X11UiUtil.hasWindowProperty((JFrame)frames[0], X11.NET_WM_ALLOWED_ACTIONS, X11.NET_WM_ACTION_FULLSCREEN);
    }

    public static boolean isInFullScreenMode(JFrame frame) {
        return X11 != null && X11UiUtil.hasWindowProperty(frame, X11.NET_WM_STATE, X11.NET_WM_STATE_FULLSCREEN);
    }

    private static boolean hasWindowProperty(JFrame frame, long name, long expected) {
        if (X11 == null) {
            return false;
        }
        try {
            long window;
            long[] values;
            Object peer = AWTAccessor.getComponentAccessor().getPeer(frame);
            if (peer != null && (values = X11UiUtil.X11.getLongArrayProperty(window = ((Long)X11.getWindow.invoke(peer, new Object[0])).longValue(), name, 4L)) != null) {
                for (long value : values) {
                    if (value != expected) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Throwable t) {
            LOG.info("cannot check window property", t);
            return false;
        }
    }

    public static void toggleFullScreenMode(JFrame frame) {
        if (X11 == null) {
            return;
        }
        try {
            Object peer = AWTAccessor.getComponentAccessor().getPeer(frame);
            if (peer == null) {
                throw new IllegalStateException(frame + " has no peer");
            }
            long window = (Long)X11.getWindow.invoke(peer, new Object[0]);
            long screen = (Long)X11.getScreenNumber.invoke(peer, new Object[0]);
            long rootWindow = X11UiUtil.X11.getRootWindow(screen);
            X11UiUtil.X11.sendClientMessage(rootWindow, window, X11.NET_WM_STATE, new long[]{2L, X11.NET_WM_STATE_FULLSCREEN});
        }
        catch (Throwable t) {
            LOG.info("cannot toggle mode", t);
        }
    }

    private static Method method(Class<?> aClass, String name, Class<?> ... parameterTypes) throws Exception {
        while (aClass != null) {
            try {
                Method method = aClass.getDeclaredMethod(name, parameterTypes);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException e) {
                aClass = aClass.getSuperclass();
            }
        }
        throw new NoSuchMethodException(name);
    }

    private static Method method(Class<?> aClass, String name, int parameters) throws Exception {
        for (Method method : aClass.getDeclaredMethods()) {
            if (!name.equals(method.getName()) || method.getParameterTypes().length != parameters) continue;
            method.setAccessible(true);
            return method;
        }
        throw new NoSuchMethodException(name);
    }

    private static Field field(Class<?> aClass, String name) throws Exception {
        Field field = aClass.getDeclaredField(name);
        field.setAccessible(true);
        return field;
    }

    private static class Xlib {
        private Unsafe unsafe;
        private Method XGetWindowProperty;
        private Method XFree;
        private Method RootWindow;
        private Method XSendEvent;
        private Method getWindow;
        private Method getScreenNumber;
        private Method awtLock;
        private Method awtUnlock;
        private long display;
        private long UTF8_STRING;
        private long NET_SUPPORTING_WM_CHECK;
        private long NET_WM_NAME;
        private long NET_WM_ALLOWED_ACTIONS;
        private long NET_WM_STATE;
        private long NET_WM_ACTION_FULLSCREEN;
        private long NET_WM_STATE_FULLSCREEN;

        private Xlib() {
        }

        @Nullable
        private static Xlib getInstance() {
            Class<?> toolkitClass = Toolkit.getDefaultToolkit().getClass();
            if (!SystemInfo.isXWindow || !"sun.awt.X11.XToolkit".equals(toolkitClass.getName())) {
                return null;
            }
            try {
                Xlib x11 = new Xlib();
                Class<?> XlibWrapper = Class.forName("sun.awt.X11.XlibWrapper");
                x11.unsafe = AtomicFieldUpdater.getUnsafe();
                x11.XGetWindowProperty = X11UiUtil.method(XlibWrapper, "XGetWindowProperty", 12);
                x11.XFree = X11UiUtil.method(XlibWrapper, "XFree", 1);
                x11.RootWindow = X11UiUtil.method(XlibWrapper, "RootWindow", 2);
                x11.XSendEvent = X11UiUtil.method(XlibWrapper, "XSendEvent", 5);
                Class<?> XBaseWindow = Class.forName("sun.awt.X11.XBaseWindow");
                x11.getWindow = X11UiUtil.method(XBaseWindow, "getWindow", new Class[0]);
                x11.getScreenNumber = X11UiUtil.method(XBaseWindow, "getScreenNumber", new Class[0]);
                x11.display = (Long)X11UiUtil.method(toolkitClass, "getDisplay", new Class[0]).invoke(null, new Object[0]);
                x11.awtLock = X11UiUtil.method(toolkitClass, "awtLock", new Class[0]);
                x11.awtUnlock = X11UiUtil.method(toolkitClass, "awtUnlock", new Class[0]);
                Class<?> XAtom = Class.forName("sun.awt.X11.XAtom");
                Method get2 = X11UiUtil.method(XAtom, "get", new Class[]{String.class});
                Field atom = X11UiUtil.field(XAtom, "atom");
                x11.UTF8_STRING = (Long)atom.get(get2.invoke(null, "UTF8_STRING"));
                x11.NET_SUPPORTING_WM_CHECK = (Long)atom.get(get2.invoke(null, "_NET_SUPPORTING_WM_CHECK"));
                x11.NET_WM_NAME = (Long)atom.get(get2.invoke(null, "_NET_WM_NAME"));
                x11.NET_WM_ALLOWED_ACTIONS = (Long)atom.get(get2.invoke(null, "_NET_WM_ALLOWED_ACTIONS"));
                x11.NET_WM_STATE = (Long)atom.get(get2.invoke(null, "_NET_WM_STATE"));
                x11.NET_WM_ACTION_FULLSCREEN = (Long)atom.get(get2.invoke(null, "_NET_WM_ACTION_FULLSCREEN"));
                x11.NET_WM_STATE_FULLSCREEN = (Long)atom.get(get2.invoke(null, "_NET_WM_STATE_FULLSCREEN"));
                Long netWmWindow = x11.getNetWmWindow();
                if (netWmWindow == null) {
                    LOG.info("_NET protocol is not supported");
                    return null;
                }
                return x11;
            }
            catch (Throwable t) {
                LOG.info("cannot initialize", t);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getRootWindow(long screen) throws Exception {
            this.awtLock.invoke(null, new Object[0]);
            try {
                long l = (Long)this.RootWindow.invoke(null, this.display, screen);
                return l;
            }
            finally {
                this.awtUnlock.invoke(null, new Object[0]);
            }
        }

        @Nullable
        private Long getNetWmWindow() throws Exception {
            long rootWindow = this.getRootWindow(0L);
            long[] values = this.getLongArrayProperty(rootWindow, this.NET_SUPPORTING_WM_CHECK, 33L);
            return values != null && values.length > 0 ? Long.valueOf(values[0]) : null;
        }

        @Nullable
        private long[] getLongArrayProperty(long window, long name, long type) throws Exception {
            return (long[])this.getWindowProperty(window, name, type, 32L);
        }

        @Nullable
        private String getUtfStringProperty(long window, long name) throws Exception {
            byte[] bytes = (byte[])this.getWindowProperty(window, name, this.UTF8_STRING, 8L);
            return bytes != null ? new String(bytes, CharsetToolkit.UTF8_CHARSET) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private <T> T getWindowProperty(long window, long name, long type, long expectedFormat) throws Exception {
            long data = this.unsafe.allocateMemory(64L);
            this.awtLock.invoke(null, new Object[0]);
            try {
                this.unsafe.setMemory(data, 64L, (byte)0);
                int result2 = (Integer)this.XGetWindowProperty.invoke(null, this.display, window, name, 0L, 65535L, 0L, type, data, data + 8L, data + 16L, data + 24L, data + 32L);
                if (result2 == 0) {
                    long pointer;
                    int format = this.unsafe.getInt(data + 8L);
                    long l = pointer = SystemInfo.is64Bit ? this.unsafe.getLong(data + 32L) : (long)this.unsafe.getInt(data + 32L);
                    if (pointer != 0L && (long)format == expectedFormat) {
                        int length;
                        int n = length = SystemInfo.is64Bit ? (int)this.unsafe.getLong(data + 16L) : this.unsafe.getInt(data + 16L);
                        if (format == 8) {
                            byte[] bytes = new byte[length];
                            for (int i = 0; i < length; ++i) {
                                bytes[i] = this.unsafe.getByte(pointer + (long)i);
                            }
                            byte[] i = bytes;
                            return (T)i;
                        }
                        if (format == 32) {
                            long[] values = ArrayUtil.newLongArray((int)length);
                            for (int i = 0; i < length; ++i) {
                                values[i] = SystemInfo.is64Bit ? this.unsafe.getLong(pointer + (long)(8 * i)) : (long)this.unsafe.getInt(pointer + (long)(4 * i));
                            }
                            long[] lArray = values;
                            return (T)lArray;
                        }
                        if ((long)format != 0L) {
                            LOG.info("unexpected format: " + format);
                        }
                    }
                    if (pointer != 0L) {
                        this.XFree.invoke(null, pointer);
                    }
                }
            }
            finally {
                this.awtUnlock.invoke(null, new Object[0]);
                this.unsafe.freeMemory(data);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendClientMessage(long target2, long window, long type, long ... data) throws Exception {
            assert (data.length <= 5);
            long event = this.unsafe.allocateMemory(128L);
            this.awtLock.invoke(null, new Object[0]);
            try {
                this.unsafe.setMemory(event, 128L, (byte)0);
                this.unsafe.putInt(event, 33);
                if (!SystemInfo.is64Bit) {
                    this.unsafe.putInt(event + 8L, 1);
                    this.unsafe.putInt(event + 16L, (int)window);
                    this.unsafe.putInt(event + 20L, (int)type);
                    this.unsafe.putInt(event + 24L, 32);
                    for (int i = 0; i < data.length; ++i) {
                        this.unsafe.putInt(event + 28L + (long)(4 * i), (int)data[i]);
                    }
                } else {
                    this.unsafe.putInt(event + 16L, 1);
                    this.unsafe.putLong(event + 32L, window);
                    this.unsafe.putLong(event + 40L, this.NET_WM_STATE);
                    this.unsafe.putInt(event + 48L, 32);
                    for (int i = 0; i < data.length; ++i) {
                        this.unsafe.putLong(event + 56L + (long)(8 * i), data[i]);
                    }
                }
                this.XSendEvent.invoke(null, this.display, target2, false, 0x180000L, event);
            }
            finally {
                this.awtUnlock.invoke(null, new Object[0]);
                this.unsafe.freeMemory(event);
            }
        }

        static /* synthetic */ Xlib access$400() {
            return Xlib.getInstance();
        }
    }
}

