/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.codeInsight.actionCable;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Map;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.rails.model.RailsChannel;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.rename.RenameProcessor;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class RenameByRailsChannelClassProcessor
extends RenameProcessor {
    public boolean canProcessElement(PsiElement element) {
        if (element instanceof RClass) {
            RailsChannel channel = RailsChannel.fromClass((RClass)((RClass)element));
            return channel != null;
        }
        return false;
    }

    public void prepareRenaming(PsiElement element, String newChannelClassName, Map<PsiElement, String> allRenames) {
        Project project;
        PsiManager psiManager;
        PsiFile psiFile;
        RailsChannel channel = RailsChannel.fromClass((RClass)((RClass)element));
        assert (channel != null);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return;
        }
        StandardRailsPaths paths = RailsFacetUtil.getRailsAppPaths((Module)module);
        if (paths == null) {
            return;
        }
        if (!newChannelClassName.endsWith("Channel")) {
            return;
        }
        String channelFileName = element.getContainingFile().getName();
        if (!channelFileName.endsWith("_channel.rb")) {
            return;
        }
        String possibleChannelViewFileName = channelFileName.replace("_channel.rb", ".coffee");
        String assetChannelPath = paths.getChannelClientsRootURL();
        VirtualFile possibleChannelClientFile = VirtualFileManager.getInstance().findFileByUrl(assetChannelPath + '/' + possibleChannelViewFileName);
        if (possibleChannelClientFile != null && possibleChannelClientFile.exists() && !possibleChannelClientFile.isDirectory() && (psiFile = (psiManager = PsiManager.getInstance((Project)(project = element.getProject()))).findFile(possibleChannelClientFile)) != null) {
            String newChannelClientFileName = NamingConventions.toUnderscoreCase((String)newChannelClassName.replace("Channel", ".coffee"));
            allRenames.put((PsiElement)psiFile, newChannelClientFileName);
        }
    }
}

