/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ArgumentInfo {
    private final StringRef myName;
    private final Type myType;

    public ArgumentInfo(@NotNull StringRef name, Type type) {
        if (name == null) {
            ArgumentInfo.$$$reportNull$$$0(0);
        }
        this.myName = name;
        this.myType = type;
    }

    public ArgumentInfo(@NotNull String name, Type type) {
        if (name == null) {
            ArgumentInfo.$$$reportNull$$$0(1);
        }
        this(StringRef.fromString((String)name), type);
    }

    public String getName() {
        return this.myName.getString();
    }

    public Type getType() {
        return this.myType;
    }

    public String getPresentableName() {
        String name = this.myName.getString();
        if (this.myType == Type.ARRAY) {
            return "*" + name;
        }
        if (this.myType == Type.HASH) {
            return "**" + name;
        }
        if (this.myType == Type.BLOCK) {
            return "&" + name;
        }
        if (this.myType == Type.PREDEFINED) {
            return name + "=" + (ApplicationManager.getApplication().isUnitTestMode() ? "..." : "\u2026");
        }
        if (this.myType == Type.NAMED) {
            return name + ":" + (ApplicationManager.getApplication().isUnitTestMode() ? "..." : "\u2026");
        }
        if (this.myType == Type.KEYREQ) {
            return name + ":";
        }
        return name;
    }

    public void serialize(StubOutputStream dataStream) throws IOException {
        switch (this.myType) {
            case SIMPLE: {
                dataStream.writeByte(0);
                break;
            }
            case PREDEFINED: {
                dataStream.writeByte(1);
                break;
            }
            case BLOCK: {
                dataStream.writeByte(2);
                break;
            }
            case ARRAY: {
                dataStream.writeByte(3);
                break;
            }
            case HASH: {
                dataStream.writeByte(4);
                break;
            }
            case NAMED: {
                dataStream.writeByte(5);
                break;
            }
            case KEYREQ: {
                dataStream.writeByte(6);
            }
        }
        dataStream.writeName(this.myName.getString());
    }

    public static ArgumentInfo deSerialize(StubInputStream dataStream) throws IOException {
        Type type;
        byte i = dataStream.readByte();
        switch (i) {
            case 0: {
                type = Type.SIMPLE;
                break;
            }
            case 1: {
                type = Type.PREDEFINED;
                break;
            }
            case 2: {
                type = Type.BLOCK;
                break;
            }
            case 3: {
                type = Type.ARRAY;
                break;
            }
            case 4: {
                type = Type.HASH;
                break;
            }
            case 5: {
                type = Type.NAMED;
                break;
            }
            case 6: {
                type = Type.KEYREQ;
                break;
            }
            default: {
                throw new RuntimeException("Couldn't parse type");
            }
        }
        return new ArgumentInfo(dataStream.readName(), type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArgumentInfo)) {
            return false;
        }
        ArgumentInfo that = (ArgumentInfo)o;
        if (!this.myName.equals((Object)that.myName)) {
            return false;
        }
        return this.myType == that.myType;
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.myType.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/ruby/ruby/lang/psi/controlStructures/methods/ArgumentInfo", "<init>"));
    }

    public static enum Type {
        SIMPLE,
        PREDEFINED,
        BLOCK,
        ARRAY,
        HASH,
        NAMED,
        KEYREQ;


        public boolean hasDefaultValue() {
            return this == NAMED || this == PREDEFINED;
        }

        public boolean hasName() {
            return this == NAMED || this == KEYREQ;
        }

        public boolean isPositional() {
            return this == SIMPLE || this == PREDEFINED;
        }
    }
}

