/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.util.text.VersionComparatorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LanguageLevel {
    RUBY18("ruby18", "1.8"),
    RUBY19("ruby19", "1.9"),
    RUBY20("ruby20", "2.0"),
    RUBY21("ruby21", "2.1"),
    RUBY22("ruby22", "2.2"),
    RUBY23("ruby23", "2.3"),
    RUBY24("ruby24", "2.4"),
    RUBY25("ruby25", "2.5"),
    RUBY26("ruby26", "2.6");

    public static final LanguageLevel DEFAULT;
    private final String myName;
    private final String myShortName;

    private LanguageLevel(String name, String shortName) {
        if (name == null) {
            LanguageLevel.$$$reportNull$$$0(0);
        }
        if (shortName == null) {
            LanguageLevel.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myShortName = shortName;
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    public static LanguageLevel fromString(String languageLevelString) {
        for (LanguageLevel level : LanguageLevel.values()) {
            if (!level.toString().equals(languageLevelString)) continue;
            LanguageLevel languageLevel = level;
            if (languageLevel == null) {
                LanguageLevel.$$$reportNull$$$0(2);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = DEFAULT;
        if (languageLevel == null) {
            LanguageLevel.$$$reportNull$$$0(3);
        }
        return languageLevel;
    }

    @NotNull
    public String getShortName() {
        String string = this.myShortName;
        if (string == null) {
            LanguageLevel.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isGreaterThan(@Nullable LanguageLevel other) {
        return other == null || VersionComparatorUtil.compare((String)this.myShortName, (String)other.getShortName()) > 0;
    }

    public boolean isLessThan(@Nullable LanguageLevel other) {
        return other != null && VersionComparatorUtil.compare((String)this.myShortName, (String)other.getShortName()) < 0;
    }

    static {
        DEFAULT = RUBY21;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/LanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/LanguageLevel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

