/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.ide.ClassUtilCore;
import com.intellij.ide.cloudConfig.CloudConfigProvider;
import com.intellij.ide.customize.CustomizeIDEWizardDialog;
import com.intellij.ide.customize.CustomizeIDEWizardStepsProvider;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.ide.startupWizard.StartupWizard;
import com.intellij.idea.LoggerFactory;
import com.intellij.idea.Main;
import com.intellij.idea.SocketLock;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.JOptionPane;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServer;

public class StartupUtil {
    public static final String NO_SPLASH = "nosplash";
    private static SocketLock ourSocketLock;

    private StartupUtil() {
    }

    public static boolean shouldShowSplash(String[] args) {
        if ("true".equals(System.getProperty(NO_SPLASH))) {
            return false;
        }
        return !Arrays.asList(args).contains(NO_SPLASH);
    }

    public static synchronized void addExternalInstanceListener(@Nullable Consumer<List<String>> consumer) {
        if (ourSocketLock != null) {
            ourSocketLock.setExternalInstanceListener(consumer);
        }
    }

    @Nullable
    public static synchronized BuiltInServer getServer() {
        return ourSocketLock == null ? null : ourSocketLock.getServer();
    }

    static void prepareAndStart(String[] args, AppStarter appStarter) {
        ActivationResult result2;
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)Main.isHeadless((String[])args));
        boolean newConfigFolder = false;
        StartupUtil.checkHiDPISettings();
        if (!Main.isHeadless()) {
            AppUIUtil.updateFrameClass();
            boolean bl = newConfigFolder = !new File(PathManager.getConfigPath()).exists();
        }
        if (!StartupUtil.checkJdkVersion()) {
            System.exit(4);
        }
        System.setProperty("log4j.defaultInitOverride", "true");
        System.setProperty("com.jetbrains.suppressWindowRaise", "true");
        try {
            org.apache.log4j.Logger root = org.apache.log4j.Logger.getRootLogger();
            if (!root.getAllAppenders().hasMoreElements()) {
                root.setLevel(Level.WARN);
                root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (!StartupUtil.checkSystemFolders()) {
            System.exit(5);
        }
        if ((result2 = StartupUtil.lockSystemFolders(args)) == ActivationResult.ACTIVATED) {
            System.exit(0);
        }
        if (result2 != ActivationResult.STARTED) {
            System.exit(6);
        }
        Logger.setFactory(LoggerFactory.class);
        Logger log2 = Logger.getInstance(Main.class);
        StartupUtil.startLogging(log2);
        StartupUtil.loadSystemLibraries(log2);
        StartupUtil.fixProcessEnvironment(log2);
        if (!Main.isHeadless()) {
            UIUtil.initDefaultLAF();
        }
        if (newConfigFolder) {
            appStarter.beforeImportConfigs();
            ConfigImportHelper.importConfigsTo(PathManager.getConfigPath());
        } else {
            StartupUtil.installPluginUpdates();
        }
        if (!Main.isHeadless()) {
            AppUIUtil.updateWindowIcon(JOptionPane.getRootFrame());
            AppUIUtil.registerBundledFonts();
            AppUIUtil.showUserAgreementAndConsentsIfNeeded();
        }
        appStarter.start(newConfigFolder);
    }

    private static boolean checkJdkVersion() {
        if ("true".equals(System.getProperty("idea.jre.check"))) {
            try {
                Class.forName("com.sun.jdi.Field", false, StartupUtil.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                String message = "JDK classes seem to be not on " + ApplicationNamesInfo.getInstance().getProductName() + " classpath.\nPlease ensure you run the IDE on JDK rather than JRE.";
                Main.showMessage((String)"JDK Required", (String)message, (boolean)true);
                return false;
            }
            catch (LinkageError e) {
                String message = "Cannot load a JDK class: " + e.getMessage() + "\nPlease ensure you run the IDE on JDK rather than JRE.";
                Main.showMessage((String)"JDK Required", (String)message, (boolean)true);
                return false;
            }
        }
        if ("true".equals(System.getProperty("idea.64bit.check")) && PlatformUtils.isCidr() && !SystemInfo.is64Bit) {
            String message = "32-bit JVM is not supported. Please use 64-bit version.";
            Main.showMessage((String)"Unsupported JVM", (String)message, (boolean)true);
            return false;
        }
        return true;
    }

    public static void test_checkHiDPISettings() {
        StartupUtil.checkHiDPISettings();
    }

    private static void checkHiDPISettings() {
        if (!SystemProperties.getBooleanProperty((String)"hidpi", (boolean)true)) {
            System.setProperty("sun.java2d.uiScale.enabled", "false");
        }
    }

    private static synchronized boolean checkSystemFolders() {
        String tempInaccessible;
        String configPath = PathManager.getConfigPath();
        PathManager.ensureConfigFolderExists();
        if (!new File(configPath).isDirectory()) {
            String message = "Config path '" + configPath + "' is invalid.\n\nIf you have modified the '" + "idea.config.path" + "' property, please make sure it is correct,\notherwise please re-install the IDE.";
            Main.showMessage((String)"Invalid Config Path", (String)message, (boolean)true);
            return false;
        }
        String systemPath = PathManager.getSystemPath();
        if (!new File(systemPath).isDirectory()) {
            String message = "System path '" + systemPath + "' is invalid.\n\nIf you have modified the '" + "idea.system.path" + "' property, please make sure it is correct,\notherwise please re-install the IDE.";
            Main.showMessage((String)"Invalid System Path", (String)message, (boolean)true);
            return false;
        }
        if (FileUtil.pathsEqual((String)configPath, (String)systemPath)) {
            String message = "Config and system paths seem to be equal.\n\nIf you have modified 'idea.config.path' or 'idea.system.path' properties,\nplease make sure they point to different directories, otherwise please re-install the IDE.";
            Main.showMessage((String)"Invalid Config or System Path", (String)message, (boolean)true);
            return false;
        }
        File logDir = new File(PathManager.getLogPath());
        boolean logOk = false;
        if (logDir.isDirectory() || logDir.mkdirs()) {
            try {
                File ideTempFile = new File(logDir, "idea_log_check.txt");
                StartupUtil.write(ideTempFile, "log check");
                StartupUtil.delete(ideTempFile);
                logOk = true;
            }
            catch (IOException ideTempFile) {
                // empty catch block
            }
        }
        if (!logOk) {
            String message = "Log path '" + logDir.getPath() + "' is inaccessible.\n\nIf you have modified the '" + "idea.log.path" + "' property please make sure it is correct,\notherwise please re-install the IDE.";
            Main.showMessage((String)"Invalid Log Path", (String)message, (boolean)true);
            return false;
        }
        File ideTempDir = new File(PathManager.getTempPath());
        if (!ideTempDir.isDirectory() && !ideTempDir.mkdirs()) {
            tempInaccessible = "unable to create the directory";
        } else {
            try {
                File ideTempFile = new File(ideTempDir, "idea_tmp_check.sh");
                StartupUtil.write(ideTempFile, "#!/bin/sh\nexit 0");
                tempInaccessible = SystemInfo.isWindows || SystemInfo.isMac ? null : (!ideTempFile.setExecutable(true, true) ? "cannot set executable permission" : (new ProcessBuilder(ideTempFile.getAbsolutePath()).start().waitFor() != 0 ? "cannot execute test script" : null));
                StartupUtil.delete(ideTempFile);
            }
            catch (Exception e) {
                tempInaccessible = e.getClass().getSimpleName() + ": " + e.getMessage();
            }
        }
        if (tempInaccessible != null) {
            String message = "Temp directory '" + ideTempDir + "' is inaccessible.\n\nIf you have modified the '" + "idea.system.path" + "' property please make sure it is correct,\notherwise please re-install the IDE.\n\nDetails: " + tempInaccessible;
            Main.showMessage((String)"Invalid System Path", (String)message, (boolean)true);
            return false;
        }
        return true;
    }

    private static void write(File file2, String content) throws IOException {
        try (FileWriter writer = new FileWriter(file2);){
            writer.write(content);
        }
    }

    private static void delete(File ideTempFile) {
        if (!FileUtilRt.delete((File)ideTempFile)) {
            ideTempFile.deleteOnExit();
        }
    }

    @NotNull
    private static synchronized ActivationResult lockSystemFolders(String[] args) {
        SocketLock.ActivateStatus status;
        if (ourSocketLock != null) {
            throw new AssertionError();
        }
        ourSocketLock = new SocketLock(PathManager.getConfigPath(), PathManager.getSystemPath());
        try {
            status = ourSocketLock.lock(args);
        }
        catch (Exception e) {
            Main.showMessage((String)"Cannot Lock System Folders", (Throwable)e);
            ActivationResult activationResult = ActivationResult.FAILED;
            if (activationResult == null) {
                StartupUtil.$$$reportNull$$$0(0);
            }
            return activationResult;
        }
        if (status == SocketLock.ActivateStatus.NO_INSTANCE) {
            ShutDownTracker.getInstance().registerShutdownTask(() -> {
                Class<StartupUtil> clazz = StartupUtil.class;
                synchronized (StartupUtil.class) {
                    ourSocketLock.dispose();
                    ourSocketLock = null;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
            });
            ActivationResult activationResult = ActivationResult.STARTED;
            if (activationResult == null) {
                StartupUtil.$$$reportNull$$$0(1);
            }
            return activationResult;
        }
        if (status == SocketLock.ActivateStatus.ACTIVATED) {
            System.out.println("Already running");
            ActivationResult activationResult = ActivationResult.ACTIVATED;
            if (activationResult == null) {
                StartupUtil.$$$reportNull$$$0(2);
            }
            return activationResult;
        }
        if (Main.isHeadless() || status == SocketLock.ActivateStatus.CANNOT_ACTIVATE) {
            String message = "Only one instance of " + ApplicationNamesInfo.getInstance().getProductName() + " can be run at a time.";
            Main.showMessage((String)"Too Many Instances", (String)message, (boolean)true);
        }
        ActivationResult activationResult = ActivationResult.FAILED;
        if (activationResult == null) {
            StartupUtil.$$$reportNull$$$0(3);
        }
        return activationResult;
    }

    private static void fixProcessEnvironment(Logger log2) {
        boolean envReady;
        if (!Main.isCommandLine()) {
            System.setProperty("__idea.mac.env.lock", "unlocked");
        }
        if (!(envReady = EnvironmentUtil.isEnvironmentReady())) {
            log2.info("initializing environment");
        }
    }

    private static void loadSystemLibraries(Logger log2) {
        File ideTempDir = new File(PathManager.getTempPath());
        if (!ideTempDir.mkdirs() && !ideTempDir.exists()) {
            throw new RuntimeException("Unable to create temp directory '" + ideTempDir + "'");
        }
        if (System.getProperty("jna.tmpdir") == null) {
            System.setProperty("jna.tmpdir", ideTempDir.getPath());
        }
        if (System.getProperty("jna.nosys") == null) {
            System.setProperty("jna.nosys", "true");
        }
        JnaLoader.load((Logger)log2);
        if (SystemInfo.isWin2kOrNewer) {
            IdeaWin32.isAvailable();
        }
        if (SystemInfo.isWindows && System.getProperty("winp.folder.preferred") == null) {
            System.setProperty("winp.folder.preferred", ideTempDir.getPath());
        }
        if (System.getProperty("pty4j.tmpdir") == null) {
            System.setProperty("pty4j.tmpdir", ideTempDir.getPath());
        }
        if (System.getProperty("pty4j.preferred.native.folder") == null) {
            System.setProperty("pty4j.preferred.native.folder", new File(PathManager.getLibPath(), "pty4j-native").getAbsolutePath());
        }
    }

    private static void startLogging(Logger log2) {
        String extDirs;
        ShutDownTracker.getInstance().registerShutdownTask(() -> log2.info("------------------------------------------------------ IDE SHUTDOWN ------------------------------------------------------"));
        log2.info("------------------------------------------------------ IDE STARTED ------------------------------------------------------");
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        ApplicationNamesInfo namesInfo = ApplicationNamesInfo.getInstance();
        String buildDate = new SimpleDateFormat("dd MMM yyyy HH:ss", Locale.US).format(appInfo.getBuildDate().getTime());
        log2.info("IDE: " + namesInfo.getFullProductName() + " (build #" + appInfo.getBuild().asString() + ", " + buildDate + ")");
        log2.info("OS: " + SystemInfoRt.OS_NAME + " (" + SystemInfoRt.OS_VERSION + ", " + SystemInfo.OS_ARCH + ")");
        log2.info("JRE: " + System.getProperty("java.runtime.version", "-") + " (" + System.getProperty("java.vendor", "-") + ")");
        log2.info("JVM: " + System.getProperty("java.vm.version", "-") + " (" + System.getProperty("java.vm.name", "-") + ")");
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (arguments != null) {
            log2.info("JVM Args: " + StringUtil.join(arguments, (String)" "));
        }
        if ((extDirs = System.getProperty("java.ext.dirs")) != null) {
            for (String dir : StringUtil.split((String)extDirs, (String)File.pathSeparator)) {
                Object[] content = new File(dir).list();
                if (content == null || content.length <= 0) continue;
                log2.info("ext: " + dir + ": " + Arrays.toString(content));
            }
        }
        log2.info("charsets: JNU=" + System.getProperty("sun.jnu.encoding") + " file=" + System.getProperty("file.encoding"));
    }

    private static void installPluginUpdates() {
        if (!Main.isCommandLine() && !ClassUtilCore.isLoadingOfExternalPluginsDisabled()) {
            try {
                StartupActionScriptManager.executeActionScript();
            }
            catch (IOException e) {
                String message = "The IDE failed to install some plugins.\n\nMost probably, this happened because of a change in a serialization format.\nPlease try again, and if the problem persists, please report it\nto http://jb.gg/ide/critical-startup-errors\n\nThe cause: " + e.getMessage();
                Main.showMessage((String)"Plugin Installation Error", (String)message, (boolean)false);
            }
        }
    }

    static void runStartupWizard() {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        String stepsProviderName = appInfo.getCustomizeIDEWizardStepsProvider();
        if (stepsProviderName != null) {
            CustomizeIDEWizardStepsProvider provider;
            try {
                Class<?> providerClass = Class.forName(stepsProviderName);
                provider = (CustomizeIDEWizardStepsProvider)providerClass.newInstance();
            }
            catch (Throwable e) {
                Main.showMessage((String)"Configuration Wizard Failed", (Throwable)e);
                return;
            }
            CloudConfigProvider configProvider = CloudConfigProvider.getProvider();
            if (configProvider != null) {
                configProvider.beforeStartupWizard();
            }
            new CustomizeIDEWizardDialog(provider).show();
            PluginManagerCore.invalidatePlugins();
            if (configProvider != null) {
                configProvider.startupWizardFinished();
            }
            return;
        }
        List<ApplicationInfoEx.PluginChooserPage> pages = appInfo.getPluginChooserPages();
        if (!pages.isEmpty()) {
            new StartupWizard(pages).show();
            PluginManagerCore.invalidatePlugins();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/StartupUtil", "lockSystemFolders"));
    }

    private static enum ActivationResult {
        STARTED,
        ACTIVATED,
        FAILED;

    }

    @FunctionalInterface
    static interface AppStarter {
        public void start(boolean var1);

        default public void beforeImportConfigs() {
        }
    }
}

