/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class FUSUsageContext {
    public static final FUSUsageContext OS_CONTEXT = FUSUsageContext.create(FUSUsageContext.getOSNameContextData());
    private static final byte MAX_DATA_SIZE = 5;
    private final Map<String, String> data;

    private FUSUsageContext(String ... data) {
        if (data == null) {
            FUSUsageContext.$$$reportNull$$$0(0);
        }
        this.data = ContainerUtil.newLinkedHashMap((int)data.length);
        for (int i = 1; i < data.length + 1; ++i) {
            String contextData = data[i - 1];
            if (StringUtil.isEmptyOrSpaces((String)contextData)) continue;
            this.data.put(FUSUsageContext.getContextDataKey(i), contextData);
        }
    }

    @NotNull
    public Map<String, String> getData() {
        Map<String, String> map = Collections.unmodifiableMap(this.data);
        if (map == null) {
            FUSUsageContext.$$$reportNull$$$0(1);
        }
        return map;
    }

    public static String getOSNameContextData() {
        if (SystemInfo.isWindows) {
            return "Windows";
        }
        if (SystemInfo.isMac) {
            return "Mac";
        }
        if (SystemInfo.isLinux) {
            return "Linux";
        }
        return "Other";
    }

    public static FUSUsageContext create(String ... data) {
        if (data == null) {
            FUSUsageContext.$$$reportNull$$$0(2);
        }
        assert (data.length <= 5);
        return new FUSUsageContext(data);
    }

    @NotNull
    private static String getContextDataKey(int i) {
        String string = "data_" + i;
        if (string == null) {
            FUSUsageContext.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FUSUsageContext)) {
            return false;
        }
        return Objects.equals(this.data, ((FUSUsageContext)o).data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/collectors/FUSUsageContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/collectors/FUSUsageContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextDataKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

