/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor.fonts;

import com.intellij.application.options.editor.EditorOptionsPanel;
import com.intellij.application.options.editor.fonts.AppEditorFontPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LazyInstance;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEditorFontConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    public static final String ID = "editor.preferences.fonts.default";
    private final LazyInstance<AppEditorFontPanel> myFontPanelInstance = new LazyInstance<AppEditorFontPanel>(){

        protected Class<AppEditorFontPanel> getInstanceClass() throws ClassNotFoundException {
            return AppEditorFontPanel.class;
        }
    };

    @NotNull
    public String getId() {
        if (ID == null) {
            AppEditorFontConfigurable.$$$reportNull$$$0(0);
        }
        return ID;
    }

    @Nullable
    public JComponent createComponent() {
        return this.getFontPanel().getComponent();
    }

    public boolean isModified() {
        this.getFontPanel().getOptionsPanel().updateWarning();
        return !AppEditorFontConfigurable.getStoredPreferences().equals(this.getUIFontPreferences());
    }

    public void apply() throws ConfigurationException {
        FontPreferences fontPreferences = this.getUIFontPreferences();
        fontPreferences.copyTo(AppEditorFontConfigurable.getStoredPreferences());
        EditorFontCache.getInstance().reset();
        ((EditorColorsManagerImpl)EditorColorsManager.getInstance()).schemeChangedOrSwitched(null);
        EditorOptionsPanel.reinitAllEditors();
    }

    @NotNull
    private FontPreferences getUIFontPreferences() {
        FontPreferences fontPreferences = this.getFontPanel().getOptionsPanel().getFontPreferences();
        if (fontPreferences == null) {
            AppEditorFontConfigurable.$$$reportNull$$$0(1);
        }
        return fontPreferences;
    }

    public void reset() {
        AppEditorFontConfigurable.getStoredPreferences().copyTo(this.getUIFontPreferences());
        this.getFontPanel().getOptionsPanel().updateOnChangedFont();
    }

    @NotNull
    private static FontPreferences getStoredPreferences() {
        FontPreferences fontPreferences = AppEditorFontOptions.getInstance().getFontPreferences();
        if (fontPreferences == null) {
            AppEditorFontConfigurable.$$$reportNull$$$0(2);
        }
        return fontPreferences;
    }

    @NotNull
    private AppEditorFontPanel getFontPanel() {
        AppEditorFontPanel appEditorFontPanel = (AppEditorFontPanel)this.myFontPanelInstance.getValue();
        if (appEditorFontPanel == null) {
            AppEditorFontConfigurable.$$$reportNull$$$0(3);
        }
        return appEditorFontPanel;
    }

    @Nls
    public String getDisplayName() {
        return "Font";
    }

    public void disposeUIResources() {
        if (this.myFontPanelInstance.isComputed()) {
            Disposer.dispose((Disposable)this.getFontPanel());
        }
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.editor.colors";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/application/options/editor/fonts/AppEditorFontConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUIFontPreferences";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStoredPreferences";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontPanel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

