/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.branch.DvcsBranchInfo;
import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="branch-storage")
public class BranchStorage {
    @Property(surroundWithTag=false)
    @MapAnnotation(keyAttributeName="type")
    @NotNull
    public Map<String, List<DvcsBranchInfo>> myBranches = ContainerUtil.newHashMap();

    public boolean contains(@NotNull String typeName, @Nullable Repository repository, @NotNull String branchName) {
        List<DvcsBranchInfo> branches;
        if (typeName == null) {
            BranchStorage.$$$reportNull$$$0(0);
        }
        if (branchName == null) {
            BranchStorage.$$$reportNull$$$0(1);
        }
        return (branches = this.myBranches.get(typeName)) != null && DvcsBranchUtil.find(branches, repository, branchName) != null;
    }

    public void add(@NotNull String typeName, @Nullable Repository repository, @NotNull String branchName) {
        if (typeName == null) {
            BranchStorage.$$$reportNull$$$0(2);
        }
        if (branchName == null) {
            BranchStorage.$$$reportNull$$$0(3);
        }
        if (this.contains(typeName, repository, branchName)) {
            return;
        }
        List branchInfos = this.myBranches.computeIfAbsent(typeName, name -> ContainerUtil.newArrayList());
        branchInfos.add(new DvcsBranchInfo(DvcsBranchUtil.getPathFor(repository), branchName));
    }

    public void remove(@NotNull String typeName, @Nullable Repository repository, @NotNull String branchName) {
        List<DvcsBranchInfo> branches;
        DvcsBranchInfo toDelete;
        if (typeName == null) {
            BranchStorage.$$$reportNull$$$0(4);
        }
        if (branchName == null) {
            BranchStorage.$$$reportNull$$$0(5);
        }
        if ((toDelete = DvcsBranchUtil.find(branches = this.myBranches.get(typeName), repository, branchName)) != null) {
            branches.remove(toDelete);
            if (branches.isEmpty()) {
                this.myBranches.remove(typeName);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dvcs/branch/BranchStorage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

