/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.SearchEverywhereUI;
import com.intellij.ui.components.JBList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class SEListSelectionTracker
implements ListSelectionListener {
    private final JBList<?> myList;
    private final SearchEverywhereUI.SearchListModel myListModel;
    private boolean locked;
    private final List<Object> selectedItems = new ArrayList<Object>();

    SEListSelectionTracker(JBList<?> list2, SearchEverywhereUI.SearchListModel model) {
        this.myList = list2;
        this.myListModel = model;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.locked) {
            return;
        }
        this.saveSelection();
    }

    void saveSelection() {
        this.selectedItems.clear();
        this.selectedItems.addAll(this.myList.getSelectedValuesList());
    }

    void restoreSelection() {
        this.locked = true;
        try {
            int[] indicesToSelect = this.calcIndicesToSelect();
            if (indicesToSelect.length > 0) {
                this.myList.setSelectedIndices(indicesToSelect);
            } else {
                this.myList.setSelectedIndex(0);
            }
        }
        finally {
            this.locked = false;
        }
    }

    void resetSelectionIfNeeded() {
        int[] indices = this.calcIndicesToSelect();
        if (indices.length == 0) {
            this.selectedItems.clear();
        }
    }

    void setLocked(boolean lock) {
        this.locked = lock;
    }

    private int[] calcIndicesToSelect() {
        List<Object> items = this.myListModel.getItems();
        if (items.isEmpty()) {
            return new int[0];
        }
        return IntStream.range(0, items.size()).filter(i -> this.selectedItems.contains(items.get(i))).toArray();
    }
}

