/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnshelvePatchDefaultExecutor
extends ApplyPatchDefaultExecutor {
    private static final Logger LOG = Logger.getInstance(UnshelvePatchDefaultExecutor.class);
    @NotNull
    private final ShelvedChangeList myCurrentShelveChangeList;

    public UnshelvePatchDefaultExecutor(@NotNull Project project, @NotNull ShelvedChangeList changeList) {
        if (project == null) {
            UnshelvePatchDefaultExecutor.$$$reportNull$$$0(0);
        }
        if (changeList == null) {
            UnshelvePatchDefaultExecutor.$$$reportNull$$$0(1);
        }
        super(project);
        this.myCurrentShelveChangeList = changeList;
    }

    @Override
    public void apply(@NotNull List<FilePatch> remaining, @NotNull MultiMap<VirtualFile, AbstractFilePatchInProgress> patchGroupsToApply, @Nullable LocalChangeList localList, @Nullable String fileName, @Nullable ThrowableComputable<Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo) {
        if (remaining == null) {
            UnshelvePatchDefaultExecutor.$$$reportNull$$$0(2);
        }
        if (patchGroupsToApply == null) {
            UnshelvePatchDefaultExecutor.$$$reportNull$$$0(3);
        }
        CommitContext commitContext = new CommitContext();
        UnshelvePatchDefaultExecutor.applyAdditionalInfoBefore(this.myProject, additionalInfo, commitContext);
        Collection<PatchApplier> appliers = this.getPatchAppliers(patchGroupsToApply, localList, commitContext);
        ApplyPatchStatus patchStatus = PatchApplier.executePatchGroup(appliers, localList);
        if (patchStatus != ApplyPatchStatus.ABORT && patchStatus != ApplyPatchStatus.FAILURE) {
            this.removeAppliedAndSaveRemainedIfNeeded(remaining, appliers, commitContext);
        }
    }

    private void removeAppliedAndSaveRemainedIfNeeded(@NotNull List<FilePatch> remaining, @NotNull Collection<PatchApplier> appliers, @NotNull CommitContext commitContext) {
        ShelveChangesManager shelveChangesManager;
        if (remaining == null) {
            UnshelvePatchDefaultExecutor.$$$reportNull$$$0(4);
        }
        if (appliers == null) {
            UnshelvePatchDefaultExecutor.$$$reportNull$$$0(5);
        }
        if (commitContext == null) {
            UnshelvePatchDefaultExecutor.$$$reportNull$$$0(6);
        }
        if (!(shelveChangesManager = ShelveChangesManager.getInstance(this.myProject)).isRemoveFilesFromShelf()) {
            return;
        }
        try {
            ArrayList patches2 = ContainerUtil.newArrayList(remaining);
            for (PatchApplier applier : appliers) {
                patches2.addAll(applier.getRemainingPatches());
            }
            if (patches2.isEmpty()) {
                shelveChangesManager.recycleChangeList(this.myCurrentShelveChangeList);
            } else {
                shelveChangesManager.saveRemainingPatches(this.myCurrentShelveChangeList, patches2, ContainerUtil.mapNotNull((Collection)patches2, patch -> patch instanceof ShelvedBinaryFilePatch ? ((ShelvedBinaryFilePatch)((Object)patch)).getShelvedBinaryFile() : null), commitContext);
            }
        }
        catch (Exception e) {
            LOG.error("Couldn't update and store remaining patches", (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remaining";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchGroupsToApply";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliers";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/UnshelvePatchDefaultExecutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeAppliedAndSaveRemainedIfNeeded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

