/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/vcs/log/ui/actions/CompareRevisionsFromLogAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "update", "intellij.platform.vcs.log.impl"})
public class CompareRevisionsFromLogAction
extends DumbAwareAction {
    @Nullable
    protected FilePath getFilePath(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        VcsLog vcsLog = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        if (vcsLog == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsLog, (String)"e.getData(VcsLogDataKeys.VCS_LOG) ?: return null");
        VcsLog log2 = vcsLog;
        List list2 = log2.getSelectedCommits();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"log.selectedCommits");
        List selectedCommits = list2;
        if (selectedCommits.isEmpty() || selectedCommits.size() > 2) {
            return null;
        }
        Object object = CollectionsKt.first((List)selectedCommits);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"selectedCommits.first()");
        VirtualFile virtualFile = ((CommitId)object).getRoot();
        Object object2 = CollectionsKt.last((List)selectedCommits);
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"selectedCommits.last()");
        if (Intrinsics.areEqual((Object)virtualFile, (Object)((CommitId)object2).getRoot()) ^ true) {
            return null;
        }
        Object object3 = CollectionsKt.first((List)selectedCommits);
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"selectedCommits.first()");
        return VcsUtil.getFilePath((VirtualFile)((CommitId)object3).getRoot());
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        VcsLog log2 = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        VcsLogDiffHandler handler2 = (VcsLogDiffHandler)e.getData(VcsLogInternalDataKeys.LOG_DIFF_HANDLER);
        FilePath filePath = this.getFilePath(e);
        if (log2 == null || filePath == null || handler2 == null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setVisible(true);
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabled(log2.getSelectedCommits().size() == 2);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Object object = e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"e.getRequiredData(VcsLogDataKeys.VCS_LOG)");
        VcsLog log2 = (VcsLog)object;
        Object object2 = e.getRequiredData(VcsLogInternalDataKeys.LOG_DIFF_HANDLER);
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"e.getRequiredData(VcsLog\u2026ataKeys.LOG_DIFF_HANDLER)");
        VcsLogDiffHandler handler2 = (VcsLogDiffHandler)object2;
        FilePath filePath = this.getFilePath(e);
        if (filePath == null) {
            Intrinsics.throwNpe();
        }
        FilePath filePath2 = filePath;
        VcsLogUsageTriggerCollector.triggerUsage(e);
        List list2 = log2.getSelectedCommits();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"log.selectedCommits");
        List commits = list2;
        if (commits.size() == 2) {
            Object e2 = commits.get(1);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"commits[1]");
            VirtualFile virtualFile = ((CommitId)e2).getRoot();
            Object e3 = commits.get(1);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"commits[1]");
            Hash hash = ((CommitId)e3).getHash();
            Object e4 = commits.get(0);
            Intrinsics.checkExpressionValueIsNotNull(e4, (String)"commits[0]");
            handler2.showDiff(virtualFile, filePath2, hash, filePath2, ((CommitId)e4).getHash());
        }
    }
}

