/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.WordOptimizer;
import com.intellij.structuralsearch.impl.matcher.compiler.a;
import com.intellij.structuralsearch.impl.matcher.filters.TagValueFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;

public class XmlCompilingVisitor
extends XmlRecursiveElementVisitor {
    final GlobalCompilingVisitor myCompilingVisitor;

    public XmlCompilingVisitor(GlobalCompilingVisitor compilingVisitor) {
        this.myCompilingVisitor = compilingVisitor;
    }

    public void compile(PsiElement[] topLevelElements) {
        XmlWordOptimizer xmlWordOptimizer = new XmlWordOptimizer(null);
        CompiledPattern compiledPattern = this.myCompilingVisitor.getContext().getPattern();
        for (PsiElement psiElement : topLevelElements) {
            psiElement.accept((PsiElementVisitor)this);
            psiElement.accept((PsiElementVisitor)xmlWordOptimizer);
            compiledPattern.setHandler(psiElement, new TopLevelMatchingHandler(compiledPattern.getHandler(psiElement)));
        }
    }

    public void visitElement(PsiElement element) {
        this.myCompilingVisitor.handle(element);
        super.visitElement(element);
    }

    public void visitXmlToken(XmlToken token) {
        if (token.getTokenType() == XmlTokenType.XML_NAME) {
            super.visitXmlToken(token);
        }
    }

    public void visitXmlText(XmlText text) {
        super.visitXmlText(text);
        this.myCompilingVisitor.setFilterSimple((PsiElement)text, TagValueFilter.getInstance());
    }

    private class XmlWordOptimizer
    extends XmlRecursiveElementWalkingVisitor
    implements WordOptimizer {
        private XmlWordOptimizer() {
        }

        public void visitXmlTag(XmlTag tag) {
            if (!this.handleWord(tag.getName(), XmlCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            super.visitXmlTag(tag);
        }

        public void visitXmlAttribute(XmlAttribute attribute) {
            if (!this.handleWord(attribute.getName(), XmlCompilingVisitor.this.myCompilingVisitor.getContext())) {
                return;
            }
            this.handleWord(attribute.getValue(), XmlCompilingVisitor.this.myCompilingVisitor.getContext());
            super.visitXmlAttribute(attribute);
        }

        public void visitXmlText(XmlText text) {
            String string = text.getText();
            if (!XmlCompilingVisitor.this.myCompilingVisitor.getContext().getPattern().isTypedVar(string)) {
                XmlCompilingVisitor.this.myCompilingVisitor.processTokenizedName(string, false, GlobalCompilingVisitor.OccurenceKind.TEXT);
            }
            super.visitXmlText(text);
        }

        /* synthetic */ XmlWordOptimizer(a x1) {
            this();
        }
    }
}

