/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.generators;

import b.h.la;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsExternalizer;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.GeneratorsActionGroup;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.SimpleGeneratorAction;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.testing.actions.RubyTestFinder;
import org.jetbrains.plugins.ruby.utils.ActionUtil;

public class GeneratorsModuleCache {
    private static final Logger g;
    private final Module f;
    private String[] b;
    private boolean h = false;
    private boolean c;
    private final List<SimpleGeneratorAction> e = new ArrayList<SimpleGeneratorAction>();
    private final Collection<GeneratorListener> d = ContainerUtil.createConcurrentList();
    private final Collection<Runnable> a = ContainerUtil.createConcurrentList();
    private static final long i;

    public static GeneratorsModuleCache getInstance(@NotNull Module module) {
        if (module == null) {
            GeneratorsModuleCache.a(0);
        }
        return (GeneratorsModuleCache)module.getComponent(GeneratorsModuleCache.class);
    }

    public GeneratorsModuleCache(final Module module) {
        MessageBusConnection messageBusConnection = module.getMessageBus().connect((Disposable)module);
        messageBusConnection.subscribe(GemManager.MODULE_GEMS_CHANGED_TOPIC, (Object)new GemManager.ModuleGemsListener(){

            @Override
            public void gemsChanged() {
                GeneratorsModuleCache.this.reloadGenerators(true, RModuleUtil.getInstance().findRubySdkForModule(module), ApplicationManager.getApplication().isUnitTestMode(), true);
            }
        });
        this.f = module;
        String string = RailsFacetUtil.getRailsAppHomeDirPath(module);
        if (string != null) {
            GeneratorsExternalizer generatorsExternalizer = new GeneratorsExternalizer();
            String[] stringArray = generatorsExternalizer.loadGeneratorList(string);
            this.setGenerators(stringArray);
        }
    }

    public void addGeneratorListener(@NotNull GeneratorListener generatorListener) {
        if (generatorListener == null) {
            GeneratorsModuleCache.a(1);
        }
        this.d.add(generatorListener);
    }

    public void removeGeneratorListener(@NotNull GeneratorListener generatorListener) {
        if (generatorListener == null) {
            GeneratorsModuleCache.a(2);
        }
        this.d.remove(generatorListener);
    }

    private static AnAction b(@NotNull String string) {
        if (string == null) {
            GeneratorsModuleCache.a(3);
        }
        return ActionUtil.registerActionIfNecessary(GeneratorsModuleCache.getActionId(string), () -> {
            if (string == null) {
                GeneratorsModuleCache.a(11);
            }
            return GeneratorsActionGroup.createGeneratorAction(string);
        });
    }

    public boolean isLoadingGenerators() {
        return this.c;
    }

    public void setGenerators(@Nullable String[] generators) {
        long l2 = i ^ 0x19B0DB5A2938L;
        this.b = generators;
        if (generators != null) {
            this.h = true;
            for (String string : generators) {
                AnAction anAction = GeneratorsModuleCache.b(string);
                assert (anAction instanceof SimpleGeneratorAction) : "Got inappropriate action for " + string + ": " + anAction;
                this.e.add((SimpleGeneratorAction)anAction);
            }
            for (GeneratorListener generatorListener : this.d) {
                generatorListener.onGeneratorsLoaded();
            }
        }
        this.c = false;
    }

    public String[] getGenerators() {
        if (!this.h) {
            this.reloadGenerators(true, RModuleUtil.getInstance().findRubySdkForModule(this.f), false);
        }
        return this.b;
    }

    public void reloadGenerators(boolean forceRegenerate, Sdk sdk, boolean isSilently) {
        this.reloadGenerators(forceRegenerate, sdk, !ApplicationManager.getApplication().isHeadlessEnvironment(), isSilently);
    }

    public void reloadGenerators(boolean forceRegenerate, Sdk sdk, boolean forceTestReload, boolean isSilently) {
        if (!forceTestReload) {
            return;
        }
        if (!this.c) {
            this.c = true;
            this.e.clear();
            GeneratorsUtil.loadGeneratorsList(forceRegenerate, this.f, sdk, this, isSilently);
        }
    }

    public Collection<SimpleGeneratorAction> getGeneratorActions() {
        return this.e;
    }

    @NonNls
    public static String getActionId(String generator) {
        long l2 = i ^ 0x7B8782AC32D3L;
        return "rails:generator:" + generator;
    }

    public static boolean appendGemToGemfile(@NotNull Module module, @NotNull String gemName) {
        VirtualFile virtualFile;
        long l2 = i ^ 0x1B762535081AL;
        if (module == null) {
            GeneratorsModuleCache.a(4);
        }
        if (gemName == null) {
            GeneratorsModuleCache.a(5);
        }
        if ((virtualFile = BundlerUtil.getGemfile(module)) == null) {
            return false;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder(VfsUtilCore.loadText((VirtualFile)virtualFile));
            String string = stringBuilder.toString();
            stringBuilder.append("\n\ngem '").append(gemName).append('\'');
            return (Boolean)ApplicationManager.getApplication().runWriteAction(() -> {
                if (module == null) {
                    GeneratorsModuleCache.a(10);
                }
                VfsUtil.saveText((VirtualFile)virtualFile, (String)stringBuilder.toString());
                GeneratorsModuleCache.getInstance(module).registerGeneratorUndoAction(() -> {
                    long l2 = i ^ 0x3629F4BE1111L;
                    try {
                        VfsUtil.saveText((VirtualFile)virtualFile, (String)string);
                    }
                    catch (IOException iOException) {
                        g.error("Cannot rollback Gemfile; " + iOException.getMessage());
                    }
                });
                return true;
            });
        }
        catch (IOException iOException) {
            g.warn("Cannot update Gemfile; " + iOException.getMessage());
            return false;
        }
    }

    public void registerGeneratorUndoAction(@NotNull Runnable undoAction) {
        if (undoAction == null) {
            GeneratorsModuleCache.a(6);
        }
        this.a.add(undoAction);
    }

    private void a() {
        this.a.clear();
    }

    @NotNull
    public Notification createGeneratorNotFoundNotification(@NotNull String generatorName) {
        long l2 = i ^ 0x4F8C9550E95AL;
        if (generatorName == null) {
            GeneratorsModuleCache.a(7);
        }
        Notification notification = new Notification(RubyTestFinder.NOTIFICATION_GROUP.getDisplayId(), RBundle.message((String)"generator.notification.not.found.title"), RBundle.message((String)"generator.notification.not.found.content", (Object[])new Object[]{generatorName}), NotificationType.WARNING, (NotificationListener)new TestGeneratorNotFoundListener()).whenExpired(() -> this.a());
        if (notification == null) {
            GeneratorsModuleCache.a(8);
        }
        return notification;
    }

    public Notification createGeneratorRollbackNotification(@NotNull String generatorName) {
        long l2 = i ^ 0x25833931F5BBL;
        if (generatorName == null) {
            GeneratorsModuleCache.a(9);
        }
        return new Notification(RubyTestFinder.NOTIFICATION_GROUP.getDisplayId(), RBundle.message((String)"generator.notification.after.title"), RBundle.message((String)"generator.notification.after.content", (Object[])new Object[]{generatorName}), NotificationType.INFORMATION, (NotificationListener)new PostGeneratorListener()).whenExpired(() -> this.a());
    }

    private void e() {
        WriteCommandAction.runWriteCommandAction((Project)this.f.getProject(), () -> {
            if (this.f.isDisposed()) {
                return;
            }
            for (Runnable runnable : this.a) {
                runnable.run();
            }
            this.a.clear();
        });
    }

    static {
        i = la.a(-7507042972639771757L, -5448518671952988491L, MethodHandles.lookup().lookupClass()).a(260753124669398L);
        g = Logger.getInstance(GeneratorsModuleCache.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = i ^ 0x78776FE44F36L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatorListener";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoAction";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatorName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsModuleCache";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsModuleCache";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createGeneratorNotFoundNotification";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addGeneratorListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeGeneratorListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerGeneratorIfNecessary";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendGemToGemfile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerGeneratorUndoAction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createGeneratorNotFoundNotification";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createGeneratorRollbackNotification";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$appendGemToGemfile$2";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$registerGeneratorIfNecessary$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PostGeneratorListener
    extends NotificationListener.Adapter {
        private static final long a = la.a(-1054430779584349102L, 6877531964424732116L, MethodHandles.lookup().lookupClass()).a(254683565083880L);

        private PostGeneratorListener() {
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            long l2 = a ^ 0x70DA0A7C3F87L;
            if (notification == null) {
                PostGeneratorListener.a(0);
            }
            if (event == null) {
                PostGeneratorListener.a(1);
            }
            if ("got_it".equals(event.getDescription())) {
                return;
            }
            if ("rollback".equals(event.getDescription())) {
                GeneratorsModuleCache.this.e();
            }
            notification.expire();
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x7F8D88AFF290L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsModuleCache$PostGeneratorListener";
            objectArray[2] = "hyperlinkActivated";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class TestGeneratorNotFoundListener
    extends NotificationListener.Adapter {
        private static final long a = la.a(2460071827104951816L, -7858040060943228545L, MethodHandles.lookup().lookupClass()).a(66001856352144L);

        private TestGeneratorNotFoundListener() {
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            long l2 = a ^ 0x6728AC3B8A67L;
            if (notification == null) {
                TestGeneratorNotFoundListener.a(0);
            }
            if (event == null) {
                TestGeneratorNotFoundListener.a(1);
            }
            if ("rollback".equals(event.getDescription())) {
                GeneratorsModuleCache.this.e();
            }
            notification.expire();
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x10920405F4A1L;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/rails/actions/generators/GeneratorsModuleCache$TestGeneratorNotFoundListener";
            objectArray[2] = "hyperlinkActivated";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface GeneratorListener {
        public void onGeneratorsLoaded();
    }
}

