/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import b.h.la;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.ValidatableSdkAdditionalData;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.LocalRubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.a;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.rvm.LocalRvmPathsSettings;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSettings;

public class RubySdkAdditionalData
implements ValidatableSdkAdditionalData {
    @NonNls
    private static final String a = "PLATFORM";
    @NonNls
    private static final String f = "GEMS_BIN_DIR_PATH";
    @NonNls
    private static final String j = "GEMS_ROOTS_URLS_ROOT";
    @NonNls
    private static final String l = "GEMS_ROOTS_URL";
    @NonNls
    private static final String b = "NORMALIZED_VERSION_STRING";
    private static final RubySdkAdditionalData c;
    protected static final Logger LOG;
    volatile transient boolean myIsInitialized;
    volatile transient boolean myInitializedPaths;
    @Nullable
    volatile transient List<VirtualFile> myTemporaryRoots;
    @Nullable
    private String g;
    private List<String> h;
    private LanguageLevel k;
    private String i;
    @Nullable
    private RubyVersionManagerSdkData e;
    @Nullable
    private String d;
    private static final long w;

    protected RubySdkAdditionalData() {
        this.myIsInitialized = false;
        this.myInitializedPaths = true;
        this.myTemporaryRoots = null;
    }

    public RubySdkAdditionalData(@NotNull RubySdkAdditionalData original) {
        if (original == null) {
            RubySdkAdditionalData.a(0);
        }
        this.myIsInitialized = false;
        this.myInitializedPaths = true;
        this.myTemporaryRoots = null;
        this.myIsInitialized = original.myIsInitialized;
        this.myInitializedPaths = original.myInitializedPaths;
        this.myTemporaryRoots = RubySdkAdditionalData.a(original.myTemporaryRoots);
        this.g = original.g;
        this.h = RubySdkAdditionalData.a(original.h);
        this.k = original.k;
        this.i = original.i;
        this.e = Objects.requireNonNull(original.e).copy();
        this.d = original.d;
    }

    @Contract(pure=true, value="null->null; !null -> !null")
    @Nullable
    private static <T> List<T> a(@Nullable List<T> list2) {
        return list2 == null ? null : ContainerUtil.newArrayList(list2);
    }

    @NotNull
    public RubyVersionManagerSdkData getVersionManagerSdkAdditionalData() {
        long l2 = w ^ 0x2B34F478C328L;
        RubyVersionManagerSdkData rubyVersionManagerSdkData = Objects.requireNonNull(this.e, "Attempt to fetch data before initialization");
        if (rubyVersionManagerSdkData == null) {
            RubySdkAdditionalData.a(1);
        }
        return rubyVersionManagerSdkData;
    }

    @NotNull
    public RubySdkAdditionalData withVersionManagerSdkAdditionalData(@NotNull RubyVersionManagerSdkData versionManagerSdkAdditionalData) {
        if (versionManagerSdkAdditionalData == null) {
            RubySdkAdditionalData.a(2);
        }
        this.e = versionManagerSdkAdditionalData;
        RubySdkAdditionalData rubySdkAdditionalData = this;
        if (rubySdkAdditionalData == null) {
            RubySdkAdditionalData.a(3);
        }
        return rubySdkAdditionalData;
    }

    @NotNull
    public String getGemsBinDirectory() {
        long l2 = w ^ 0x13AB60A30227L;
        String string = Objects.requireNonNull(this.g, "Attempt to fetch data before initialization");
        if (string == null) {
            RubySdkAdditionalData.a(4);
        }
        return string;
    }

    public void setGemsBinDirectory(@NotNull String path) {
        if (path == null) {
            RubySdkAdditionalData.a(5);
        }
        this.g = path;
    }

    @Contract(pure=true)
    public boolean hasGemsBinDirectory() {
        return this.g != null;
    }

    public List<? extends String> getGemsRootUrls() {
        return this.h;
    }

    public void setGemsRootUrls(@NotNull List<String> urls) {
        if (urls == null) {
            RubySdkAdditionalData.a(6);
        }
        this.h = Collections.unmodifiableList(urls);
    }

    public void checkValid(SdkModel sdkModel) throws ConfigurationException {
        long l2 = w ^ 0x1FAA6593D475L;
        File file = new File(this.getGemsBinDirectory());
        if (!file.exists()) {
            throw new ConfigurationException(RBundle.message((String)"sdk.error.gems.bindir.doesnt.exist"));
        }
        if (!file.isDirectory()) {
            throw new ConfigurationException(RBundle.message((String)"sdk.error.gems.bindir.isnt.directory"));
        }
    }

    public void save(@NotNull Element rootElement) {
        long l2 = w ^ 0x5E44A812939BL;
        if (rootElement == null) {
            RubySdkAdditionalData.a(7);
        }
        if (this.d != null) {
            rootElement.setAttribute(b, this.d);
        }
        if (this.getPlatform() != null) {
            rootElement.setAttribute(a, this.getPlatform());
        }
        assert (this.e != null);
        this.e.save(rootElement);
        rootElement.setAttribute(f, this.getGemsBinDirectory());
        for (String string : this.h) {
            Element element = new Element(j);
            element.setAttribute(l, string);
            rootElement.addContent(element);
        }
    }

    @NotNull
    public String getInterpreterPath(@NotNull Sdk sdk) {
        long l2 = w ^ 0x74E2B6DA80E4L;
        if (sdk == null) {
            RubySdkAdditionalData.a(8);
        }
        if (!this.equals(sdk.getSdkAdditionalData())) {
            throw new IllegalArgumentException("Wrong sdk - " + sdk);
        }
        String string = sdk.getHomePath();
        assert (string != null);
        String string2 = string;
        if (string2 == null) {
            RubySdkAdditionalData.a(9);
        }
        return string2;
    }

    @NotNull
    public static String getInterpreterPathFor(@NotNull Sdk rubySdk) {
        if (rubySdk == null) {
            RubySdkAdditionalData.a(10);
        }
        String string = RubySdkAdditionalData.notNullFrom(rubySdk).getInterpreterPath(rubySdk);
        if (string == null) {
            RubySdkAdditionalData.a(11);
        }
        return string;
    }

    public LanguageLevel getLanguageLevel() {
        return this.k;
    }

    public void setLanguageLevel(LanguageLevel languageLevel) {
        this.k = languageLevel;
    }

    public String getPlatform() {
        return this.i;
    }

    public void setPlatform(String platform) {
        this.i = platform;
    }

    @NotNull
    public RubyRunner getRunner(@Nullable Module module) {
        RubyLocalRunner rubyLocalRunner = RubyLocalRunner.getRunner(module);
        if (rubyLocalRunner == null) {
            RubySdkAdditionalData.a(12);
        }
        return rubyLocalRunner;
    }

    @NotNull
    public PathMappingSettings getRunnerMappings(@Nullable Module module) {
        PathMappingSettings pathMappingSettings = this.getRunnerMappings(module, null);
        if (pathMappingSettings == null) {
            RubySdkAdditionalData.a(13);
        }
        return pathMappingSettings;
    }

    @NotNull
    public PathMappingSettings getRunnerMappings(@NotNull AbstractRubyRunConfiguration configurationParams) {
        if (configurationParams == null) {
            RubySdkAdditionalData.a(14);
        }
        PathMappingSettings pathMappingSettings = this.getRunnerMappings(configurationParams.getModule(), configurationParams.getMappingSettings());
        if (pathMappingSettings == null) {
            RubySdkAdditionalData.a(15);
        }
        return pathMappingSettings;
    }

    @NotNull
    public PathMappingSettings getRunnerMappings(@Nullable Module module, @Nullable PathMappingSettings baseMappings) {
        PathMappingSettings pathMappingSettings = this.getRunner(module).addDefaultMappings(baseMappings);
        if (pathMappingSettings == null) {
            RubySdkAdditionalData.a(16);
        }
        return pathMappingSettings;
    }

    @NotNull
    public RubySdkSystemAccessor getSdkSystemAccessor() {
        LocalRubySdkSystemAccessor localRubySdkSystemAccessor = LocalRubySdkSystemAccessor.getInstance();
        if (localRubySdkSystemAccessor == null) {
            RubySdkAdditionalData.a(17);
        }
        return localRubySdkSystemAccessor;
    }

    @NotNull
    public RvmSettings getRvmSettings() {
        LocalRvmPathsSettings localRvmPathsSettings = LocalRvmPathsSettings.getInstance();
        if (localRvmPathsSettings == null) {
            RubySdkAdditionalData.a(18);
        }
        return localRvmPathsSettings;
    }

    @NotNull
    public String getConnectionCredentialId() {
        if ("" == null) {
            RubySdkAdditionalData.a(19);
        }
        return "";
    }

    @Nullable
    public String getNormalizedVersionString() {
        return this.d;
    }

    public void setNormalizedVersionString(@Nullable String normalizedVersionString) {
        this.d = normalizedVersionString;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        return this.fieldsEqual((RubySdkAdditionalData)o2);
    }

    protected boolean fieldsEqual(@NotNull RubySdkAdditionalData data) {
        if (data == null) {
            RubySdkAdditionalData.a(20);
        }
        if (this.g != null ? !this.g.equals(data.g) : data.g != null) {
            return false;
        }
        if (this.i != null ? !this.i.equals(data.i) : data.i != null) {
            return false;
        }
        return !(this.e != null ? !this.e.equals(data.e) : data.e != null);
    }

    @NotNull
    protected final String computeInterpreterDir(@NotNull String interpreterPath) {
        String string;
        long l2 = w ^ 0x7AFB7E8405C5L;
        if (interpreterPath == null) {
            RubySdkAdditionalData.a(21);
        }
        if ((string = new File(interpreterPath).getParent()) == null) {
            throw new IllegalArgumentException("Incorrect interpreter path: " + interpreterPath);
        }
        String string2 = this.getSdkSystemAccessor().toSystemDependentName(string);
        if (string2 == null) {
            RubySdkAdditionalData.a(22);
        }
        return string2;
    }

    public int hashCode() {
        return this.fieldsHashCode();
    }

    protected int fieldsHashCode() {
        int n2 = this.g != null ? this.g.hashCode() : 0;
        n2 = 31 * n2 + (this.i != null ? this.i.hashCode() : 0);
        n2 = 31 * n2 + (this.e != null ? this.e.hashCode() : 0);
        return n2;
    }

    @NotNull
    public static String getInterpreterDir(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkAdditionalData.a(23);
        }
        RubySdkAdditionalData rubySdkAdditionalData = RubySdkAdditionalData.notNullFrom(sdk);
        String string = rubySdkAdditionalData.computeInterpreterDir(rubySdkAdditionalData.getInterpreterPath(sdk));
        if (string == null) {
            RubySdkAdditionalData.a(24);
        }
        return string;
    }

    @NotNull
    public static <T extends RubySdkAdditionalData> T load(@NotNull T data, @NotNull String interpreterPath, @NotNull Sdk sdk, @NotNull Element element) {
        String string;
        long l2 = w ^ 0x562A62653B40L;
        if (data == null) {
            RubySdkAdditionalData.a(25);
        }
        if (interpreterPath == null) {
            RubySdkAdditionalData.a(26);
        }
        if (sdk == null) {
            RubySdkAdditionalData.a(27);
        }
        if (element == null) {
            RubySdkAdditionalData.a(28);
        }
        if ((string = element.getAttributeValue(b)) == null) {
            string = sdk.getVersionString();
        }
        data.setNormalizedVersionString(string);
        data.setLanguageLevel(RubyVersionUtil.extractLanguageLevelFromVersion(string));
        data.withVersionManagerSdkAdditionalData(RubyVersionManagerSdkData.load(element, interpreterPath));
        String string2 = element.getAttributeValue(f);
        if (string2 != null) {
            data.setGemsBinDirectory(string2);
        }
        String string3 = element.getAttributeValue(a);
        if (string3 == null && SystemInfo.isWindows && !ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                data.setPlatform(RubyVersionUtil.extractPlatformFromVersion(RubyVersionUtil.getFullVersion(data.getRunner(null), interpreterPath, false)));
            }
            catch (ExecutionException executionException) {
                LOG.error((Throwable)executionException);
            }
        } else {
            data.setPlatform(string3);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        List list2 = element.getChildren(j);
        if (list2.isEmpty()) {
            if (sdk instanceof SdkModificator) {
                linkedList.addAll(RubySdkType.findGemsRoots((SdkModificator)sdk));
            }
        } else {
            for (Element element2 : list2) {
                Attribute attribute = element2.getAttribute(l);
                if (attribute == null) continue;
                linkedList.add(attribute.getValue());
            }
        }
        data.setGemsRootUrls(linkedList);
        T t2 = data;
        if (t2 == null) {
            RubySdkAdditionalData.a(29);
        }
        return t2;
    }

    @Nullable
    @Contract(value="null -> null", pure=true)
    public static RubySdkAdditionalData from(@Nullable Sdk sdk) {
        if (sdk == null) {
            return null;
        }
        SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
        return sdkAdditionalData instanceof RubySdkAdditionalData ? (RubySdkAdditionalData)sdkAdditionalData : null;
    }

    @NotNull
    @Contract(value="!null -> !null")
    public static RubySdkAdditionalData notNullFrom(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkAdditionalData.a(30);
        }
        RubySdkAdditionalData rubySdkAdditionalData = Objects.requireNonNull(RubySdkAdditionalData.from(sdk), () -> {
            long l2 = w ^ 0x5EB2D2717BF7L;
            if (sdk == null) {
                RubySdkAdditionalData.a(35);
            }
            return "Failed to extract sdk data from " + sdk;
        });
        if (rubySdkAdditionalData == null) {
            RubySdkAdditionalData.a(31);
        }
        return rubySdkAdditionalData;
    }

    @NotNull
    public static RubySdkAdditionalData getEmpty() {
        RubySdkAdditionalData rubySdkAdditionalData = c;
        if (rubySdkAdditionalData == null) {
            RubySdkAdditionalData.a(32);
        }
        return rubySdkAdditionalData;
    }

    public static boolean isEmpty(@NotNull Sdk sdk) {
        RubySdkAdditionalData rubySdkAdditionalData;
        if (sdk == null) {
            RubySdkAdditionalData.a(33);
        }
        return (rubySdkAdditionalData = RubySdkAdditionalData.from(sdk)) == null || rubySdkAdditionalData == c;
    }

    public static boolean areGemsUserLocal(@NotNull Sdk rubySdk) {
        if (rubySdk == null) {
            RubySdkAdditionalData.a(34);
        }
        return RubySdkSystemAccessor.notNullFrom(rubySdk).isWindows() || RubyVersionManagerSdkData.notNullFrom(rubySdk).areGemsUserLocal();
    }

    static {
        w = la.a(-7885119924371606865L, 4902580583739256283L, MethodHandles.lookup().lookupClass()).a(82992723023954L);
        c = new EmptyAdditionalData(null);
        LOG = Logger.getInstance(RubySdkType.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = w ^ 0x14731C26DFE1L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkAdditionalData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerSdkAdditionalData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 8: 
            case 23: 
            case 27: 
            case 30: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 10: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubySdk";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationParams";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkAdditionalData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionManagerSdkAdditionalData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withVersionManagerSdkAdditionalData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGemsBinDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterPathFor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunner";
                break;
            }
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerMappings";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkSystemAccessor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRvmSettings";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionCredentialId";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInterpreterDir";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterDir";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullFrom";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmpty";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withVersionManagerSdkAdditionalData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setGemsBinDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setGemsRootUrls";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterPathFor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRunnerMappings";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fieldsEqual";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "computeInterpreterDir";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterDir";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "notNullFrom";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "areGemsUserLocal";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$notNullFrom$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class EmptyAdditionalData
    extends RubySdkAdditionalData {
        private static final long m = la.a(-8262112149703985942L, -4739728044320221660L, MethodHandles.lookup().lookupClass()).a(159113827077616L);

        private EmptyAdditionalData() {
        }

        @Override
        @NotNull
        public RubyVersionManagerSdkData getVersionManagerSdkAdditionalData() {
            long l2 = m ^ 0x252944C25E89L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public RubySdkAdditionalData withVersionManagerSdkAdditionalData(@NotNull RubyVersionManagerSdkData versionManagerSdkAdditionalData) {
            long l2 = m ^ 0x6E172909E6E3L;
            if (versionManagerSdkAdditionalData == null) {
                EmptyAdditionalData.b(0);
            }
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public String getGemsBinDirectory() {
            long l2 = m ^ 0x1DB6D0199F86L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        public void setGemsBinDirectory(@NotNull String path) {
            long l2 = m ^ 0xC9D993A335CL;
            if (path == null) {
                EmptyAdditionalData.b(1);
            }
            throw new RuntimeException("Not applicable");
        }

        @Override
        public boolean hasGemsBinDirectory() {
            long l2 = m ^ 0x7CE0E4449951L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        public List<? extends String> getGemsRootUrls() {
            long l2 = m ^ 0x70AF25F3DBEAL;
            throw new RuntimeException("Not applicable");
        }

        @Override
        public void setGemsRootUrls(@NotNull List<String> urls) {
            long l2 = m ^ 0x6A074B0FBA02L;
            if (urls == null) {
                EmptyAdditionalData.b(2);
            }
            throw new RuntimeException("Not applicable");
        }

        @Override
        public void checkValid(SdkModel sdkModel) throws ConfigurationException {
            long l2 = m ^ 0x27B03CD15EDEL;
            throw new RuntimeException("Not applicable");
        }

        @Override
        public void save(@NotNull Element rootElement) {
            long l2 = m ^ 0x505918A80E3AL;
            if (rootElement == null) {
                EmptyAdditionalData.b(3);
            }
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public String getInterpreterPath(@NotNull Sdk sdk) {
            long l2 = m ^ 0x7AFF06601D45L;
            if (sdk == null) {
                EmptyAdditionalData.b(4);
            }
            throw new RuntimeException("Not applicable");
        }

        @Override
        public LanguageLevel getLanguageLevel() {
            long l2 = m ^ 0x7C02C8C6F187L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        public void setLanguageLevel(LanguageLevel languageLevel) {
            long l2 = m ^ 0x54A473CC0F8AL;
            throw new RuntimeException("Not applicable");
        }

        @Override
        public String getPlatform() {
            long l2 = m ^ 0xB76F45A91DFL;
            throw new RuntimeException("Not applicable");
        }

        @Override
        public void setPlatform(String platform) {
            long l2 = m ^ 0x1C3AABB55FF9L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public RubyRunner getRunner(@Nullable Module module) {
            long l2 = m ^ 0x52E767593061L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public PathMappingSettings getRunnerMappings(@Nullable Module module) {
            long l2 = m ^ 0x4F9EBA642504L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public PathMappingSettings getRunnerMappings(@NotNull AbstractRubyRunConfiguration configurationParams) {
            long l2 = m ^ 0x6F01CB606E01L;
            if (configurationParams == null) {
                EmptyAdditionalData.b(5);
            }
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public PathMappingSettings getRunnerMappings(@Nullable Module module, @Nullable PathMappingSettings baseMappings) {
            long l2 = m ^ 0xEF20781C310L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public RubySdkSystemAccessor getSdkSystemAccessor() {
            long l2 = m ^ 0x6F22317CAFF0L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public RvmSettings getRvmSettings() {
            long l2 = m ^ 0x1C3CF18C88AAL;
            throw new RuntimeException("Not applicable");
        }

        @Override
        @NotNull
        public String getConnectionCredentialId() {
            long l2 = m ^ 0x82A0F613D8BL;
            throw new RuntimeException("Not applicable");
        }

        @Override
        @Nullable
        public String getNormalizedVersionString() {
            long l2 = m ^ 0x7E755B78C476L;
            throw new RuntimeException("Not applicable");
        }

        @Override
        public void setNormalizedVersionString(@Nullable String normalizedVersionString) {
            long l2 = m ^ 0x21B025B3C21AL;
            throw new RuntimeException("Not applicable");
        }

        @Override
        protected boolean fieldsEqual(@NotNull RubySdkAdditionalData data) {
            long l2 = m ^ 0x268AE9663E7DL;
            if (data == null) {
                EmptyAdditionalData.b(6);
            }
            throw new RuntimeException("Not applicable");
        }

        @Override
        protected int fieldsHashCode() {
            long l2 = m ^ 0x655679490D25L;
            throw new RuntimeException("Not applicable");
        }

        /* synthetic */ EmptyAdditionalData(a x0) {
            this();
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = m ^ 0x134EF505814L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versionManagerSdkAdditionalData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urls";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationParams";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkAdditionalData$EmptyAdditionalData";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withVersionManagerSdkAdditionalData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setGemsBinDirectory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setGemsRootUrls";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInterpreterPath";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRunnerMappings";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fieldsEqual";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

