/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk.jruby;

import b.h.la;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.ui.SdkComparator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkType;
import org.jetbrains.plugins.ruby.utils.OSUtil;

public class JRubySdkUtil {
    @NonNls
    private static final String b = "--2.0";
    @NonNls
    private static final String d = "--1.9";
    @NonNls
    private static final String f = "--1.8";
    @NonNls
    public static final String JRUBY_CLASSPATH_ENV = "CLASSPATH";
    @NonNls
    private static final String c = "JRUBY_EXTRA_CLASSPATH";
    @NonNls
    public static final String JRUBY_OPTS = "JRUBY_OPTS";
    @NonNls
    public static final String JRUBY_JAVA_HOME = "rubymine.jruby.java.home";
    @NonNls
    private static final String e = "jruby.jar";
    private static final Pattern a;
    private static final long g;

    private JRubySdkUtil() {
    }

    public static Sdk[] getValidSdks() {
        List<Object> list2 = new ArrayList<Object>();
        list2.add(null);
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!JRubySdkUtil.isJRubySDK(sdk)) continue;
            list2.add(sdk);
        }
        list2 = SdkComparator.sortSdks(list2);
        return list2.toArray(new Sdk[0]);
    }

    public static boolean isJRubySDK(@Nullable Sdk sdk) {
        return sdk != null && sdk.getSdkType() instanceof JRubySdkType;
    }

    public static void specifyLanguageLevel(@NotNull GeneralCommandLine cmdLine, @Nullable Sdk sdk) {
        long l2 = g ^ 0x463C9D6BFE08L;
        if (cmdLine == null) {
            JRubySdkUtil.a(0);
        }
        assert (JRubySdkUtil.isJRubySDK(sdk));
        switch (RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk)) {
            case RUBY19: {
                JRubySdkUtil.a(cmdLine, d);
                break;
            }
            case RUBY20: {
                JRubySdkUtil.a(cmdLine, b);
                break;
            }
            case RUBY18: {
                JRubySdkUtil.a(cmdLine, f);
                break;
            }
        }
    }

    private static void a(@NotNull GeneralCommandLine generalCommandLine, @NotNull String string) {
        long l2 = g ^ 0x1A18C40871C0L;
        if (generalCommandLine == null) {
            JRubySdkUtil.a(1);
        }
        if (string == null) {
            JRubySdkUtil.a(2);
        }
        OSUtil.appendToEnvVariable(JRUBY_OPTS, string, generalCommandLine.getEnvironment(), " ");
    }

    public static boolean isJRubyGreaterThan17(@Nullable Sdk sdk) {
        long l2 = g ^ 0x6394A0276D30L;
        return JRubySdkUtil.isJRubySDK(sdk) && VersionComparatorUtil.compare((String)JRubySdkUtil.getJRubyShortVersion(sdk.getVersionString()), (String)"1.7.0.preview1") >= 0;
    }

    public static boolean isJRubyGreaterEqual19(@Nullable Sdk sdk) {
        long l2 = g ^ 0x12A9B839A399L;
        return JRubySdkUtil.isJRubySDK(sdk) && VersionComparatorUtil.compare((String)JRubySdkUtil.getJRubyShortVersion(sdk.getVersionString()), (String)"9.0.0.0.pre1") >= 0;
    }

    @NotNull
    public static LanguageLevel[] getSupportedLanguageLevels(@Nullable Sdk sdk) {
        long l2 = g ^ 0x4B0C77E68EEL;
        if (sdk != null && JRubySdkUtil.isJRubySDK(sdk) && VersionComparatorUtil.compare((String)JRubySdkUtil.getJRubyShortVersion(sdk.getVersionString()), (String)"1.7.4") >= 0) {
            LanguageLevel[] languageLevelArray = new LanguageLevel[]{LanguageLevel.RUBY18, LanguageLevel.RUBY19, LanguageLevel.RUBY20};
            if (languageLevelArray == null) {
                JRubySdkUtil.a(3);
            }
            return languageLevelArray;
        }
        LanguageLevel[] languageLevelArray = new LanguageLevel[]{LanguageLevel.RUBY18, LanguageLevel.RUBY19};
        if (languageLevelArray == null) {
            JRubySdkUtil.a(4);
        }
        return languageLevelArray;
    }

    @Nullable
    public static String getJRubyShortVersion(@Nullable String version) {
        if (version == null) {
            return null;
        }
        Matcher matcher = a.matcher(version);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    @Nullable
    public static String getJRubyMRILikeShortVersion(@Nullable String version) {
        if (version == null) {
            return null;
        }
        Matcher matcher = a.matcher(version);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }

    public static void addJRubyClassPathParams(@NotNull GeneralCommandLine cmdLine, @NotNull String classPath, boolean isForJavaExecutable) {
        long l2 = g ^ 0x651FAD5CCEC8L;
        if (cmdLine == null) {
            JRubySdkUtil.a(5);
        }
        if (classPath == null) {
            JRubySdkUtil.a(6);
        }
        cmdLine.addParameter(isForJavaExecutable ? "-cp" : "-J-cp");
        cmdLine.addParameter(classPath);
        cmdLine.getEnvironment().remove(JRUBY_CLASSPATH_ENV);
    }

    public static void addJRubyClassPath(@NotNull GeneralCommandLine cmdLine, @Nullable String additionalClassPath) {
        long l2 = g ^ 0x1135FA40FC68L;
        if (cmdLine == null) {
            JRubySdkUtil.a(7);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getenv(c);
        if (string != null) {
            stringBuilder.append(string);
        }
        String string2 = stringBuilder.toString();
        if (additionalClassPath != null) {
            string2 = OSUtil.appendToPATHenvVariable(string2, additionalClassPath);
        }
        if (StringUtil.isEmpty((String)string2)) {
            return;
        }
        JRubySdkUtil.addJRubyClassPathParams(cmdLine, string2, false);
    }

    public static void enableObjectSpaceIfNotOverriddenByUser(@NotNull AbstractRubyRunConfigurationParams conf) {
        Map<String, String> map;
        long l2 = g ^ 0x71023167C93L;
        if (conf == null) {
            JRubySdkUtil.a(8);
        }
        if (!(map = conf.getEnvs()).containsKey(JRUBY_OPTS)) {
            map.put(JRUBY_OPTS, "-X+O");
        }
    }

    public static String getLibPath(@NotNull Sdk sdk) {
        String string;
        long l2 = g ^ 0x6B76ABB3DD53L;
        if (sdk == null) {
            JRubySdkUtil.a(9);
        }
        if ((string = sdk.getHomePath()) == null) {
            return null;
        }
        String string2 = PathUtil.getParentPath((String)PathUtil.getParentPath((String)string));
        return FileUtil.join((String[])new String[]{string2, "lib"});
    }

    @NotNull
    public static String getJRubyJarPath(@NotNull Sdk sdk) {
        long l2 = g ^ 0x37C407BB8DC3L;
        if (sdk == null) {
            JRubySdkUtil.a(10);
        }
        String string = FileUtil.join((String[])new String[]{JRubySdkUtil.getLibPath(sdk), e});
        if (string == null) {
            JRubySdkUtil.a(11);
        }
        return string;
    }

    public static String getSourcesPathInJRubyJarFile(@NotNull Sdk sdk) {
        long l2 = g ^ 0x19A8877E4853L;
        if (sdk == null) {
            JRubySdkUtil.a(12);
        }
        String string = JRubySdkUtil.getJRubyJarPath(sdk);
        String string2 = JRubySdkUtil.isJRubyGreaterThan17(sdk) ? "jruby" : "builtin/javasupport";
        return "jar://" + string + "!/" + string2;
    }

    static {
        g = la.a(1827373432507309743L, -1931579476796222048L, MethodHandles.lookup().lookupClass()).a(8762874355042L);
        long l2 = g ^ 0x6E2ABAA0927FL;
        a = Pattern.compile("ver.(.*?)\\s*\\(([^)]*)\\).*(?:VM).*");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x78203A1BC446L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/jruby/JRubySdkUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/jruby/JRubySdkUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedLanguageLevels";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getJRubyJarPath";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "specifyLanguageLevel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendJrubyOpt";
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addJRubyClassPathParams";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addJRubyClassPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "enableObjectSpaceIfNotOverriddenByUser";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLibPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getJRubyJarPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSourcesPathInJRubyJarFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

