/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management;

import b.h.la;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathMappingSettings;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemsEnvironment;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.run.RubyAbstractRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkDataBase;

public abstract class RubyVersionManagerHandlerBase<Data extends RubyVersionManagerSdkDataBase<Data>>
extends RubyVersionManagerHandler<Data> {
    private static final Logger d;
    public static final String BASH = "bash";
    public static final String BASH_COMMAND = "-c";
    public static final String BASH_LOGIN_COMMAND = "-lc";
    private static final long o;

    @Override
    @NotNull
    public String getId() {
        String string = this.getVersionManagerExecutableName();
        if (string == null) {
            RubyVersionManagerHandlerBase.b(0);
        }
        return string;
    }

    protected boolean isMyPath(@NotNull String interpreterPath) {
        long l2 = o ^ 0x881FF3DB2A4L;
        if (interpreterPath == null) {
            RubyVersionManagerHandlerBase.b(1);
        }
        Path path = Paths.get(interpreterPath, new String[0]);
        if (!this.getVersionManagerExecutableName().equals(path.getFileName().toString())) {
            return false;
        }
        Path path2 = path.getParent();
        return path2 != null && "bin".equals(path2.getFileName().toString());
    }

    @NotNull
    public abstract String getVersionManagerExecutableName();

    @Override
    @Nullable
    protected Data doCreateAdditionalData(@NotNull RubyRemoteSdkAdditionalData remoteSdkAdditionalData) throws RemoteSdkException {
        String string;
        if (remoteSdkAdditionalData == null) {
            RubyVersionManagerHandlerBase.b(2);
        }
        if (!this.isMyPath(string = remoteSdkAdditionalData.getInterpreterPath())) {
            return null;
        }
        RubyRunner rubyRunner = remoteSdkAdditionalData.getRunner(null);
        String string2 = this.chooseDistribution(rubyRunner, string);
        remoteSdkAdditionalData.setInterpreterPath(this.computeInterpreterPath(rubyRunner, string, string2));
        return ((RubyVersionManagerSdkDataBase)((RubyVersionManagerSdkDataBase)this.createAdditionalData()).withDistributionId(string2)).withVersionManagerPath(FileUtil.toSystemIndependentName((String)string));
    }

    @NotNull
    protected String chooseDistribution(@NotNull RubyRunner runner, @NotNull String versionManagerPath) throws RemoteSdkException {
        List<String> list2;
        long l2 = o ^ 0x654FFF71438FL;
        if (runner == null) {
            RubyVersionManagerHandlerBase.b(3);
        }
        if (versionManagerPath == null) {
            RubyVersionManagerHandlerBase.b(4);
        }
        if ((list2 = this.getAvailableDistributions(runner, versionManagerPath)).isEmpty()) {
            throw new RemoteSdkException(RBundle.message((String)"version.manager.no.rubies.installed"));
        }
        Ref ref = Ref.create((Object)-1);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            long l2 = o ^ 0x7D599A2B8682L;
            ref.set((Object)Messages.showChooseDialog((String)"", (String)RBundle.message((String)"version.manager.select.distribution"), (String[])ArrayUtil.toStringArray((Collection)list2), (String)((String)list2.get(0)), null));
        });
        if ((Integer)ref.get() == -1) {
            throw new RemoteSdkException(RBundle.message((String)"version.manager.you.should.choose"));
        }
        String string = list2.get((Integer)ref.get());
        if (string == null) {
            RubyVersionManagerHandlerBase.b(5);
        }
        return string;
    }

    @NotNull
    public List<String> getAvailableDistributions(@NotNull RubyRunner runner, @NotNull String versionManagerPath) throws RemoteSdkException {
        ProcessOutput processOutput;
        long l2 = o ^ 0x5E51E7AA6596L;
        if (runner == null) {
            RubyVersionManagerHandlerBase.b(6);
        }
        if (versionManagerPath == null) {
            RubyVersionManagerHandlerBase.b(7);
        }
        try {
            processOutput = runner.execute((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(this.getAvailableDistributionsCommands(versionManagerPath)).inSameThread(30, RBundle.message((String)"version.manager.fetching.distributions.list")));
        }
        catch (ExecutionException executionException) {
            throw new RemoteSdkException(RBundle.message((String)"version.manager.error.fetching.distributions.list"), (Throwable)executionException);
        }
        if (processOutput == null) {
            throw new RemoteSdkException(RBundle.message((String)"version.manager.error.fetching.distributions.list"));
        }
        List<String> list2 = this.processAvailableDistributionsOutput(processOutput.getStdoutLines());
        if (list2 == null) {
            RubyVersionManagerHandlerBase.b(8);
        }
        return list2;
    }

    @NotNull
    protected abstract List<String> getAvailableDistributionsCommands(@NotNull String var1);

    @NotNull
    protected List<String> processAvailableDistributionsOutput(@NotNull List<String> rawOutput) {
        if (rawOutput == null) {
            RubyVersionManagerHandlerBase.b(9);
        }
        List<String> list2 = rawOutput;
        if (list2 == null) {
            RubyVersionManagerHandlerBase.b(10);
        }
        return list2;
    }

    @NotNull
    protected String computeInterpreterPath(@NotNull RubyRunner runner, @NotNull String versionManagerPath, @NotNull String distributionId) throws RemoteSdkException {
        String string;
        long l2 = o ^ 0x7641075690E9L;
        if (runner == null) {
            RubyVersionManagerHandlerBase.b(11);
        }
        if (versionManagerPath == null) {
            RubyVersionManagerHandlerBase.b(12);
        }
        if (distributionId == null) {
            RubyVersionManagerHandlerBase.b(13);
        }
        try {
            String string2;
            ProcessOutput processOutput = runner.execute((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(this.patchCommands(versionManagerPath, distributionId, Arrays.asList("gem", "env"))).inSameThread(30, RBundle.message((String)"version.manager.computing.interpreter.path")));
            String string3 = string2 = processOutput == null ? null : RubyGemsEnvironment.parse(processOutput.getStdout()).getRubyExecutable();
            if (StringUtil.isEmpty((String)string2)) {
                throw new RemoteSdkException(RBundle.message((String)"version.manager.unable.to.find.executable", (Object[])new Object[]{distributionId}));
            }
            string = string2;
        }
        catch (ExecutionException executionException) {
            throw new RemoteSdkException(RBundle.message((String)"version.manager.unable.to.get.environment", (Object[])new Object[]{distributionId, executionException.getMessage()}), (Throwable)executionException);
        }
        if (string == null) {
            RubyVersionManagerHandlerBase.b(14);
        }
        return string;
    }

    @Override
    public void doPatchCommandLine(@NotNull RubyAbstractRunner rubyRunner, @NotNull GeneralCommandLine commandLine, @NotNull Map<String, String> envParams, @NotNull Map<String, String> customEnvVariables, @NotNull Sdk sdk, @NotNull PathMappingSettings pathMappings) throws ExecutionException {
        RubyVersionManagerSdkDataBase rubyVersionManagerSdkDataBase;
        if (rubyRunner == null) {
            RubyVersionManagerHandlerBase.b(15);
        }
        if (commandLine == null) {
            RubyVersionManagerHandlerBase.b(16);
        }
        if (envParams == null) {
            RubyVersionManagerHandlerBase.b(17);
        }
        if (customEnvVariables == null) {
            RubyVersionManagerHandlerBase.b(18);
        }
        if (sdk == null) {
            RubyVersionManagerHandlerBase.b(19);
        }
        if (pathMappings == null) {
            RubyVersionManagerHandlerBase.b(20);
        }
        if (!(rubyVersionManagerSdkDataBase = RubyVersionManagerSdkDataBase.notNullFrom(sdk)).hasVersionManagerPath()) {
            this.clarifyVersionManagerPath(sdk);
        }
        List<String> list2 = this.patchCommands(rubyVersionManagerSdkDataBase.getVersionManagerPath(), rubyVersionManagerSdkDataBase.getDistributionId(), commandLine.getCommandLineList(null));
        commandLine.setExePath(list2.remove(0));
        commandLine.getParametersList().clearAll();
        commandLine.withParameters(list2);
        RubyVersionManagerHandlerBase.removeGemHomeAndGemPath(envParams, commandLine);
    }

    @NotNull
    protected abstract List<String> patchCommands(@NotNull String var1, @NotNull String var2, @NotNull List<String> var3);

    @NotNull
    public Data createAdditionalData(@NotNull RubySdkInfo sdkInfo) {
        if (sdkInfo == null) {
            RubyVersionManagerHandlerBase.b(21);
        }
        Object Data2 = ((RubyVersionManagerSdkDataBase)((RubyVersionManagerSdkDataBase)this.createAdditionalData()).withVersionManagerPath(sdkInfo.getPathToVersionManager())).withDistributionId(sdkInfo.getInterpreterHome().getName());
        if (Data2 == null) {
            RubyVersionManagerHandlerBase.b(22);
        }
        return Data2;
    }

    @NotNull
    protected List<String> getAdditionalPathsToSearch() {
        List<String> list2 = Collections.emptyList();
        if (list2 == null) {
            RubyVersionManagerHandlerBase.b(23);
        }
        return list2;
    }

    protected void clarifyVersionManagerPath(@NotNull Sdk sdk) throws ExecutionException {
        long l2 = o ^ 0xE1FBB8FEACL;
        if (sdk == null) {
            RubyVersionManagerHandlerBase.b(24);
        }
        d.info("Clarifying version manager path for " + sdk);
        RubyRunner rubyRunner = RubyRunner.notNullFrom(sdk);
        String string = this.getVersionManagerExecutableName();
        String string2 = string.toUpperCase(Locale.ENGLISH);
        ExecutionModes.SameThreadMode sameThreadMode = new ExecutionModes.SameThreadMode(false, RBundle.message((String)"version.manager.detection.path", (Object[])new Object[]{string}), 30);
        ProcessOutput processOutput = null;
        ArrayList<String> arrayList = new ArrayList<String>(this.getAdditionalPathsToSearch());
        arrayList.add("$PATH");
        try {
            processOutput = rubyRunner.execute((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(BASH, BASH_LOGIN_COMMAND, "PATH=" + StringUtil.join(arrayList, (String)":") + " \\which " + string).withExecutionMode((ExecutionMode)sameThreadMode)).withPty(true));
        }
        catch (ExecutionException executionException) {
            d.warn("Error looking for version manager executable: executableName: [" + string + "]; paths: [" + arrayList + "]; runner: [" + rubyRunner + "]", (Throwable)executionException);
        }
        if (processOutput != null && processOutput.getExitCode() == 0 && !processOutput.getStdoutLines().isEmpty()) {
            RubyVersionManagerSdkDataBase.notNullFrom(sdk).withVersionManagerPath((String)processOutput.getStdoutLines().get(0));
        } else {
            Ref ref = Ref.create();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                long l2 = o ^ 0x5073F4AC704BL;
                if (sdk == null) {
                    RubyVersionManagerHandlerBase.b(28);
                }
                ref.set((Object)Messages.showInputDialog((String)RBundle.message((String)"version.manager.detection.dialog.message", (Object[])new Object[]{string, sdk.toString()}), (String)RBundle.message((String)"version.manager.detection.dialog.title", (Object[])new Object[]{string2}), (Icon)Messages.getQuestionIcon()));
            });
            if (StringUtil.isNotEmpty((String)((String)ref.get()))) {
                RubyVersionManagerSdkDataBase.notNullFrom(sdk).withVersionManagerPath((String)ref.get());
            } else {
                throw new ExecutionException(RBundle.message((String)"version.manager.detection.not.found", (Object[])new Object[]{string2}));
            }
        }
    }

    protected static List<String> getCommandsSequence(List<String> ... commands) {
        long l2 = o ^ 0x195E278045BFL;
        if (commands == null) {
            RubyVersionManagerHandlerBase.b(25);
        }
        return new GeneralCommandLine(new String[]{BASH, BASH_COMMAND, Stream.of(commands).map(list2 -> new GeneralCommandLine(list2).getCommandLineString()).collect(Collectors.joining(" && "))}).getCommandLineList(null);
    }

    @Contract(pure=true)
    @NotNull
    protected static String getVersionFromInterpreterPath(@NotNull String interpreterPath) {
        Path path;
        Path path2;
        Path path3;
        long l2 = o ^ 0x59A206C4AD0L;
        if (interpreterPath == null) {
            RubyVersionManagerHandlerBase.b(26);
        }
        Path path4 = path3 = (path2 = (path = Paths.get(interpreterPath, new String[0])).getParent()) == null ? null : path2.getParent();
        if (path3 == null) {
            throw new InvalidDataException("Invalid interpreter path: " + interpreterPath);
        }
        String string = path3.getFileName().toString();
        if (string == null) {
            RubyVersionManagerHandlerBase.b(27);
        }
        return string;
    }

    static {
        o = la.a(-5171189915459556278L, -4016788532392923949L, MethodHandles.lookup().lookupClass()).a(264691497529446L);
        d = Logger.getInstance(RubyVersionManagerHandlerBase.class);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = o ^ 0x7AD9FEC5D2EFL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/RubyVersionManagerHandlerBase";
                break;
            }
            case 1: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSdkAdditionalData";
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawOutput";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionId";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyRunner";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envParams";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customEnvVariables";
                break;
            }
            case 19: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkInfo";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/RubyVersionManagerHandlerBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseDistribution";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDistributions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "processAvailableDistributionsOutput";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInterpreterPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalData";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPathsToSearch";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionFromInterpreterPath";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMyPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doCreateAdditionalData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "chooseDistribution";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDistributions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processAvailableDistributionsOutput";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeInterpreterPath";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doPatchCommandLine";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalData";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "clarifyVersionManagerPath";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getCommandsSequence";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getVersionFromInterpreterPath";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$clarifyVersionManagerPath$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

