/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.actions.navigation;

import b.h.la;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import icons.RubyPsiApiIcons;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.actions.CreateNamedFileFix;
import org.jetbrains.plugins.ruby.rails.actions.navigation.RailsNavigateFromProvider;
import org.jetbrains.plugins.ruby.rails.actions.navigation.RailsNavigationAction;
import org.jetbrains.plugins.ruby.rails.codeInsight.daemon.RailsLineMarkerNavigator;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsBaseView;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;

public class SwitchToView
extends RailsNavigationAction {
    private static final String b;
    private static final String a;
    private static final long d;

    public SwitchToView() {
        long l2 = d ^ 0x21925A97DA5CL;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(RBundle.message((String)"codeInsight.rails.switch.to.view.title"));
        presentation.setIcon(RubyPsiApiIcons.ActionToView);
    }

    @Override
    public void execute(DataContext dataContext, boolean force) {
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module == null || !RailsFacetUtil.hasRailsSupport(module)) {
            SwitchToView.a();
            return;
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null) {
            SwitchToView.a();
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            SwitchToView.a();
            return;
        }
        PsiElement psiElement = SwitchToView.a(psiFile, editor);
        if (psiElement == null) {
            SwitchToView.a();
            return;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null || !(virtualFile.getFileType() instanceof RubyFileType) || virtualFile.getParent() == null) {
            SwitchToView.a();
            return;
        }
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(dataContext);
        SwitchToView.switchOrCreateView(psiElement, relativePoint);
    }

    @Nullable
    private static PsiElement a(PsiFile psiFile, Editor editor) {
        Document document;
        int n2;
        int n3;
        PsiElement psiElement;
        int n4 = editor.getCaretModel().getOffset();
        PsiElement psiElement2 = psiFile.findElementAt(n4);
        if (psiElement2 instanceof PsiWhiteSpace && (psiElement = psiElement2.getNextSibling()) != null && (n3 = editor.getCaretModel().getLogicalPosition().line) == (n2 = (document = editor.getDocument()).getLineNumber(psiElement.getTextOffset()))) {
            psiElement2 = psiElement;
        }
        return psiElement2;
    }

    public static void switchOrCreateView(PsiElement psiElement, RelativePoint relativePoint) {
        List list2 = RailsNavigateFromProvider.EP_NAME.getExtensionList();
        for (Object object : list2) {
            List<? extends RailsBaseView> list3 = ((RailsNavigateFromProvider)object).viewsBy(psiElement, true);
            if (list3.size() <= 0) continue;
            SwitchToView.switchToViews(list3, relativePoint);
            return;
        }
        RMethod rMethod = (RMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, RMethod.class);
        if (rMethod != null) {
            for (List<? extends RailsBaseView> list3 : list2) {
                String string = ((RailsNavigateFromProvider)((Object)list3)).viewsFolderUrlBy(psiElement);
                String string2 = ((RailsNavigateFromProvider)((Object)list3)).getDefaultViewExtension();
                if (string == null || string2 == null) continue;
                SwitchToView.promptCreateView(psiElement.getProject(), rMethod.getName(), string);
            }
        }
    }

    @Nullable
    private static VirtualFile a(String string) {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        VirtualFile virtualFile = virtualFileManager.findFileByUrl(string);
        if (virtualFile != null) {
            return virtualFile.isDirectory() ? virtualFile : null;
        }
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)((NullableComputable)() -> {
            try {
                return VfsUtil.createDirectoryIfMissing((String)VfsUtilCore.urlToPath((String)string));
            }
            catch (IOException iOException) {
                return null;
            }
        }));
    }

    static void promptCreateView(Project project, String defaultName, String viewFolderUrl) {
        long l2 = d ^ 0x57211FF78E66L;
        VirtualFile virtualFile = SwitchToView.a(viewFolderUrl);
        if (virtualFile == null || !virtualFile.isDirectory()) {
            return;
        }
        CreateNamedFileFix.createFile(project, defaultName, "Ruby.ViewRefParam.DefaultExtension", "html.erb", virtualFile, null, RBundle.message((String)"codeInsight.rails.switch.to.view.create.prompt"), RBundle.message((String)"codeInsight.rails.switch.to.view.title"));
    }

    public static void switchToViews(List<? extends RailsBaseView> views, RelativePoint relativePoint) {
        long l2 = d ^ 0x14CAA3C6D2ACL;
        ArrayList<PsiFile> arrayList = new ArrayList<PsiFile>();
        for (RailsBaseView railsBaseView : views) {
            arrayList.add(railsBaseView.getPsiFile());
        }
        int n2 = WindowManagerEx.getInstanceEx().getFrame((Project)((PsiFile)arrayList.get((int)0)).getProject()).getSize().width;
        RailsLineMarkerNavigator.openTargets((Navigatable[])PsiUtilCore.toPsiFileArray(arrayList), RBundle.message((String)"codeInsight.rails.navigation.title.action.view"), (ListCellRenderer)new GotoFileCellRenderer(n2), relativePoint);
    }

    @Override
    public boolean isEnabled(DataContext dataContext, boolean force) {
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (psiFile == null || editor == null) {
            return false;
        }
        PsiElement psiElement = SwitchToView.a(psiFile, editor);
        if (psiElement == null) {
            psiElement = psiFile;
        }
        for (RailsNavigateFromProvider railsNavigateFromProvider : RailsNavigateFromProvider.EP_NAME.getExtensionList()) {
            List<? extends RailsBaseView> list2 = railsNavigateFromProvider.viewsBy(psiElement, false);
            for (RailsBaseView railsBaseView : list2) {
                if (!force && railsBaseView.getPsiFile() == psiFile) continue;
                return true;
            }
            if (railsNavigateFromProvider.viewsFolderUrlBy(psiElement) == null) continue;
            return true;
        }
        return false;
    }

    private static void a() {
        Messages.showInfoMessage((String)b, (String)a);
    }

    static {
        d = la.a(-1945287313757410334L, 430321953794895498L, MethodHandles.lookup().lookupClass()).a(195126000845911L);
        long l2 = d ^ 0x5B75444F17B5L;
        b = RBundle.message((String)"codeInsight.rails.switch.to.view.cant.navigate");
        a = RBundle.message((String)"codeInsight.rails.switch.to.view.title");
    }
}

