/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIndexKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypedefIndex
extends StringStubIndexExtension<JSElement> {
    public static final StubIndexKey<String, JSElement> KEY = StubIndexKey.createIndexKey((String)"js.typedef.index2");
    private static final char ADDITIONAL_DATA_MARK = '\u0001';

    @NotNull
    public StubIndexKey<String, JSElement> getKey() {
        StubIndexKey<String, JSElement> stubIndexKey = KEY;
        if (stubIndexKey == null) {
            JSTypedefIndex.$$$reportNull$$$0(0);
        }
        return stubIndexKey;
    }

    @NotNull
    public static String getTypeByIndexValue(@NotNull String indexValue) {
        if (indexValue == null) {
            JSTypedefIndex.$$$reportNull$$$0(1);
        }
        if (indexValue.length() < 2 || indexValue.charAt(0) != '\u0001') {
            String string = indexValue;
            if (string == null) {
                JSTypedefIndex.$$$reportNull$$$0(2);
            }
            return string;
        }
        int additionalDataEnd = indexValue.indexOf(1, 1);
        if (additionalDataEnd == -1) {
            Logger.getInstance(JSTypedefIndex.class).error("Invalid typedef value" + StringUtil.escapeStringCharacters((String)indexValue));
            String string = indexValue;
            if (string == null) {
                JSTypedefIndex.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = indexValue.substring(additionalDataEnd + 1);
        if (string == null) {
            JSTypedefIndex.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static String getAdditionalDataByIndexValue(@NotNull String indexValue) {
        if (indexValue == null) {
            JSTypedefIndex.$$$reportNull$$$0(5);
        }
        if (indexValue.length() < 2 || indexValue.charAt(0) != '\u0001') {
            return null;
        }
        int additionalDataEnd = indexValue.indexOf(1, 1);
        if (additionalDataEnd == -1) {
            Logger.getInstance(JSTypedefIndex.class).error("Invalid typedef value" + StringUtil.escapeStringCharacters((String)indexValue));
            return null;
        }
        return indexValue.substring(1, additionalDataEnd);
    }

    @NotNull
    public static String addAdditionalData(@NotNull String indexValue, @NotNull String additionalData) {
        if (indexValue == null) {
            JSTypedefIndex.$$$reportNull$$$0(6);
        }
        if (additionalData == null) {
            JSTypedefIndex.$$$reportNull$$$0(7);
        }
        String string = '\u0001' + additionalData + '\u0001' + indexValue;
        if (string == null) {
            JSTypedefIndex.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/JSTypedefIndex";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexValue";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/JSTypedefIndex";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeByIndexValue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addAdditionalData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTypeByIndexValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalDataByIndexValue";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

