/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim.ruby.psi;

import com.intellij.embedding.TemplateMasqueradingLexer;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.xml.XmlDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.slim.SlimFileType;
import org.jetbrains.plugins.slim.SlimLanguage;
import org.jetbrains.plugins.slim.psi.SlimFile;

public final class SlimRubyUtil {
    private SlimRubyUtil() {
    }

    @NotNull
    private static PsiElement getMinusElement(Project project) {
        SlimFile newSlimFile = (SlimFile)RubyElementFactory.createPseudoPhysicalFile((Project)project, (FileType)SlimFileType.SLIM, (String)"- foo()");
        XmlDocument document = newSlimFile.getDocument();
        assert (document != null);
        PsiElement div = document.getFirstChild();
        PsiElement rubyInSlimCode = div.getFirstChild();
        PsiElement minus = rubyInSlimCode.getFirstChild();
        assert (minus != null && minus.getNode().getElementType() == TemplateMasqueradingLexer.MINUS_TYPE);
        PsiElement psiElement = minus;
        if (psiElement == null) {
            SlimRubyUtil.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    public static PsiElement addRubyStatementBefore(@NotNull PsiFile slimPsiFile, @NotNull RCompoundStatement compoundStatement, @NotNull PsiElement element, @Nullable PsiElement anchor) {
        if (slimPsiFile == null) {
            SlimRubyUtil.$$$reportNull$$$0(1);
        }
        if (compoundStatement == null) {
            SlimRubyUtil.$$$reportNull$$$0(2);
        }
        if (element == null) {
            SlimRubyUtil.$$$reportNull$$$0(3);
        }
        PsiElement elementAt = slimPsiFile.getViewProvider().findElementAt(compoundStatement.getTextRange().getStartOffset(), (Language)SlimLanguage.INSTANCE);
        assert (elementAt != null);
        RCompoundStatement parent = compoundStatement;
        if (anchor != null) {
            if (anchor.getPrevSibling() == null) {
                parent = parent.getParent();
                anchor = parent.getFirstChild();
            } else {
                while (anchor.getPrevSibling() != null && !anchor.getPrevSibling().getText().contains("\n")) {
                    anchor = anchor.getPrevSibling();
                }
            }
        }
        PsiElement rubyCodeStartMarker = SlimRubyUtil.getMinusElement(element.getProject());
        rubyCodeStartMarker = parent.addBefore(rubyCodeStartMarker, anchor);
        PsiElement lineBreak = PsiParserFacade.SERVICE.getInstance((Project)element.getProject()).createWhiteSpaceFromText("\n");
        parent.addAfter(lineBreak, rubyCodeStartMarker);
        anchor = rubyCodeStartMarker.getNextSibling();
        return parent.addBefore(element, anchor);
    }

    public static PsiElement addRubyStatementAfter(@NotNull PsiFile slimPsiFile, @NotNull RCompoundStatement compoundStatement, @NotNull PsiElement element) {
        if (slimPsiFile == null) {
            SlimRubyUtil.$$$reportNull$$$0(4);
        }
        if (compoundStatement == null) {
            SlimRubyUtil.$$$reportNull$$$0(5);
        }
        if (element == null) {
            SlimRubyUtil.$$$reportNull$$$0(6);
        }
        PsiElement elementAt = slimPsiFile.getViewProvider().findElementAt(compoundStatement.getTextRange().getStartOffset(), (Language)SlimLanguage.INSTANCE);
        assert (elementAt != null);
        PsiElement indentationBlock = elementAt.getParent();
        PsiFile newSlimFile = RubyElementFactory.createPseudoPhysicalFile((Project)slimPsiFile.getProject(), (FileType)SlimFileType.SLIM, (String)("- foo();\n- " + element.getText()));
        PsiElement parent = indentationBlock.getParent();
        PsiElement newLine = newSlimFile.getChildren()[1];
        PsiElement element2Insert = newSlimFile.getChildren()[2];
        return parent.addAfter(element2Insert, parent.addAfter(newLine, indentationBlock));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/slim/ruby/psi/SlimRubyUtil";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slimPsiFile";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compoundStatement";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinusElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/slim/ruby/psi/SlimRubyUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addRubyStatementBefore";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRubyStatementAfter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

