/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlConstraintStub;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlConstraintStubbedDefinitionImpl
extends SqlStubbedDefinitionImpl<SqlConstraintStub>
implements SqlConstraintDefinition {
    public SqlConstraintStubbedDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            SqlConstraintStubbedDefinitionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public SqlConstraintStubbedDefinitionImpl(SqlConstraintStub stub) {
        super(stub);
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = this.getConstraintType() == SqlConstraintDefinition.Type.CHECK ? ObjectKind.CHECK : SqlDbElementType.CONSTRAINT;
        if (objectKind == null) {
            SqlConstraintStubbedDefinitionImpl.$$$reportNull$$$0(1);
        }
        return objectKind;
    }

    @NotNull
    public SqlConstraintDefinition.Type getConstraintType() {
        IStubElementType type = this.getElementType();
        if (type == SqlCompositeElementTypes.SQL_CHECK_CONSTRAINT_DEFINITION) {
            SqlConstraintDefinition.Type type2 = SqlConstraintDefinition.Type.CHECK;
            if (type2 == null) {
                SqlConstraintStubbedDefinitionImpl.$$$reportNull$$$0(2);
            }
            return type2;
        }
        if (type == SqlCompositeElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION) {
            SqlConstraintDefinition.Type type3 = SqlConstraintDefinition.Type.DEFAULT;
            if (type3 == null) {
                SqlConstraintStubbedDefinitionImpl.$$$reportNull$$$0(3);
            }
            return type3;
        }
        SqlConstraintDefinition.Type type4 = SqlConstraintDefinition.Type.OTHER;
        if (type4 == null) {
            SqlConstraintStubbedDefinitionImpl.$$$reportNull$$$0(4);
        }
        return type4;
    }

    @Nullable
    public <T> T getConstraintParameter(Key<T> key2) {
        PsiElement child;
        if (key2 != EXPRESSION) {
            return null;
        }
        SqlConstraintStub stub = (SqlConstraintStub)this.getStub();
        if (stub != null) {
            return (T)stub.getExpression();
        }
        SqlReferenceExpression name = this.getNameElement();
        PsiElement psiElement = child = name == null ? this.getFirstChild() : name.getNextSibling();
        while (child != null) {
            if (child instanceof SqlExpression) {
                return (T)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public String getTableName() {
        DasTable table = this.getTable();
        return table == null ? null : table.getName();
    }

    public DasTable getTable() {
        SqlCreateTableStatement tab = (SqlCreateTableStatement)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this, SqlCreateTableStatement.class);
        if (tab != null) {
            return tab;
        }
        SqlReferenceExpression ref = this.getParentAlterTargetRef();
        return ref == null ? null : (DasTable)ObjectUtils.tryCast((Object)ref.resolve(), DasTable.class);
    }

    @Override
    public DasObject getDasParent() {
        DasTable table = this.getTable();
        if (table != null) {
            return table;
        }
        SqlReferenceExpression ref = this.getParentAlterTargetRef();
        if (ref != null) {
            return (DasObject)ObjectUtils.tryCast((Object)ref.resolve(), DasTable.class);
        }
        return (DasObject)PsiTreeUtil.getParentOfType((PsiElement)this, SqlDefinition.class, (boolean)true);
    }

    @Override
    @Nullable
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        return SqlCompositeElementTypes.SQL_CONSTRAINT_REFERENCE;
    }

    public SqlReferenceExpression getNameElement() {
        return (SqlReferenceExpression)super.getNameElement();
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (this.getConstraintType() == SqlConstraintDefinition.Type.CHECK) {
            if (!SqlImplUtil.isProcessingOneOf(processor, ObjectKind.TABLE, ObjectKind.COLUMN)) {
                return true;
            }
            SqlCreateStatement statement = (SqlCreateStatement)PsiTreeUtil.getParentOfType((PsiElement)this, SqlCreateStatement.class, (boolean)true);
            if (statement != null) {
                if (!processor.execute((PsiElement)statement, state)) {
                    return false;
                }
                if (!statement.processDeclarations(processor, state, (PsiElement)statement, place)) {
                    return false;
                }
            }
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    @NotNull
    public MultiRef<? extends DasTypedObject> getColumnsRef() {
        SqlColumnDefinitionImpl column2 = (SqlColumnDefinitionImpl)this.getStubOrPsiParentOfType(SqlColumnDefinitionImpl.class);
        if (column2 != null) {
            MultiRef multiRef = DasUtil.asRef(Collections.singletonList(column2));
            if (multiRef == null) {
                SqlConstraintStubbedDefinitionImpl.$$$reportNull$$$0(5);
            }
            return multiRef;
        }
        MultiRef multiRef = DasUtil.emptyMultiRef();
        if (multiRef == null) {
            SqlConstraintStubbedDefinitionImpl.$$$reportNull$$$0(6);
        }
        return multiRef;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlConstraintStubbedDefinitionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlConstraintStubbedDefinitionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstraintType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnsRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

