/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.ComboPopup;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.plaf.UIDependent;
import org.jdesktop.swingx.renderer.DefaultListRenderer;
import org.jdesktop.swingx.renderer.JRendererPanel;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.rollover.RolloverRenderer;
import org.jdesktop.swingx.util.Contract;

public class JXComboBox
extends JComboBox {
    private ComboBoxAdapter dataAdapter;
    private DelegatingRenderer delegatingRenderer;
    private boolean useHighlightersForCurrentValue = true;
    private CompoundHighlighter compoundHighlighter;
    private ChangeListener highlighterChangeListener;
    private List<KeyEvent> pendingEvents = new ArrayList<KeyEvent>();
    private boolean isDispatching;

    public JXComboBox() {
    }

    public JXComboBox(ComboBoxModel model) {
        super(model);
    }

    public JXComboBox(Object[] items) {
        super(items);
    }

    public JXComboBox(Vector<?> items) {
        super(items);
    }

    protected static JList getPopupListFor(JComboBox comboBox) {
        int count = comboBox.getUI().getAccessibleChildrenCount(comboBox);
        for (int i = 0; i < count; ++i) {
            Accessible a = comboBox.getUI().getAccessibleChild(comboBox, i);
            if (!(a instanceof ComboPopup)) continue;
            return ((ComboPopup)((Object)a)).getList();
        }
        return null;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        boolean retValue = super.processKeyBinding(ks, e, condition, pressed);
        if (!retValue && this.editor != null) {
            if (this.isStartingCellEdit(e)) {
                this.pendingEvents.add(e);
            } else if (this.pendingEvents.size() == 2) {
                this.pendingEvents.add(e);
                this.isDispatching = true;
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            for (KeyEvent event : JXComboBox.this.pendingEvents) {
                                JXComboBox.this.editor.getEditorComponent().dispatchEvent(event);
                            }
                            JXComboBox.this.pendingEvents.clear();
                        }
                        finally {
                            JXComboBox.this.isDispatching = false;
                        }
                    }
                });
            }
        }
        return retValue;
    }

    private boolean isStartingCellEdit(KeyEvent e) {
        if (this.isDispatching) {
            return false;
        }
        JTable table = (JTable)SwingUtilities.getAncestorOfClass(JTable.class, this);
        boolean isOwned = table != null && !Boolean.FALSE.equals(table.getClientProperty("JTable.autoStartsEdit"));
        return isOwned && e.getComponent() == table;
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new ComboBoxAdapter(this);
        }
        return this.dataAdapter;
    }

    protected ComponentAdapter getComponentAdapter(int index) {
        ComponentAdapter adapter = this.getComponentAdapter();
        adapter.column = 0;
        adapter.row = index;
        return adapter;
    }

    private DelegatingRenderer getDelegatingRenderer() {
        if (this.delegatingRenderer == null) {
            this.delegatingRenderer = new DelegatingRenderer();
        }
        return this.delegatingRenderer;
    }

    protected ListCellRenderer createDefaultCellRenderer() {
        return new DefaultListRenderer();
    }

    public ListCellRenderer getRenderer() {
        return this.getDelegatingRenderer();
    }

    public ListCellRenderer getWrappedRenderer() {
        return this.getDelegatingRenderer().getDelegateRenderer();
    }

    public void setRenderer(ListCellRenderer renderer) {
        ListCellRenderer oldValue = super.getRenderer();
        this.getDelegatingRenderer().setDelegateRenderer(renderer);
        super.setRenderer(this.delegatingRenderer);
        if (oldValue == this.delegatingRenderer) {
            this.firePropertyChange("renderer", null, this.delegatingRenderer);
        }
    }

    public boolean isUseHighlightersForCurrentValue() {
        return this.useHighlightersForCurrentValue;
    }

    public void setUseHighlightersForCurrentValue(boolean useHighlightersForCurrentValue) {
        boolean oldValue = this.isUseHighlightersForCurrentValue();
        this.useHighlightersForCurrentValue = useHighlightersForCurrentValue;
        this.firePropertyChange("useHighlightersForCurrentValue", oldValue, this.isUseHighlightersForCurrentValue());
    }

    private CompoundHighlighter getCompoundHighlighter() {
        return this.compoundHighlighter;
    }

    private void setCompoundHighlighter(CompoundHighlighter pipeline) {
        CompoundHighlighter old = this.getCompoundHighlighter();
        if (old != null) {
            old.removeChangeListener(this.getHighlighterChangeListener());
        }
        this.compoundHighlighter = pipeline;
        if (this.compoundHighlighter != null) {
            this.compoundHighlighter.addChangeListener(this.getHighlighterChangeListener());
        }
        this.firePropertyChange("highlighters", old, this.getCompoundHighlighter());
    }

    public void setHighlighters(Highlighter ... highlighters) {
        Contract.asNotNull(highlighters, "highlighters cannot be null or contain null");
        CompoundHighlighter pipeline = null;
        if (highlighters.length > 0) {
            pipeline = new CompoundHighlighter(highlighters);
        }
        this.setCompoundHighlighter(pipeline);
    }

    public Highlighter[] getHighlighters() {
        return this.getCompoundHighlighter() != null ? this.getCompoundHighlighter().getHighlighters() : CompoundHighlighter.EMPTY_HIGHLIGHTERS;
    }

    public void addHighlighter(Highlighter highlighter) {
        CompoundHighlighter pipeline = this.getCompoundHighlighter();
        if (pipeline == null) {
            this.setCompoundHighlighter(new CompoundHighlighter(highlighter));
        } else {
            pipeline.addHighlighter(highlighter);
        }
    }

    public void removeHighlighter(Highlighter highlighter) {
        if (this.getCompoundHighlighter() == null) {
            return;
        }
        this.getCompoundHighlighter().removeHighlighter(highlighter);
    }

    protected ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = this.createHighlighterChangeListener();
        }
        return this.highlighterChangeListener;
    }

    protected ChangeListener createHighlighterChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JXComboBox.this.firePropertyChange("highlighters", null, JXComboBox.this.getHighlighters());
                JXComboBox.this.repaint();
            }
        };
    }

    @Override
    public void updateUI() {
        super.updateUI();
        ListCellRenderer renderer = this.getRenderer();
        if (renderer instanceof UIDependent) {
            ((UIDependent)((Object)renderer)).updateUI();
        } else if (renderer instanceof Component) {
            SwingUtilities.updateComponentTreeUI((Component)((Object)renderer));
        }
        if (this.compoundHighlighter != null) {
            this.compoundHighlighter.updateUI();
        }
    }

    protected static class ComboBoxAdapter
    extends ComponentAdapter {
        private final JComboBox comboBox;

        public ComboBoxAdapter(JComboBox component) {
            super(component);
            this.comboBox = component;
        }

        public JComboBox getComboBox() {
            return this.comboBox;
        }

        @Override
        public boolean hasFocus() {
            if (this.comboBox.isPopupVisible()) {
                JList list = JXComboBox.getPopupListFor(this.comboBox);
                return list != null && list.isFocusOwner() && this.row == list.getLeadSelectionIndex();
            }
            return this.comboBox.isFocusOwner();
        }

        @Override
        public int getRowCount() {
            return this.comboBox.getModel().getSize();
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.comboBox.getModel().getElementAt(row);
        }

        @Override
        public String getStringAt(int row, int column) {
            ListCellRenderer renderer = this.comboBox.getRenderer();
            if (renderer instanceof DelegatingRenderer) {
                renderer = ((DelegatingRenderer)renderer).getDelegateRenderer();
            }
            if (renderer instanceof StringValue) {
                return ((StringValue)((Object)renderer)).getString(this.getValueAt(row, column));
            }
            return super.getStringAt(row, column);
        }

        @Override
        public Rectangle getCellBounds() {
            JList list = JXComboBox.getPopupListFor(this.comboBox);
            if (list == null) {
                assert (false);
                return new Rectangle(this.comboBox.getSize());
            }
            return list.getCellBounds(this.row, this.row);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return row == -1 && this.comboBox.isEditable();
        }

        @Override
        public boolean isEditable() {
            return this.isCellEditable(this.row, this.column);
        }

        @Override
        public boolean isSelected() {
            if (this.comboBox.isPopupVisible()) {
                JList list = JXComboBox.getPopupListFor(this.comboBox);
                return list != null && this.row == list.getLeadSelectionIndex();
            }
            return this.comboBox.isFocusOwner();
        }
    }

    public class DelegatingRenderer
    implements ListCellRenderer,
    RolloverRenderer,
    UIDependent {
        private ListCellRenderer delegateRenderer;
        private JRendererPanel wrapper = new JRendererPanel(new BorderLayout());

        public DelegatingRenderer() {
            this(null);
        }

        public DelegatingRenderer(ListCellRenderer delegate) {
            this.setDelegateRenderer(delegate);
        }

        public void setDelegateRenderer(ListCellRenderer delegate) {
            if (delegate == null) {
                delegate = JXComboBox.this.createDefaultCellRenderer();
            }
            this.delegateRenderer = delegate;
        }

        public ListCellRenderer getDelegateRenderer() {
            return this.delegateRenderer;
        }

        @Override
        public void updateUI() {
            this.wrapper.updateUI();
            if (this.delegateRenderer instanceof UIDependent) {
                ((UIDependent)((Object)this.delegateRenderer)).updateUI();
            } else if (this.delegateRenderer instanceof Component) {
                SwingUtilities.updateComponentTreeUI((Component)((Object)this.delegateRenderer));
            } else if (this.delegateRenderer != null) {
                try {
                    Component comp = this.delegateRenderer.getListCellRendererComponent(JXComboBox.getPopupListFor(JXComboBox.this), null, -1, false, false);
                    SwingUtilities.updateComponentTreeUI(comp);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = null;
            if (index == -1) {
                comp = this.delegateRenderer.getListCellRendererComponent(list, value, JXComboBox.this.getSelectedIndex(), isSelected, cellHasFocus);
                if (JXComboBox.this.isUseHighlightersForCurrentValue() && JXComboBox.this.compoundHighlighter != null && JXComboBox.this.getSelectedIndex() != -1) {
                    comp = JXComboBox.this.compoundHighlighter.highlight(comp, JXComboBox.this.getComponentAdapter(JXComboBox.this.getSelectedIndex()));
                    this.wrapper.add(comp);
                    comp = this.wrapper;
                }
            } else {
                comp = this.delegateRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (JXComboBox.this.compoundHighlighter != null && index >= 0 && index < JXComboBox.this.getItemCount()) {
                    comp = JXComboBox.this.compoundHighlighter.highlight(comp, JXComboBox.this.getComponentAdapter(index));
                }
            }
            return comp;
        }

        @Override
        public boolean isEnabled() {
            return this.delegateRenderer instanceof RolloverRenderer && ((RolloverRenderer)((Object)this.delegateRenderer)).isEnabled();
        }

        @Override
        public void doClick() {
            if (this.isEnabled()) {
                ((RolloverRenderer)((Object)this.delegateRenderer)).doClick();
            }
        }
    }
}

