/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.CompareLocalVsRemoteTask;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.LocalVsRemoteTaskBase;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.LocalVsRemoteActionBase;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.DiffRoot;
import com.jetbrains.plugins.webDeployment.ui.LocalMappingDiffRoot;
import com.jetbrains.plugins.webDeployment.ui.WebServerToolWindowFactory;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareLocalVsRemoteAction
extends LocalVsRemoteActionBase {
    private static final Logger LOG = Logger.getInstance(CompareLocalVsRemoteAction.class);

    public CompareLocalVsRemoteAction() {
        super(WDBundle.message("compare.with.local.version", new Object[0]));
    }

    @Override
    protected LocalVsRemoteTaskBase createTask(final LocalVsRemoteActionBase.LocalData data) {
        final LocalMappingDiffRoot diffRoot = data.myDiffRoots.get(0);
        return new CompareLocalVsRemoteTask(data.project, WDBundle.message("compare.with.server.version", new Object[0]), data.server, ToolWindowId.PROJECT_VIEW, diffRoot){

            @Override
            protected DiffRoot getFullData(ExecutionContextBase context, LocalMappingDiffRoot root) throws FileSystemException {
                FileObject remote = LocalVsRemoteActionBase.getRemoteItem(context, diffRoot.getMapping(), diffRoot.getLocal(), data.server);
                return DiffRoot.create(diffRoot.getLocal(), remote, diffRoot.getMapping());
            }
        };
    }

    @Override
    protected LocalVsRemoteTaskBase createTask(final LocalVsRemoteActionBase.RemoteData data) {
        LOG.assertTrue(data.files.size() == 1);
        final DiffRoot diffRoot = data.files.get(0);
        return new CompareLocalVsRemoteTask(data.project, UIUtil.removeMnemonic((String)WDBundle.message("compare.with.local.version", new Object[0])), data.server, WebServerToolWindowFactory.SERVER_BROWSER_TOOLWINDOW, diffRoot){

            @Override
            protected DiffRoot getFullData(ExecutionContextBase context, LocalMappingDiffRoot root) throws FileSystemException {
                FileObject remote = LocalVsRemoteActionBase.getRemoteItem(context, diffRoot.getRemote());
                return DiffRoot.create(diffRoot.getLocal(), remote, diffRoot.getMapping());
            }

            @Override
            protected RemoteConnection getExistingConnection() {
                return data.connection;
            }
        };
    }

    @Override
    protected String getProjectViewTitle(@NotNull Deployable serverConfig) {
        if (serverConfig == null) {
            CompareLocalVsRemoteAction.$$$reportNull$$$0(0);
        }
        return WDBundle.message("compare.with.server.0.version", serverConfig.getName());
    }

    @Override
    @Nullable
    protected LocalVsRemoteActionBase.RemoteData getRemoteDataIfEnabledOnRemoteHostView(AnActionEvent event) {
        ServerTreeNode[] nodes = (ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(event.getDataContext());
        if (nodes == null || nodes.length != 1 || nodes[0].getFileType() != FileType.FILE) {
            return null;
        }
        return super.getRemoteDataIfEnabledOnRemoteHostView(event);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverConfig", "com/jetbrains/plugins/webDeployment/actions/CompareLocalVsRemoteAction", "getProjectViewTitle"));
    }
}

