/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.FocusEvent;
import java.io.Serializable;
import java.text.Format;
import java.text.ParseException;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.NavigationFilter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JFormattedTextField
extends JTextField {
    private static final long serialVersionUID = 5464657870110180632L;
    public static final int COMMIT = 0;
    public static final int COMMIT_OR_REVERT = 1;
    public static final int REVERT = 2;
    public static final int PERSIST = 3;
    private Object value;
    private int focusLostBehavior;
    private AbstractFormatterFactory formatterFactory;
    boolean editValid;

    public void commitEdit() throws ParseException {
        throw new InternalError("not implemented");
    }

    public Action[] getActions() {
        return super.getActions();
    }

    public int getFocusLostBehavior() {
        return this.focusLostBehavior;
    }

    public AbstractFormatter getFormatter() {
        if (this.formatterFactory == null) {
            return null;
        }
        return this.formatterFactory.getFormatter(this);
    }

    public AbstractFormatterFactory getFormatterFactory() {
        return this.formatterFactory;
    }

    public String getUIClassID() {
        return "FormattedTextFieldUI";
    }

    public Object getValue() {
        return this.value;
    }

    protected void invalidEdit() {
        UIManager.getLookAndFeel().provideErrorFeedback(this);
    }

    public boolean isEditValid() {
        return this.editValid;
    }

    protected void processFocusEvent(FocusEvent evt) {
        super.processFocusEvent(evt);
    }

    public void setDocument(Document newDocument) {
        Document oldDocument = this.getDocument();
        if (oldDocument == newDocument) {
            return;
        }
        super.setDocument(newDocument);
    }

    public void setFocusLostBehavior(int behavior) {
        if (behavior != 0 && behavior != 1 && behavior != 3 && behavior != 2) {
            throw new IllegalArgumentException("invalid behavior");
        }
        this.focusLostBehavior = behavior;
    }

    protected void setFormatter(AbstractFormatter formatter) {
        AbstractFormatter oldFormatter = null;
        if (this.formatterFactory != null) {
            oldFormatter = this.formatterFactory.getFormatter(this);
        }
        if (oldFormatter == formatter) {
            return;
        }
        this.setFormatterFactory(new FormatterFactoryWrapper(formatter));
        this.firePropertyChange("formatter", oldFormatter, formatter);
    }

    public void setFormatterFactory(AbstractFormatterFactory factory) {
        if (this.formatterFactory == factory) {
            return;
        }
        AbstractFormatterFactory oldFactory = this.formatterFactory;
        this.formatterFactory = factory;
        this.firePropertyChange("formatterFactory", oldFactory, factory);
    }

    public void setValue(Object newValue) {
        if (this.value == newValue) {
            return;
        }
        AbstractFormatter formatter = this.createFormatter(newValue);
        try {
            this.setText(formatter.valueToString(newValue));
        }
        catch (ParseException oldValue) {
            // empty catch block
        }
        Object oldValue = this.value;
        this.value = newValue;
        this.firePropertyChange("value", oldValue, newValue);
    }

    AbstractFormatter createFormatter(Object value) {
        AbstractFormatter formatter = null;
        formatter = this.formatterFactory != null && this.formatterFactory.getFormatter(this) != null ? this.formatterFactory.getFormatter(this) : (value instanceof Date ? new DateFormatter() : new DefaultFormatter());
        return formatter;
    }

    private final /* synthetic */ void this() {
        this.focusLostBehavior = 1;
        this.editValid = true;
    }

    public JFormattedTextField() {
        this(null, null);
    }

    public JFormattedTextField(Format format) {
        this.this();
        throw new InternalError("not implemented");
    }

    public JFormattedTextField(AbstractFormatter formatter) {
        this(new FormatterFactoryWrapper(formatter), null);
    }

    public JFormattedTextField(AbstractFormatterFactory factory) {
        this(factory, null);
    }

    public JFormattedTextField(AbstractFormatterFactory factory, Object value) {
        this.this();
        this.formatterFactory = factory;
        this.value = value;
    }

    public JFormattedTextField(Object value) {
        this.this();
        this.value = value;
    }

    public static abstract class AbstractFormatterFactory {
        public abstract AbstractFormatter getFormatter(JFormattedTextField var1);
    }

    static class FormatterFactoryWrapper
    extends AbstractFormatterFactory {
        AbstractFormatter formatter;

        public AbstractFormatter getFormatter(JFormattedTextField tf) {
            return this.formatter;
        }

        public FormatterFactoryWrapper(AbstractFormatter formatter) {
            this.formatter = formatter;
        }
    }

    public static abstract class AbstractFormatter
    implements Serializable {
        private static final long serialVersionUID = -5193212041738979680L;
        private JFormattedTextField textField;

        protected Object clone() throws CloneNotSupportedException {
            throw new InternalError("not implemented");
        }

        protected Action[] getActions() {
            return this.textField.getActions();
        }

        protected DocumentFilter getDocumentFilter() {
            throw new InternalError("not implemented");
        }

        protected JFormattedTextField getFormattedTextField() {
            return this.textField;
        }

        protected NavigationFilter getNavigationFilter() {
            return this.textField.getNavigationFilter();
        }

        public void install(JFormattedTextField textField) {
            if (this.textField != null) {
                this.uninstall();
            }
            this.textField = textField;
        }

        public void uninstall() {
            this.textField = null;
        }

        protected void invalidEdit() {
            this.textField.invalidEdit();
        }

        protected void setEditValid(boolean valid) {
            this.textField.editValid = valid;
        }

        public abstract Object stringToValue(String var1) throws ParseException;

        public abstract String valueToString(Object var1) throws ParseException;
    }
}

