/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Timer;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfo;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfoModelListener;
import net.sourceforge.squirrel_sql.plugins.graph.ConstraintViewsModelListener;
import net.sourceforge.squirrel_sql.plugins.graph.TableFrameController;
import net.sourceforge.squirrel_sql.plugins.graph.TableFrameControllerListener;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModelChangeType;
import net.sourceforge.squirrel_sql.plugins.graph.TableFramesModelListener;

public class TableFramesModel {
    private Vector<TableFrameController> _openTableFrameCtrls = new Vector();
    private TableFrameControllerListener _tableFrameControllerListener;
    private ConstraintViewsModelListener _constraintViewsModelListener;
    private ArrayList<TableFramesModelListener> _listeners = new ArrayList();
    private ColumnInfoModelListener _columnInfoModelListener;
    private TableFrameController _lastRoot;
    private Timer _calcQueryRootTimer;

    public TableFramesModel() {
        this._tableFrameControllerListener = new TableFrameControllerListener(){

            @Override
            public void closed(TableFrameController tfc) {
                TableFramesModel.this.onTableFrameControllerClosed(tfc);
            }
        };
        this._constraintViewsModelListener = new ConstraintViewsModelListener(){

            @Override
            public void constraintsChanged() {
                TableFramesModel.this.fireListeners(TableFramesModelChangeType.CONSTRAINT);
            }
        };
        this._columnInfoModelListener = new ColumnInfoModelListener(){

            @Override
            public void columnInfosChanged(TableFramesModelChangeType changeType) {
                TableFramesModel.this.fireListeners(changeType);
            }
        };
        this._calcQueryRootTimer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFramesModel.this.calculateQueryRoot();
            }
        });
        this._calcQueryRootTimer.setRepeats(false);
        this._calcQueryRootTimer.stop();
    }

    public Vector<TableFrameController> getTblCtrls() {
        return this._openTableFrameCtrls;
    }

    void refreshTableNames() {
        for (TableFrameController openTableFrameCtrl : this._openTableFrameCtrls) {
            openTableFrameCtrl.refreshTableName();
        }
    }

    void allTablesDbOrder() {
        for (TableFrameController openTableFrameCtrl : this._openTableFrameCtrls) {
            openTableFrameCtrl.dbOrder();
        }
    }

    void allTablesByNameOrder() {
        for (TableFrameController openTableFrameCtrl : this._openTableFrameCtrls) {
            openTableFrameCtrl.nameOrder();
        }
    }

    void allTablesPkConstOrder() {
        for (TableFrameController openTableFrameCtrl : this._openTableFrameCtrls) {
            openTableFrameCtrl.pkConstraintOrder();
        }
    }

    void allTablesFilteredSelectedOrder() {
        for (TableFrameController openTableFrameCtrl : this._openTableFrameCtrls) {
            openTableFrameCtrl.filteredSelectedOrder();
        }
    }

    private void onTableFrameControllerClosed(TableFrameController tfc) {
        this._openTableFrameCtrls.remove(tfc);
        for (int i = 0; i < this._openTableFrameCtrls.size(); ++i) {
            TableFrameController tableFrameController = this._openTableFrameCtrls.get(i);
            tableFrameController.disconnectTableFrame(tfc);
        }
        this.fireListeners(TableFramesModelChangeType.TABLE);
        this.recalculateAllConnections();
    }

    private void fireListeners(TableFramesModelChangeType changeType) {
        TableFramesModelListener[] listeners;
        for (TableFramesModelListener listener : listeners = this._listeners.toArray(new TableFramesModelListener[this._listeners.size()])) {
            listener.modelChanged(changeType);
        }
    }

    void refreshAllTables() {
        for (int i = 0; i < this._openTableFrameCtrls.size(); ++i) {
            TableFrameController tableFrameController = this._openTableFrameCtrls.get(i);
            tableFrameController.refresh();
        }
        this.fireListeners(TableFramesModelChangeType.TABLE);
        this.recalculateAllConnections();
    }

    public boolean containsTable(TableFrameController tfc) {
        return this._openTableFrameCtrls.contains(tfc);
    }

    public boolean containsTable(String tableName) {
        for (TableFrameController openTableFrameCtrl : this._openTableFrameCtrls) {
            if (!openTableFrameCtrl.getTableInfo().getSimpleName().equalsIgnoreCase(tableName)) continue;
            return true;
        }
        return false;
    }

    public void addTable(TableFrameController tfc, boolean readingXMLBean) {
        tfc.addTableFrameControllerListener(this._tableFrameControllerListener);
        tfc.getConstraintViewsModel().addListener(this._constraintViewsModelListener);
        tfc.getColumnInfoModel().addColumnInfoModelListener(this._columnInfoModelListener);
        tfc.getFrame().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TableFramesModel.this.onTableFrameMoved();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                TableFramesModel.this.onTableFrameMoved();
            }
        });
        this._openTableFrameCtrls.add(tfc);
        this.initsAfterFrameAdded(tfc, false == readingXMLBean);
        if (!readingXMLBean) {
            this.fireListeners(TableFramesModelChangeType.TABLE);
        }
        this.recalculateAllConnections();
    }

    private void initsAfterFrameAdded(TableFrameController tfc, boolean resetBounds) {
        for (int i = 0; i < this._openTableFrameCtrls.size(); ++i) {
            TableFrameController buf = this._openTableFrameCtrls.get(i);
            if (buf.equals(tfc)) continue;
            buf.tableFrameOpen(tfc);
        }
        Vector<TableFrameController> others = new Vector<TableFrameController>(this._openTableFrameCtrls);
        others.remove(tfc);
        TableFrameController[] othersArr = others.toArray(new TableFrameController[others.size()]);
        tfc.initAfterAddedToDesktop(othersArr, resetBounds);
    }

    private void onTableFrameMoved() {
        if (0 == this._openTableFrameCtrls.size()) {
            return;
        }
        this._calcQueryRootTimer.restart();
    }

    private void calculateQueryRoot() {
        TableFrameController queryRoot = this._openTableFrameCtrls.get(0);
        for (int i = 1; i < this._openTableFrameCtrls.size(); ++i) {
            Point loc = this._openTableFrameCtrls.get(i).getFrame().getLocation();
            Point rootLoc = queryRoot.getFrame().getLocation();
            if (loc.x * loc.x + loc.y * loc.y < rootLoc.x * rootLoc.x + rootLoc.y * rootLoc.y) {
                queryRoot = this._openTableFrameCtrls.get(i);
            }
            if (this._lastRoot == queryRoot) continue;
            this._lastRoot = queryRoot;
            this.fireListeners(TableFramesModelChangeType.ROOT_TABLE);
        }
    }

    public void addTableFramesModelListener(TableFramesModelListener tableFramesModelListener) {
        this._listeners.remove(tableFramesModelListener);
        this._listeners.add(tableFramesModelListener);
    }

    public void removeTableFramesModelListener(TableFramesModelListener tableFramesModelListener) {
        this._listeners.remove(tableFramesModelListener);
    }

    public void hideNoJoins(boolean b) {
        for (TableFrameController openTableFrameCtrl : this._openTableFrameCtrls) {
            openTableFrameCtrl.getConstraintViewsModel().hideNoJoins(b);
        }
    }

    public boolean containsUniddenNoJoins() {
        for (TableFrameController openTableFrameCtrl : this._openTableFrameCtrls) {
            if (!openTableFrameCtrl.getConstraintViewsModel().containsUniddenNoJoins()) continue;
            return true;
        }
        return false;
    }

    public void recalculateAllConnections() {
        for (TableFrameController tfc : this._openTableFrameCtrls) {
            tfc.recalculateConnections();
        }
    }

    public void replaceColumnClonesInConstraintsByRefrences() {
        for (TableFrameController openTableFrameCtrl : this._openTableFrameCtrls) {
            openTableFrameCtrl.getConstraintViewsModel().replaceColumnClonesInConstraintsByRefrences(this);
        }
    }

    public ColumnInfo findColumn(String tableName, String columnName) {
        for (TableFrameController openTableFrameCtrl : this._openTableFrameCtrls) {
            if (!openTableFrameCtrl.getTableInfo().getSimpleName().equalsIgnoreCase(tableName)) continue;
            for (ColumnInfo columnInfo : openTableFrameCtrl.getColumnInfos()) {
                if (!columnInfo.getColumnName().equalsIgnoreCase(columnName)) continue;
                return columnInfo;
            }
        }
        throw new IllegalArgumentException("Column " + tableName + "." + columnName + " does not exist.");
    }
}

