/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.caffinitas.ohc.linked.Uns;

final class BufferedReadableByteChannel
implements ReadableByteChannel {
    private final ReadableByteChannel delegate;
    private final long bufferAddress;
    private ByteBuffer buffer;
    private boolean closed;

    BufferedReadableByteChannel(ReadableByteChannel delegate, int bufferSize) throws IOException {
        this.delegate = delegate;
        this.bufferAddress = Uns.allocateIOException(bufferSize);
        this.buffer = Uns.directBufferFor(this.bufferAddress, 0L, bufferSize);
        this.buffer.position(bufferSize);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int p = dst.position();
        int dr;
        while ((dr = dst.remaining()) != 0) {
            int br = this.buffer.remaining();
            if (br == 0) {
                this.buffer.clear();
                int rd = this.delegate.read(this.buffer);
                if (rd == -1) {
                    rd = dst.position() - p;
                    return rd == 0 ? -1 : rd;
                }
                this.buffer.flip();
                br = this.buffer.remaining();
            }
            if (dr >= br) {
                dst.put(this.buffer);
                continue;
            }
            int lim = this.buffer.limit();
            this.buffer.limit(this.buffer.position() + dr);
            dst.put(this.buffer);
            this.buffer.limit(lim);
        }
        return dst.position() - p;
    }

    @Override
    public boolean isOpen() {
        return this.buffer != null;
    }

    @Override
    public void close() {
        this.buffer = null;
        if (!this.closed) {
            Uns.free(this.bufferAddress);
        }
        this.closed = true;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

