/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.solr.client.solrj.cloud.autoscaling.Cell;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.ComputedType;
import org.apache.solr.client.solrj.cloud.autoscaling.Condition;
import org.apache.solr.client.solrj.cloud.autoscaling.Operand;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.RangeVal;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaCount;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.SealedClause;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggestion;
import org.apache.solr.client.solrj.cloud.autoscaling.VariableBase;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;

public interface Variable {
    public static final String NULL = "";
    public static final String coreidxsize = "INDEX.sizeInGB";

    default public boolean match(Object inputVal, Operand op, Object val, String name, Row row) {
        return op.match(val, this.validate(name, inputVal, false)) == Clause.TestStatus.PASS;
    }

    default public Object convertVal(Object val) {
        return val;
    }

    default public void projectAddReplica(Cell cell, ReplicaInfo ri, Consumer<Row.OperationInfo> opCollector, boolean strictMode) {
    }

    default public boolean addViolatingReplicas(Violation.Ctx ctx) {
        return false;
    }

    public void getSuggestions(Suggestion.Ctx var1);

    default public Object computeValue(Policy.Session session, Condition condition, String collection, String shard, String node) {
        return condition.val;
    }

    default public void computeDeviation(Policy.Session session, double[] deviations, ReplicaCount replicaCount, SealedClause sealedClause) {
        if (deviations != null) {
            Long actualCount = replicaCount.getVal(sealedClause.type);
            if (sealedClause.replica.val instanceof RangeVal) {
                Double realDelta = ((RangeVal)sealedClause.replica.val).realDelta(((Number)actualCount).doubleValue());
                realDelta = sealedClause.isReplicaZero() ? -1.0 * realDelta : realDelta;
                deviations[0] = deviations[0] + Math.abs(realDelta);
            }
        }
    }

    public int compareViolation(Violation var1, Violation var2);

    default public void projectRemoveReplica(Cell cell, ReplicaInfo ri, Consumer<Row.OperationInfo> opCollector) {
    }

    default public String postValidate(Condition condition) {
        return null;
    }

    default public Operand getOperand(Operand expected, Object strVal, ComputedType computedType) {
        return expected;
    }

    public Object validate(String var1, Object var2, boolean var3);

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Meta {
        public String name();

        public Class type();

        public String[] associatedPerNodeValue() default {""};

        public String associatedPerReplicaValue() default "";

        public String[] enumVals() default {""};

        public String[] wildCards() default {""};

        public boolean isNodeSpecificVal() default false;

        public boolean isHidden() default false;

        public boolean isAdditive() default true;

        public double min() default -1.0;

        public double max() default -1.0;

        public boolean supportArrayVals() default false;

        public String metricsKey() default "";

        public Class implementation() default void.class;

        public ComputedType[] computedValues() default {ComputedType.NULL};
    }

    public static enum Type implements Variable
    {
        WITH_COLLECTION,
        COLL,
        SHARD,
        REPLICA,
        PORT,
        IP_1,
        IP_2,
        IP_3,
        IP_4,
        FREEDISK,
        TOTALDISK,
        CORE_IDX,
        NODE_ROLE,
        CORES,
        SYSLOADAVG,
        HEAPUSAGE,
        NUMBER,
        HOST,
        SYSPROP,
        NODE,
        LAZY,
        DISKTYPE;

        public final String tagName;
        public final Class type;
        public Meta meta;
        public final Set<String> vals;
        public final Number min;
        public final Number max;
        public final Boolean additive;
        public final Set<String> wildCards;
        public final String perReplicaValue;
        public final Set<String> associatedPerNodeValues;
        public final String metricsAttribute;
        public final Set<ComputedType> supportedComputedTypes;
        final Variable impl;
        private static final Map<String, Type> typeByNameMap;

        private Type() {
            try {
                this.meta = Type.class.getField(this.name()).getAnnotation(Meta.class);
                if (this.meta == null) {
                    throw new RuntimeException("Invalid type, should have a @Meta annotation " + this.name());
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            this.impl = VariableBase.loadImpl(this.meta, this);
            this.tagName = this.meta.name();
            this.type = this.meta.type();
            this.vals = this.readSet(this.meta.enumVals());
            this.max = this.readNum(this.meta.max());
            this.min = this.readNum(this.meta.min());
            this.perReplicaValue = this.readStr(this.meta.associatedPerReplicaValue());
            this.associatedPerNodeValues = this.readSet(this.meta.associatedPerNodeValue());
            this.additive = this.meta.isAdditive();
            this.metricsAttribute = this.readStr(this.meta.metricsKey());
            this.supportedComputedTypes = this.meta.computedValues()[0] == ComputedType.NULL ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<ComputedType>(Arrays.asList(this.meta.computedValues())));
            this.wildCards = this.readSet(this.meta.wildCards());
        }

        public String getTagName() {
            return this.meta.name();
        }

        private String readStr(String s) {
            return Variable.NULL.equals(s) ? null : s;
        }

        private Number readNum(double v) {
            return v == -1.0 ? (Number)null : (Number)((Number)this.validate(null, v, true));
        }

        Set<String> readSet(String[] vals) {
            if (Variable.NULL.equals(vals[0])) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(vals)));
        }

        @Override
        public void getSuggestions(Suggestion.Ctx ctx) {
            this.impl.getSuggestions(ctx);
        }

        @Override
        public boolean addViolatingReplicas(Violation.Ctx ctx) {
            return this.impl.addViolatingReplicas(ctx);
        }

        @Override
        public Operand getOperand(Operand expected, Object val, ComputedType computedType) {
            return this.impl.getOperand(expected, val, computedType);
        }

        @Override
        public Object convertVal(Object val) {
            return this.impl.convertVal(val);
        }

        @Override
        public String postValidate(Condition condition) {
            return this.impl.postValidate(condition);
        }

        @Override
        public Object validate(String name, Object val, boolean isRuleVal) {
            return this.impl.validate(name, val, isRuleVal);
        }

        @Override
        public void projectAddReplica(Cell cell, ReplicaInfo ri, Consumer<Row.OperationInfo> opCollector, boolean strictMode) {
            this.impl.projectAddReplica(cell, ri, opCollector, strictMode);
        }

        @Override
        public void projectRemoveReplica(Cell cell, ReplicaInfo ri, Consumer<Row.OperationInfo> opCollector) {
            this.impl.projectRemoveReplica(cell, ri, opCollector);
        }

        @Override
        public int compareViolation(Violation v1, Violation v2) {
            return this.impl.compareViolation(v1, v2);
        }

        @Override
        public Object computeValue(Policy.Session session, Condition condition, String collection, String shard, String node) {
            return this.impl.computeValue(session, condition, collection, shard, node);
        }

        @Override
        public void computeDeviation(Policy.Session session, double[] deviations, ReplicaCount replicaCount, SealedClause sealedClause) {
            this.impl.computeDeviation(session, deviations, replicaCount, sealedClause);
        }

        @Override
        public boolean match(Object inputVal, Operand op, Object val, String name, Row row) {
            return this.impl.match(inputVal, op, val, name, row);
        }

        static Type get(String name) {
            return typeByNameMap.get(name);
        }

        static {
            HashMap<String, Type> m = new HashMap<String, Type>();
            for (Type t : Type.values()) {
                m.put(t.tagName, t);
            }
            typeByNameMap = Collections.unmodifiableMap(m);
        }
    }
}

