/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.apache.solr.util.TimeZoneUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrRequestInfo {
    private static final int MAX_STACK_SIZE = 10;
    private static final ThreadLocal<Deque<SolrRequestInfo>> threadLocal = ThreadLocal.withInitial(LinkedList::new);
    private int refCount = 1;
    private SolrQueryRequest req;
    private SolrQueryResponse rsp;
    private Date now;
    protected HttpServletRequest httpRequest;
    private TimeZone tz;
    private ResponseBuilder rb;
    private List<Closeable> closeHooks;
    private SolrDispatchFilter.Action action;
    private boolean useServerToken = false;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static SolrRequestInfo getRequestInfo() {
        Deque<SolrRequestInfo> stack = threadLocal.get();
        if (stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    public static void setRequestInfo(SolrRequestInfo info) {
        Deque<SolrRequestInfo> stack = threadLocal.get();
        if (info == null) {
            throw new IllegalArgumentException("SolrRequestInfo is null");
        }
        if (stack.size() > 10) {
            assert (false) : "SolrRequestInfo Stack is full";
            log.error("SolrRequestInfo Stack is full");
        }
        log.trace("{} {}", (Object)info, (Object)"setRequestInfo()");
        assert (!info.isClosed()) : "SRI is already closed (odd).";
        stack.push(info);
    }

    public static void clearRequestInfo() {
        log.trace("clearRequestInfo()");
        Deque<SolrRequestInfo> stack = threadLocal.get();
        if (stack.isEmpty()) {
            assert (false) : "clearRequestInfo called too many times";
            log.error("clearRequestInfo called too many times");
        } else {
            SolrRequestInfo info = stack.pop();
            info.close();
        }
    }

    public static void reset() {
        log.trace("reset()");
        Deque<SolrRequestInfo> stack = threadLocal.get();
        assert (stack.isEmpty()) : "SolrRequestInfo Stack should have been cleared.";
        while (!stack.isEmpty()) {
            SolrRequestInfo info = stack.pop();
            info.close();
        }
    }

    private synchronized void close() {
        log.trace("{} {}", (Object)this, (Object)"close()");
        if (--this.refCount > 0) {
            log.trace("{} {}", (Object)this, (Object)"not closing; still referenced");
            return;
        }
        if (this.closeHooks != null) {
            for (Closeable hook : this.closeHooks) {
                try {
                    hook.close();
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, (String)"Exception during close hook", (Throwable)e);
                }
            }
        }
        this.closeHooks = null;
    }

    public SolrRequestInfo(SolrQueryRequest req, SolrQueryResponse rsp) {
        this.req = req;
        this.rsp = rsp;
    }

    public SolrRequestInfo(SolrQueryRequest req, SolrQueryResponse rsp, SolrDispatchFilter.Action action) {
        this(req, rsp);
        this.setAction(action);
    }

    public SolrRequestInfo(HttpServletRequest httpReq, SolrQueryResponse rsp) {
        this.httpRequest = httpReq;
        this.rsp = rsp;
    }

    public SolrRequestInfo(HttpServletRequest httpReq, SolrQueryResponse rsp, SolrDispatchFilter.Action action) {
        this(httpReq, rsp);
        this.action = action;
    }

    public Principal getUserPrincipal() {
        if (this.req != null) {
            return this.req.getUserPrincipal();
        }
        if (this.httpRequest != null) {
            return this.httpRequest.getUserPrincipal();
        }
        return null;
    }

    public Date getNOW() {
        if (this.now != null) {
            return this.now;
        }
        long ms = 0L;
        String nowStr = this.req.getParams().get("NOW");
        ms = nowStr != null ? Long.parseLong(nowStr) : this.req.getStartTime();
        this.now = new Date(ms);
        return this.now;
    }

    public TimeZone getClientTimeZone() {
        if (this.tz == null) {
            this.tz = TimeZoneUtils.parseTimezone(this.req.getParams().get("TZ"));
        }
        return this.tz;
    }

    public SolrQueryRequest getReq() {
        return this.req;
    }

    public SolrQueryResponse getRsp() {
        return this.rsp;
    }

    public ResponseBuilder getResponseBuilder() {
        return this.rb;
    }

    public void setResponseBuilder(ResponseBuilder rb) {
        this.rb = rb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCloseHook(Closeable hook) {
        SolrRequestInfo solrRequestInfo = this;
        synchronized (solrRequestInfo) {
            if (this.isClosed()) {
                throw new IllegalStateException("Already closed!");
            }
            if (this.closeHooks == null) {
                this.closeHooks = new LinkedList<Closeable>();
            }
            this.closeHooks.add(hook);
        }
    }

    public SolrDispatchFilter.Action getAction() {
        return this.action;
    }

    public void setAction(SolrDispatchFilter.Action action) {
        this.action = action;
    }

    public boolean useServerToken() {
        return this.useServerToken;
    }

    public void setUseServerToken(boolean use) {
        this.useServerToken = use;
    }

    private synchronized boolean isClosed() {
        return this.refCount <= 0;
    }

    public static ExecutorUtil.InheritableThreadLocalProvider getInheritableThreadLocalProvider() {
        return new ExecutorUtil.InheritableThreadLocalProvider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void store(AtomicReference ctx) {
                SolrRequestInfo me = SolrRequestInfo.getRequestInfo();
                if (me != null) {
                    SolrRequestInfo solrRequestInfo = me;
                    synchronized (solrRequestInfo) {
                        me.refCount++;
                    }
                    ctx.set(me);
                }
            }

            public void set(AtomicReference ctx) {
                SolrRequestInfo me = (SolrRequestInfo)ctx.get();
                if (me != null) {
                    SolrRequestInfo.setRequestInfo(me);
                }
            }

            public void clean(AtomicReference ctx) {
                if (ctx.get() != null) {
                    SolrRequestInfo.clearRequestInfo();
                }
                SolrRequestInfo.reset();
            }
        };
    }
}

