/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.DataDerivType;
import com.thaiopensource.relaxng.impl.DatatypeValue;
import com.thaiopensource.relaxng.impl.InconsistentDataDerivType;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternMemo;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import java.util.Hashtable;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.ValidationContext;

class ValueDataDerivType
extends DataDerivType {
    private final Datatype dt;
    private PatternMemo noValue;
    private Hashtable valueTable;

    ValueDataDerivType(Datatype dt) {
        this.dt = dt;
    }

    DataDerivType copy() {
        return new ValueDataDerivType(this.dt);
    }

    PatternMemo dataDeriv(ValidatorPatternBuilder builder, Pattern p, String str, ValidationContext vc) {
        PatternMemo tem;
        Object value = this.dt.createValue(str, vc);
        if (value == null) {
            if (this.noValue == null) {
                this.noValue = super.dataDeriv(builder, p, str, vc);
            }
            return this.noValue;
        }
        DatatypeValue dtv = new DatatypeValue(value, this.dt);
        if (this.valueTable == null) {
            this.valueTable = new Hashtable();
        }
        if ((tem = (PatternMemo)this.valueTable.get(dtv)) == null) {
            tem = super.dataDeriv(builder, p, str, vc);
            this.valueTable.put(dtv, tem);
        }
        return tem;
    }

    DataDerivType combine(DataDerivType ddt) {
        if (ddt instanceof ValueDataDerivType) {
            if (((ValueDataDerivType)ddt).dt == this.dt) {
                return this;
            }
            return InconsistentDataDerivType.getInstance();
        }
        return ddt.combine(this);
    }

    Datatype getDatatype() {
        return this.dt;
    }
}

