/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.view.client;

import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.HashMap;
import java.util.Map;

public abstract class DefaultSelectionModel<T>
extends SelectionModel.AbstractSelectionModel<T> {
    private final Map<Object, Boolean> exceptions = new HashMap<Object, Boolean>();
    private final Map<Object, MultiSelectionModel.SelectionChange<T>> selectionChanges = new HashMap<Object, MultiSelectionModel.SelectionChange<T>>();

    public DefaultSelectionModel() {
        super(null);
    }

    public DefaultSelectionModel(ProvidesKey<T> keyProvider) {
        super(keyProvider);
    }

    public void clearExceptions() {
        this.exceptions.clear();
        this.selectionChanges.clear();
        this.scheduleSelectionChangeEvent();
    }

    public abstract boolean isDefaultSelected(T var1);

    @Override
    public boolean isSelected(T item) {
        this.resolveChanges();
        Object key = this.getKey(item);
        Boolean exception = this.exceptions.get(key);
        if (exception != null) {
            return exception;
        }
        return this.isDefaultSelected(item);
    }

    @Override
    public void setSelected(T item, boolean selected) {
        this.selectionChanges.put(this.getKey(item), new MultiSelectionModel.SelectionChange<T>(item, selected));
        this.scheduleSelectionChangeEvent();
    }

    @Override
    protected void fireSelectionChangeEvent() {
        if (this.isEventScheduled()) {
            this.setEventCancelled(true);
        }
        this.resolveChanges();
    }

    protected Map<Object, Boolean> getExceptions(Map<Object, Boolean> output) {
        output.clear();
        output.putAll(this.exceptions);
        return output;
    }

    private void resolveChanges() {
        boolean changed = false;
        for (Map.Entry<Object, MultiSelectionModel.SelectionChange<T>> entry : this.selectionChanges.entrySet()) {
            Object key = entry.getKey();
            MultiSelectionModel.SelectionChange<T> value = entry.getValue();
            T item = value.getItem();
            boolean selected = value.isSelected();
            boolean defaultSelected = this.isDefaultSelected(item);
            Boolean previousException = this.exceptions.get(key);
            if (defaultSelected == selected) {
                if (previousException == null) continue;
                this.exceptions.remove(key);
                changed = true;
                continue;
            }
            if (previousException == Boolean.valueOf(selected)) continue;
            this.exceptions.put(key, selected);
            changed = true;
        }
        this.selectionChanges.clear();
        if (changed) {
            SelectionChangeEvent.fire(this);
        }
    }
}

