/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.Event;
import org.jitsi.nlj.EventHandler;
import org.jitsi.nlj.PacketHandler;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.Stoppable;
import org.jitsi.nlj.transform.NodeStatsProducer;
import org.jitsi.nlj.transform.NodeVisitor;
import org.jitsi.nlj.transform.node.NodePlugin;
import org.jitsi.nlj.transform.node.debug.PayloadVerificationPlugin;
import org.jitsi.utils.OrderedJsonObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 32\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u00013B\u0011\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000H\u0016J\b\u0010\u001f\u001a\u00020\u001aH\u0016J\u000e\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0000J\u000e\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u0000J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00000%H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00000%H\u0016J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u001aH\u0016J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020-H\u0004J\u0016\u0010+\u001a\u00020\u001a2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020-0/H\u0004J\u0016\u00100\u001a\u00020\u001a2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001a02H&R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\bR\u0010\u0010\f\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0014\u0010\u0015\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\n\u0082\u0001\u00014\u00a8\u00065"}, d2={"Lorg/jitsi/nlj/transform/node/Node;", "Lorg/jitsi/nlj/PacketHandler;", "Lorg/jitsi/nlj/EventHandler;", "Lorg/jitsi/nlj/transform/NodeStatsProducer;", "Lorg/jitsi/nlj/Stoppable;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "setName", "nextNode", "inputNodes", "", "getInputNodes", "()Ljava/util/List;", "inputNodes$delegate", "Lkotlin/Lazy;", "nodeEntryString", "getNodeEntryString", "nodeExitString", "getNodeExitString", "statsJson", "Lorg/jitsi/utils/OrderedJsonObject;", "visit", "", "visitor", "Lorg/jitsi/nlj/transform/NodeVisitor;", "attach", "node", "detachNext", "addParent", "newParent", "removeParent", "parent", "getChildren", "", "getParents", "handleEvent", "event", "Lorg/jitsi/nlj/Event;", "stop", "next", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "packetInfos", "", "trace", "f", "Lkotlin/Function0;", "Companion", "Lorg/jitsi/nlj/transform/node/StatsKeepingNode;", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Node.kt\norg/jitsi/nlj/transform/node/Node\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,583:1\n1863#2,2:584\n1863#2:586\n1863#2,2:587\n1864#2:589\n*S KotlinDebug\n*F\n+ 1 Node.kt\norg/jitsi/nlj/transform/node/Node\n*L\n108#1:584,2\n114#1:586\n116#1:587,2\n114#1:589\n*E\n"})
public abstract class Node
implements PacketHandler,
EventHandler,
NodeStatsProducer,
Stoppable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String name;
    @Nullable
    private Node nextNode;
    @NotNull
    private final Lazy inputNodes$delegate;
    @NotNull
    private final String nodeEntryString;
    @NotNull
    private final String nodeExitString;
    private static boolean TRACE_ENABLED;
    private static boolean PLUGINS_ENABLED;
    @NotNull
    private static final Set<NodePlugin> plugins;

    private Node(String name) {
        this.name = name;
        this.inputNodes$delegate = LazyKt.lazy(Node::inputNodes_delegate$lambda$0);
        this.nodeEntryString = "Entered node " + this.name;
        this.nodeExitString = "Exited node " + this.name;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.name = string;
    }

    private final List<Node> getInputNodes() {
        Lazy lazy = this.inputNodes$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    protected final String getNodeEntryString() {
        return this.nodeEntryString;
    }

    @NotNull
    protected final String getNodeExitString() {
        return this.nodeExitString;
    }

    @NotNull
    public OrderedJsonObject statsJson() {
        return new OrderedJsonObject();
    }

    public void visit(@NotNull NodeVisitor visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        visitor2.visit(this);
    }

    @NotNull
    public Node attach(@NotNull Node node2) {
        Intrinsics.checkNotNullParameter(node2, "node");
        if (this.nextNode != null) {
            throw new Exception("Attempt to replace a Node's child. If this is intentional, use detachNext first.");
        }
        this.nextNode = node2;
        node2.addParent(this);
        return node2;
    }

    public void detachNext() {
        Node node2 = this.nextNode;
        if (node2 != null) {
            node2.removeParent(this);
        }
        this.nextNode = null;
    }

    public final void addParent(@NotNull Node newParent) {
        Intrinsics.checkNotNullParameter(newParent, "newParent");
        this.getInputNodes().add(newParent);
    }

    public final void removeParent(@NotNull Node parent) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        this.getInputNodes().remove(parent);
    }

    @NotNull
    public Collection<Node> getChildren() {
        Node node2 = this.nextNode;
        if (node2 == null) {
            return CollectionsKt.emptyList();
        }
        Node actualNextNode = node2;
        return CollectionsKt.listOf(actualNextNode);
    }

    @NotNull
    public Collection<Node> getParents() {
        return this.getInputNodes();
    }

    @Override
    public void handleEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, "event");
    }

    @Override
    public void stop() {
    }

    protected final void next(@NotNull PacketInfo packetInfo) {
        block2: {
            Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
            if (PLUGINS_ENABLED) {
                Iterable $this$forEach$iv = plugins;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    NodePlugin it = (NodePlugin)element$iv;
                    boolean bl = false;
                    it.observe(this, packetInfo);
                }
            }
            Node node2 = this.nextNode;
            if (node2 == null) break block2;
            node2.processPacket(packetInfo);
        }
    }

    protected final void next(@NotNull List<? extends PacketInfo> packetInfos) {
        Intrinsics.checkNotNullParameter(packetInfos, "packetInfos");
        Iterable $this$forEach$iv = packetInfos;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PacketInfo packetInfo = (PacketInfo)element$iv;
            boolean bl = false;
            if (PLUGINS_ENABLED) {
                Iterable $this$forEach$iv2 = plugins;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    NodePlugin it = (NodePlugin)element$iv2;
                    boolean bl2 = false;
                    it.observe(this, packetInfo);
                }
            }
            Node node2 = this.nextNode;
            if (node2 == null) continue;
            node2.processPacket(packetInfo);
        }
    }

    public abstract void trace(@NotNull Function0<Unit> var1);

    private static final List inputNodes_delegate$lambda$0() {
        return new ArrayList();
    }

    public /* synthetic */ Node(String name, DefaultConstructorMarker $constructor_marker) {
        this(name);
    }

    static {
        plugins = new LinkedHashSet();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\u0005R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/jitsi/nlj/transform/node/Node$Companion;", "", "<init>", "()V", "TRACE_ENABLED", "", "getTRACE_ENABLED", "()Z", "setTRACE_ENABLED", "(Z)V", "PLUGINS_ENABLED", "getPLUGINS_ENABLED", "setPLUGINS_ENABLED", "plugins", "", "Lorg/jitsi/nlj/transform/node/NodePlugin;", "getPlugins", "()Ljava/util/Set;", "enablePayloadVerification", "", "enable", "isPayloadVerificationEnabled", "enableNodeTracing", "isNodeTracingEnabled", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getTRACE_ENABLED() {
            return TRACE_ENABLED;
        }

        public final void setTRACE_ENABLED(boolean bl) {
            TRACE_ENABLED = bl;
        }

        public final boolean getPLUGINS_ENABLED() {
            return PLUGINS_ENABLED;
        }

        public final void setPLUGINS_ENABLED(boolean bl) {
            PLUGINS_ENABLED = bl;
        }

        @NotNull
        public final Set<NodePlugin> getPlugins() {
            return plugins;
        }

        public final void enablePayloadVerification(boolean enable) {
            if (enable) {
                this.setPLUGINS_ENABLED(true);
                this.getPlugins().add(PayloadVerificationPlugin.Companion);
                PacketInfo.Companion.setEnablePayloadVerification(true);
            } else {
                this.getPlugins().remove(PayloadVerificationPlugin.Companion);
                this.setPLUGINS_ENABLED(!((Collection)this.getPlugins()).isEmpty());
                PacketInfo.Companion.setEnablePayloadVerification(false);
            }
        }

        public final boolean isPayloadVerificationEnabled() {
            return PacketInfo.Companion.getEnablePayloadVerification();
        }

        public final void enableNodeTracing(boolean enable) {
            this.setTRACE_ENABLED(enable);
        }

        public final boolean isNodeTracingEnabled() {
            return this.getTRACE_ENABLED();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

