/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.ccfb;

import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.TransportLayerRtcpFbPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.ccfb.PacketInfo;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.ccfb.ReceivedPacketInfo;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.ccfb.RtcpFbCcfbPacketKt;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.ccfb.UnreceivedPacketInfo;
import org.jitsi.rtp.util.FieldParsersKt;
import org.jitsi.rtp.util.RtpUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0002\u0019\u001aB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0018\u001a\u00020\u0000H\u0016R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/ccfb/RtcpFbCcfbPacket;", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/TransportLayerRtcpFbPacket;", "buffer", "", "offset", "", "length", "<init>", "([BII)V", "data", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/ccfb/RtcpFbCcfbPacket$CcfbData;", "getData", "()Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/ccfb/RtcpFbCcfbPacket$CcfbData;", "data$delegate", "Lkotlin/Lazy;", "packets", "", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/ccfb/PacketInfo;", "getPackets", "()Ljava/util/List;", "reportTimestampCompactNtp", "", "getReportTimestampCompactNtp", "()J", "clone", "CcfbData", "Companion", "rtp"})
public final class RtcpFbCcfbPacket
extends TransportLayerRtcpFbPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy data$delegate;
    public static final int FMT = 11;

    public RtcpFbCcfbPacket(@NotNull byte[] buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        super(buffer, offset, length);
        this.data$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> RtcpFbCcfbPacket.data_delegate$lambda$3(this, buffer, offset));
    }

    private final CcfbData getData() {
        Lazy lazy = this.data$delegate;
        return (CcfbData)lazy.getValue();
    }

    @NotNull
    public final List<PacketInfo> getPackets() {
        return this.getData().getPackets();
    }

    public final long getReportTimestampCompactNtp() {
        return this.getData().getReportTimestampCompactNtp();
    }

    @Override
    @NotNull
    public RtcpFbCcfbPacket clone() {
        return new RtcpFbCcfbPacket(this.cloneBuffer(0), 0, this.length);
    }

    private static final CcfbData data_delegate$lambda$3(RtcpFbCcfbPacket this$0, byte[] $buffer, int $offset) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($buffer, "$buffer");
        List packets = new ArrayList();
        if (!(this$0.getPacketLength() - 12 >= 4)) {
            boolean bl = false;
            String string = "CCFB packet is too small for timestamp";
            throw new IllegalArgumentException(string.toString());
        }
        long reportTimestampCompactNtp = FieldParsersKt.getIntAsLong($buffer, this$0.getPacketLength() - 4);
        int position = $offset + 12;
        int end = $offset + this$0.getPacketLength() - 4;
        while (position + 8 < end) {
            int numReports;
            long ssrc = FieldParsersKt.getIntAsLong($buffer, position);
            int baseSeqno = FieldParsersKt.getShortAsInt($buffer, position += 4);
            position += 2;
            if (!((position += 2) + 2 * (numReports = FieldParsersKt.getShortAsInt($buffer, position)) <= end)) {
                boolean $i$a$-require-RtcpFbCcfbPacket$data$2$42 = false;
                String $i$a$-require-RtcpFbCcfbPacket$data$2$42 = "Reports would extend past end of CCFB packet";
                throw new IllegalArgumentException($i$a$-require-RtcpFbCcfbPacket$data$2$42.toString());
            }
            for (int i = 0; i < numReports; ++i) {
                int packetInfo = FieldParsersKt.getShortAsInt($buffer, position);
                position += 2;
                int seqNo = RtpUtils.Companion.applySequenceNumberDelta(baseSeqno, i);
                boolean received = (packetInfo & 0x8000) != 0;
                packets.add(received ? (PacketInfo)new ReceivedPacketInfo(ssrc, seqNo, RtcpFbCcfbPacketKt.access$atoToTimeDelta(packetInfo), RtcpFbCcfbPacketKt.access$toEcnMarking(packetInfo)) : (PacketInfo)new UnreceivedPacketInfo(ssrc, seqNo));
            }
            if (numReports % 2 == 0) continue;
            position += 2;
        }
        if (!(position == end)) {
            boolean bl = false;
            String string = "CCFB packet size was incorrect";
            throw new IllegalArgumentException(string.toString());
        }
        return new CcfbData(packets, reportTimestampCompactNtp);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/ccfb/RtcpFbCcfbPacket$CcfbData;", "", "packets", "", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/ccfb/PacketInfo;", "reportTimestampCompactNtp", "", "<init>", "(Ljava/util/List;J)V", "getPackets", "()Ljava/util/List;", "getReportTimestampCompactNtp", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "rtp"})
    private static final class CcfbData {
        @NotNull
        private final List<PacketInfo> packets;
        private final long reportTimestampCompactNtp;

        public CcfbData(@NotNull List<? extends PacketInfo> packets, long reportTimestampCompactNtp) {
            Intrinsics.checkNotNullParameter(packets, "packets");
            this.packets = packets;
            this.reportTimestampCompactNtp = reportTimestampCompactNtp;
        }

        @NotNull
        public final List<PacketInfo> getPackets() {
            return this.packets;
        }

        public final long getReportTimestampCompactNtp() {
            return this.reportTimestampCompactNtp;
        }

        @NotNull
        public final List<PacketInfo> component1() {
            return this.packets;
        }

        public final long component2() {
            return this.reportTimestampCompactNtp;
        }

        @NotNull
        public final CcfbData copy(@NotNull List<? extends PacketInfo> packets, long reportTimestampCompactNtp) {
            Intrinsics.checkNotNullParameter(packets, "packets");
            return new CcfbData(packets, reportTimestampCompactNtp);
        }

        public static /* synthetic */ CcfbData copy$default(CcfbData ccfbData, List list, long l, int n, Object object) {
            if ((n & 1) != 0) {
                list = ccfbData.packets;
            }
            if ((n & 2) != 0) {
                l = ccfbData.reportTimestampCompactNtp;
            }
            return ccfbData.copy(list, l);
        }

        @NotNull
        public String toString() {
            return "CcfbData(packets=" + this.packets + ", reportTimestampCompactNtp=" + this.reportTimestampCompactNtp + ")";
        }

        public int hashCode() {
            int result = ((Object)this.packets).hashCode();
            result = result * 31 + Long.hashCode(this.reportTimestampCompactNtp);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CcfbData)) {
                return false;
            }
            CcfbData ccfbData = (CcfbData)other;
            if (!Intrinsics.areEqual(this.packets, ccfbData.packets)) {
                return false;
            }
            return this.reportTimestampCompactNtp == ccfbData.reportTimestampCompactNtp;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/ccfb/RtcpFbCcfbPacket$Companion;", "", "<init>", "()V", "FMT", "", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

