/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.Properties;
import kafka.api.LeaderAndIsr$;
import kafka.common.TopicAndPartition;
import kafka.controller.ControllerState;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001B\u0001\u0003\u0001\u001d\u0011\u0011dQ8oiJ|G\u000e\\3s\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u00111\u0001B\u0001\u000bG>tGO]8mY\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t!A_6\n\u00055Q!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001a\u0001\n\u0003)\u0012aB:feZ,'o]\u000b\u0002-A\u0019q\u0003\b\u0010\u000e\u0003aQ!!\u0007\u000e\u0002\u0015\r|G\u000e\\3di&|gNC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\u0002DA\u0002TKF\u0004\"a\b\u0012\u000e\u0003\u0001R!!\t\u0003\u0002\rM,'O^3s\u0013\t\u0019\u0003EA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bbB\u0013\u0001\u0001\u0004%\tAJ\u0001\fg\u0016\u0014h/\u001a:t?\u0012*\u0017\u000f\u0006\u0002(WA\u0011\u0001&K\u0007\u00025%\u0011!F\u0007\u0002\u0005+:LG\u000fC\u0004-I\u0005\u0005\t\u0019\u0001\f\u0002\u0007a$\u0013\u0007\u0003\u0004/\u0001\u0001\u0006KAF\u0001\tg\u0016\u0014h/\u001a:tA!)\u0001\u0007\u0001C!c\u0005)1/\u001a;VaR\tq\u0005\u000b\u00020gA\u0011A'O\u0007\u0002k)\u0011agN\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002q\u0005\u0019qN]4\n\u0005i*$A\u0002\"fM>\u0014X\rC\u0003=\u0001\u0011\u0005\u0013'\u0001\u0005uK\u0006\u0014Hi\\<oQ\tYd\b\u0005\u00025\u007f%\u0011\u0001)\u000e\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0006\u0005\u0002!\t!M\u0001\u0011i\u0016\u001cH/R7qif\u001cE.^:uKJD#!\u0011#\u0011\u0005Q*\u0015B\u0001$6\u0005\u0011!Vm\u001d;\t\u000b!\u0003A\u0011A\u0019\u0002[Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195QKJ\u001c\u0018n\u001d;t/\",g.\u00117m\u0005J|7.\u001a:t\t><h\u000e\u000b\u0002H\t\")1\n\u0001C\u0001c\u0005YC/Z:u\u0007>tGO]8mY\u0016\u0014Xj\u001c<f\u0013:\u001c'/Z7f]R\u001c8i\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000e\u000b\u0002K\t\")a\n\u0001C\u0001c\u0005\tB/Z:u)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8)\u00055#\u0005\"B)\u0001\t\u0003\t\u0014a\t;fgR$v\u000e]5d\u0007J,\u0017\r^5p]^KG\u000f[(gM2Lg.\u001a*fa2L7-\u0019\u0015\u0003!\u0012CQ\u0001\u0016\u0001\u0005\u0002E\n1\u0004^3tiR{\u0007/[2QCJ$\u0018\u000e^5p]\u0016C\b/\u00198tS>t\u0007FA*E\u0011\u00159\u0006\u0001\"\u00012\u00035\"Xm\u001d;U_BL7\rU1si&$\u0018n\u001c8FqB\fgn]5p]^KG\u000f[(gM2Lg.\u001a*fa2L7-\u0019\u0015\u0003-\u0012CQA\u0017\u0001\u0005\u0002E\n\u0011\u0004^3tiB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oi\"\u0012\u0011\f\u0012\u0005\u0006;\u0002!\t!M\u0001;i\u0016\u001cH\u000fU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o[\u0016tGoV5uQ>3g\r\\5oKJ+\u0007\u000f\\5dC\"\u000bG\u000e^5oOB\u0013xn\u001a:fgND#\u0001\u0018#\t\u000b\u0001\u0004A\u0011A\u0019\u0002oQ,7\u000f\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e*fgVlWm]!gi\u0016\u0014(+\u001a9mS\u000e\f7i\\7fg>sG.\u001b8fQ\tyF\tC\u0003d\u0001\u0011\u0005\u0011'\u0001\u0012uKN$\bK]3gKJ\u0014X\r\u001a*fa2L7-\u0019'fC\u0012,'/\u00127fGRLwN\u001c\u0015\u0003E\u0012CQA\u001a\u0001\u0005\u0002E\nQ\u0006^3ti\n\u000b7m\u001b+p\u0005\u0006\u001c7\u000e\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1MK\u0006$WM]#mK\u000e$\u0018n\u001c8tQ\t)G\tC\u0003j\u0001\u0011\u0005\u0011'A\u001fuKN$\bK]3gKJ\u0014X\r\u001a*fa2L7-\u0019'fC\u0012,'/\u00127fGRLwN\\,ji\"|eM\u001a7j]\u0016\u0004&/\u001a4feJ,GMU3qY&\u001c\u0017\r\u000b\u0002i\t\")A\u000e\u0001C\u0001c\u00051C/Z:u\u0003V$x\u000e\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1MK\u0006$WM]#mK\u000e$\u0018n\u001c8)\u0005-$\u0005\"B8\u0001\t\u0003\t\u0014\u0001\u0012;fgRdU-\u00193fe\u0006sG-S:s/\",g.\u00128uSJ,\u0017j\u001d:PM\u001ad\u0017N\\3B]\u0012,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:$\u0015n]1cY\u0016$\u0007F\u00018E\u0011\u0015\u0011\b\u0001\"\u00012\u0003\r#Xm\u001d;MK\u0006$WM]!oI&\u001b(o\u00165f]\u0016sG/\u001b:f\u0013N\u0014xJ\u001a4mS:,\u0017I\u001c3V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8F]\u0006\u0014G.\u001a3)\u0005E$\u0005\"B;\u0001\t\u00131\u0018A\b9sK\u001a,'O]3e%\u0016\u0004H.[2b\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o)!9s\u000f @\u0002\u000e\u0005\u001d\u0002\"\u0002=u\u0001\u0004I\u0018\u0001D2p]R\u0014x\u000e\u001c7fe&#\u0007C\u0001\u0015{\u0013\tY(DA\u0002J]RDQ! ;A\u0002y\t1b\u001c;iKJ\u0014%o\\6fe\"1q\u0010\u001ea\u0001\u0003\u0003\t!\u0001\u001e9\u0011\t\u0005\r\u0011\u0011B\u0007\u0003\u0003\u000bQ1!a\u0002\u0005\u0003\u0019\u0019w.\\7p]&!\u00111BA\u0003\u0005E!v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003\u001f!\b\u0019AA\t\u0003!\u0011X\r\u001d7jG\u0006\u001c\b#BA\n\u0003CIh\u0002BA\u000b\u0003;\u00012!a\u0006\u001b\u001b\t\tIBC\u0002\u0002\u001c\u0019\ta\u0001\u0010:p_Rt\u0014bAA\u00105\u00051\u0001K]3eK\u001aLA!a\t\u0002&\t\u00191+\u001a;\u000b\u0007\u0005}!\u0004\u0003\u0004\u0002*Q\u0004\r!_\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007\u000eC\u0004\u0002.\u0001!I!a\f\u00021]\f\u0017\u000e^+oi&d7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eF\u0003(\u0003c\t)\u0004C\u0004\u00024\u0005-\u0002\u0019A=\u0002\u000b\u0015\u0004xn\u00195\t\u0011\u0005]\u00121\u0006a\u0001\u0003s\tq!\\3tg\u0006<W\r\u0005\u0003\u0002\u0014\u0005m\u0012\u0002BA\u001f\u0003K\u0011aa\u0015;sS:<\u0007bBA!\u0001\u0011%\u00111I\u0001\u0016o\u0006LGOR8s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f)-9\u0013QIA$\u0003\u0017\ny%!\u0015\t\u000f}\fy\u00041\u0001\u0002\u0002!9\u0011\u0011JA \u0001\u0004I\u0018aD2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\t\u000f\u00055\u0013q\ba\u0001s\u00061A.Z1eKJDq!!\u000b\u0002@\u0001\u0007\u0011\u0010\u0003\u0005\u00028\u0005}\u0002\u0019AA\u001d\u0011\u001d\t)\u0006\u0001C\u0005\u0003/\n\u0001$[:FqB,7\r^3e!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f))\tI&a\u0018\u0002j\u0005-\u0014Q\u000e\t\u0004Q\u0005m\u0013bAA/5\t9!i\\8mK\u0006t\u0007\u0002CA1\u0003'\u0002\r!a\u0019\u000271,\u0017\rZ3s\u0013N\u0014\u0018I\u001c3D_:$(o\u001c7mKJ,\u0005o\\2i!\r\u0011\u0012QM\u0005\u0004\u0003O\u0012!a\u0007'fC\u0012,'/S:s\u0003:$7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eC\u0004\u0002J\u0005M\u0003\u0019A=\t\u000f\u00055\u00131\u000ba\u0001s\"9\u0011\u0011FA*\u0001\u0004I\bbBA9\u0001\u0011%\u00111O\u0001\f[\u0006\\WmU3sm\u0016\u00148\u000fF\u0004\u0017\u0003k\nI(! \t\u000f\u0005]\u0014q\u000ea\u0001s\u0006Qa.^7D_:4\u0017nZ:\t\u0015\u0005m\u0014q\u000eI\u0001\u0002\u0004\tI&A\rbkR|G*Z1eKJ\u0014VMY1mC:\u001cW-\u00128bE2,\u0007BCA@\u0003_\u0002\n\u00111\u0001\u0002Z\u0005YRO\\2mK\u0006tG*Z1eKJ,E.Z2uS>tWI\\1cY\u0016Dq!a!\u0001\t\u0013\t))A\u0003uS6,'\u000f\u0006\u0003\u0002\b\u0006}\u0005\u0003BAE\u00037k!!a#\u000b\t\u00055\u0015qR\u0001\u0005G>\u0014XM\u0003\u0003\u0002\u0012\u0006M\u0015aB7fiJL7m\u001d\u0006\u0005\u0003+\u000b9*\u0001\u0004zC6lWM\u001d\u0006\u0003\u00033\u000b1aY8n\u0013\u0011\ti*a#\u0003\u000bQKW.\u001a:\t\u0011\u0005\u0005\u0016\u0011\u0011a\u0001\u0003s\t!\"\\3ue&\u001cg*Y7f\u0011%\t)\u000bAI\u0001\n\u0013\t9+A\u000bnC.,7+\u001a:wKJ\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005%&\u0006BA-\u0003W[#!!,\u0011\t\u0005=\u0016\u0011X\u0007\u0003\u0003cSA!a-\u00026\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003oS\u0012AC1o]>$\u0018\r^5p]&!\u00111XAY\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u007f\u0003\u0011\u0013!C\u0005\u0003O\u000bQ#\\1lKN+'O^3sg\u0012\"WMZ1vYR$3\u0007")
public class ControllerIntegrationTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.empty();

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.empty()));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testEmptyCluster() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkUtils().pathExists(ZkUtils$.MODULE$.ControllerPath()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to elect a controller", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitUntilControllerEpoch(KafkaController$.MODULE$.InitialControllerEpoch(), "broker failed to set controller epoch");
    }

    @Test
    public void testControllerEpochPersistsWhenAllBrokersDown() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkUtils().pathExists(ZkUtils$.MODULE$.ControllerPath()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to elect a controller", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitUntilControllerEpoch(KafkaController$.MODULE$.InitialControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkUtils().pathExists(ZkUtils$.MODULE$.ControllerPath()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to kill controller", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitUntilControllerEpoch(KafkaController$.MODULE$.InitialControllerEpoch(), "controller epoch was not persisted after broker failure");
    }

    @Test
    public void testControllerMoveIncrementsControllerEpoch() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkUtils().pathExists(ZkUtils$.MODULE$.ControllerPath()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to elect a controller", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitUntilControllerEpoch(KafkaController$.MODULE$.InitialControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        ((KafkaServer)this.servers().head()).startup();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkUtils().pathExists(ZkUtils$.MODULE$.ControllerPath()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to elect a controller", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitUntilControllerEpoch(KafkaController$.MODULE$.InitialControllerEpoch() + 1, "controller epoch was not incremented after controller move");
    }

    @Test
    public void testTopicCreation() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    @Test
    public void testTopicCreationWithOfflineReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testTopicCreationWithOfflineReplica$1(x$1)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 != controllerId)).head());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, (Seq<KafkaServer>)((Seq)this.servers().take(1)));
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    @Test
    public void testTopicPartitionExpansion() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3()));
        TopicAndPartition tp0 = new TopicAndPartition("t", 0);
        TopicAndPartition tp1 = new TopicAndPartition("t", 1);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        scala.collection.immutable.Map expandedAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp1.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ZkUtils qual$1 = this.zkUtils();
        String x$23 = ZkUtils$.MODULE$.getTopicPath(tp0.topic());
        String x$24 = this.zkUtils().replicaAssignmentZkData((Map)expandedAssignment.map((Function1 & Serializable & scala.Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp())).toString()), kv._2()), Map$.MODULE$.canBuildFrom()));
        java.util.List x$25 = qual$1.updatePersistentPath$default$3();
        qual$1.updatePersistentPath(x$23, x$24, x$25);
        this.waitForPartitionState(tp1, KafkaController$.MODULE$.InitialControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), tp1.topic(), tp1.partition(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
    }

    @Test
    public void testTopicPartitionExpansionWithOfflineReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testTopicPartitionExpansionWithOfflineReplica$1(x$3)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 != controllerId)).head());
        TopicAndPartition tp0 = new TopicAndPartition("t", 0);
        TopicAndPartition tp1 = new TopicAndPartition("t", 1);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        scala.collection.immutable.Map expandedAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp1.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        ZkUtils qual$2 = this.zkUtils();
        String x$26 = ZkUtils$.MODULE$.getTopicPath(tp0.topic());
        String x$27 = this.zkUtils().replicaAssignmentZkData((Map)expandedAssignment.map((Function1 & Serializable & scala.Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp())).toString()), kv._2()), Map$.MODULE$.canBuildFrom()));
        java.util.List x$28 = qual$2.updatePersistentPath$default$3();
        qual$2.updatePersistentPath(x$26, x$27, x$28);
        this.waitForPartitionState(tp1, KafkaController$.MODULE$.InitialControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{(KafkaServer)this.servers().apply(controllerId)}))), tp1.topic(), tp1.partition(), TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
    }

    @Test
    public void testPartitionReassignment() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        String metricName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"kafka.controller:type=ControllerStats,name=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ControllerState.PartitionReassignment$.MODULE$.rateAndTimeMetricName().get()}));
        long timerCount = this.timer(metricName).count();
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignment$1(x$5)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> x$6 != controllerId)).head());
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ZkUtils qual$3 = this.zkUtils();
        String x$29 = ZkUtils$.MODULE$.ReassignPartitionsPath();
        String x$30 = ZkUtils$.MODULE$.formatAsReassignmentJson((Map)reassignment);
        java.util.List x$31 = qual$3.createPersistentPath$default$3();
        qual$3.createPersistentPath(x$29, x$30, x$31);
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 3, "failed to get expected partition state after partition reassignment");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.mutable.Map map = this.zkUtils().getReplicaAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()})));
            scala.collection.immutable.Map map2 = reassignment;
            return !(map != null ? !map.equals(map2) : map2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to get updated partition assignment on topic znode after partition reassignment", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkUtils().pathExists(ZkUtils$.MODULE$.ReassignPartitionsPath()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to remove reassign partitions path after completion", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        long updatedTimerCount = this.timer(metricName).count();
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timer count ", " should be greater than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)updatedTimerCount), BoxesRunTime.boxToLong((long)timerCount)})), (updatedTimerCount > timerCount ? 1 : 0) != 0);
    }

    @Test
    public void testPartitionReassignmentWithOfflineReplicaHaltingProgress() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$1(x$7)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> x$8 != controllerId)).head());
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        ZkUtils qual$4 = this.zkUtils();
        String x$32 = ZkUtils$.MODULE$.ReassignPartitionsPath();
        String x$33 = ZkUtils$.MODULE$.formatAsReassignmentJson((Map)reassignment);
        java.util.List x$34 = qual$4.createPersistentPath$default$3();
        qual$4.createPersistentPath(x$32, x$33, x$34);
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkUtils().pathExists(ZkUtils$.MODULE$.ReassignPartitionsPath()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "partition reassignment path should remain while reassignment in progress", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testPartitionReassignmentResumesAfterReplicaComesOnline() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$1(x$9)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$10 -> x$10 != controllerId)).head());
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        scala.collection.immutable.Map reassignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        ZkUtils qual$5 = this.zkUtils();
        String x$35 = ZkUtils$.MODULE$.ReassignPartitionsPath();
        String x$36 = ZkUtils$.MODULE$.formatAsReassignmentJson((Map)reassignment);
        java.util.List x$37 = qual$5.createPersistentPath$default$3();
        qual$5.createPersistentPath(x$35, x$36, x$37);
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 4, "failed to get expected partition state after partition reassignment");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.mutable.Map map = this.zkUtils().getReplicaAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()})));
            scala.collection.immutable.Map map2 = reassignment;
            return !(map != null ? !map.equals(map2) : map2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to get updated partition assignment on topic znode after partition reassignment", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkUtils().pathExists(ZkUtils$.MODULE$.ReassignPartitionsPath()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to remove reassign partitions path after completion", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testPreferredReplicaLeaderElection() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElection$1(controllerId, x$11))).get();
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
    }

    @Test
    public void testBackToBackPreferredReplicaLeaderElections() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testBackToBackPreferredReplicaLeaderElections$1(controllerId, x$12))).get();
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2);
    }

    @Test
    public void testPreferredReplicaLeaderElectionWithOfflinePreferredReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$1(x$13)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$14 -> x$14 != controllerId)).head());
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        ZkUtils qual$6 = this.zkUtils();
        String x$38 = ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath();
        String x$39 = ZkUtils$.MODULE$.preferredReplicaLeaderElectionZkData((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{tp})));
        java.util.List x$40 = qual$6.createPersistentPath$default$3();
        qual$6.createPersistentPath(x$38, x$39, x$40);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkUtils().pathExists(ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to remove preferred replica leader election path after giving up", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
    }

    @Test
    public void testAutoPreferredReplicaLeaderElection() {
        this.servers_$eq(this.makeServers(2, true, this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testAutoPreferredReplicaLeaderElection$1(x$15)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$16 -> x$16 != controllerId)).head());
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2, "failed to get expected partition state upon broker startup");
    }

    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$1(x$17)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$18 -> x$18 != controllerId)).head());
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.mutable.Map leaderIsrAndControllerEpochMap = this.zkUtils().getPartitionLeaderAndIsrForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{tp})));
            if (!leaderIsrAndControllerEpochMap.contains((Object)tp)) return false;
            if (!this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp), KafkaController$.MODULE$.InitialControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) return false;
            List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp)).leaderAndIsr().isr();
            List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId}));
            if (list != null) {
                if (!list.equals(list2)) return false;
                return true;
            }
            if (list2 == null) return true;
            return false;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to get expected partition state after entire isr went offline", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled() {
        int x$41 = 2;
        boolean x$42 = true;
        boolean x$43 = this.makeServers$default$2();
        this.servers_$eq(this.makeServers(x$41, x$43, x$42));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$1(x$19)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$20 -> x$20 != controllerId)).head());
        TopicAndPartition tp = new TopicAndPartition("t", 0);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(1)).shutdown();
        ((KafkaServer)this.servers().apply(1)).awaitShutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.mutable.Map leaderIsrAndControllerEpochMap = this.zkUtils().getPartitionLeaderAndIsrForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{tp})));
            if (!leaderIsrAndControllerEpochMap.contains((Object)tp)) return false;
            if (!this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp), KafkaController$.MODULE$.InitialControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) return false;
            List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp)).leaderAndIsr().isr();
            List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId}));
            if (list != null) {
                if (!list.equals(list2)) return false;
                return true;
            }
            if (list2 == null) return true;
            return false;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to get expected partition state after entire isr went offline", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private void preferredReplicaLeaderElection(int controllerId, KafkaServer otherBroker, TopicAndPartition tp, scala.collection.immutable.Set<Object> replicas, int leaderEpoch) {
        otherBroker.shutdown();
        otherBroker.awaitShutdown();
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), controllerId, leaderEpoch + 1, "failed to get expected partition state upon broker shutdown");
        otherBroker.startup();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Set set = this.zkUtils().getInSyncReplicasForPartition(tp.topic(), tp.partition()).toSet();
            scala.collection.immutable.Set set2 = replicas;
            return !(set != null ? !set.equals(set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "restarted broker failed to join in-sync replicas", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        ZkUtils qual$7 = this.zkUtils();
        String x$44 = ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath();
        String x$45 = ZkUtils$.MODULE$.preferredReplicaLeaderElectionZkData((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{tp})));
        java.util.List x$46 = qual$7.createPersistentPath$default$3();
        qual$7.createPersistentPath(x$44, x$45, x$46);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkUtils().pathExists(ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to remove preferred replica leader election path after completion", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.waitForPartitionState(tp, KafkaController$.MODULE$.InitialControllerEpoch(), otherBroker.config().brokerId(), leaderEpoch + 2, "failed to get expected partition state upon broker startup");
    }

    private void waitUntilControllerEpoch(int epoch, String message) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Option option = ((Option)this.zkUtils().readDataMaybeNull(ZkUtils$.MODULE$.ControllerEpochPath())._1()).map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$waitUntilControllerEpoch$3(x$21)));
            Some some = new Some((Object)BoxesRunTime.boxToInteger((int)epoch));
            return !(option != null ? !option.equals(some) : some != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private void waitForPartitionState(TopicAndPartition tp, int controllerEpoch, int leader, int leaderEpoch, String message) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            scala.collection.mutable.Map leaderIsrAndControllerEpochMap = this.zkUtils().getPartitionLeaderAndIsrForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{tp})));
            return leaderIsrAndControllerEpochMap.contains((Object)tp) && this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp), controllerEpoch, leader, leaderEpoch);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private boolean isExpectedPartitionState(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, int controllerEpoch, int leader, int leaderEpoch) {
        return leaderIsrAndControllerEpoch.controllerEpoch() == controllerEpoch && leaderIsrAndControllerEpoch.leaderAndIsr().leader() == leader && leaderIsrAndControllerEpoch.leaderAndIsr().leaderEpoch() == leaderEpoch;
    }

    private Seq<KafkaServer> makeServers(int numConfigs, boolean autoLeaderRebalanceEnable, boolean uncleanLeaderElectionEnable) {
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(numConfigs, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        configs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)autoLeaderRebalanceEnable)).toString());
            config.setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)uncleanLeaderElectionEnable)).toString());
            return config.setProperty(KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp(), "1");
        });
        return (Seq)configs.map((Function1 & Serializable & scala.Serializable)config -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom());
    }

    private boolean makeServers$default$2() {
        return false;
    }

    private boolean makeServers$default$3() {
        return false;
    }

    private Timer timer(String metricName) {
        return (Timer)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$timer$1(metricName, x$22))).values().headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find metric ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricName})), new Position("ControllerIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347)));
    }

    public static final /* synthetic */ int $anonfun$testTopicCreationWithOfflineReplica$1(KafkaServer x$1) {
        return x$1.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testTopicPartitionExpansionWithOfflineReplica$1(KafkaServer x$3) {
        return x$3.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignment$1(KafkaServer x$5) {
        return x$5.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$1(KafkaServer x$7) {
        return x$7.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$1(KafkaServer x$9) {
        return x$9.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testPreferredReplicaLeaderElection$1(int controllerId$6, KafkaServer x$11) {
        return x$11.config().brokerId() != controllerId$6;
    }

    public static final /* synthetic */ boolean $anonfun$testBackToBackPreferredReplicaLeaderElections$1(int controllerId$7, KafkaServer x$12) {
        return x$12.config().brokerId() != controllerId$7;
    }

    public static final /* synthetic */ int $anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$1(KafkaServer x$13) {
        return x$13.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testAutoPreferredReplicaLeaderElection$1(KafkaServer x$15) {
        return x$15.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$1(KafkaServer x$17) {
        return x$17.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$1(KafkaServer x$19) {
        return x$19.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$waitUntilControllerEpoch$3(String x$21) {
        return new StringOps(Predef$.MODULE$.augmentString(x$21)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$timer$1(String metricName$1, MetricName x$22) {
        String string = x$22.getMBeanName();
        String string2 = metricName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }
}

