/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.subversion.remote.FileInformation;
import org.netbeans.modules.subversion.remote.FileStatusCache;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.SubversionVCS;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.netbeans.modules.versioning.core.spi.VCSVisibilityQuery;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;

public class SubversionVisibilityQuery
extends VCSVisibilityQuery
implements VersioningListener {
    private FileStatusCache cache;
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.subversion.remote.SubversionVisibilityQuery");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isVisible(VCSFileProxy file) {
        boolean bl;
        block15: {
            boolean ret;
            long t;
            block13: {
                boolean bl2;
                block14: {
                    block11: {
                        boolean bl3;
                        block12: {
                            block9: {
                                boolean bl4;
                                block10: {
                                    t = System.currentTimeMillis();
                                    if (Subversion.LOG.isLoggable(Level.FINE)) {
                                        Subversion.LOG.log(Level.FINE, "isVisible {0}", new Object[]{file});
                                    }
                                    ret = true;
                                    if (file != null) break block9;
                                    bl4 = true;
                                    if (!Subversion.LOG.isLoggable(Level.FINE)) break block10;
                                    {
                                        catch (Throwable throwable) {
                                            if (Subversion.LOG.isLoggable(Level.FINE)) {
                                                Subversion.LOG.log(Level.FINE, "isVisible returns {0} in {1} millis", new Object[]{ret, System.currentTimeMillis() - t});
                                            }
                                            throw throwable;
                                        }
                                    }
                                    Subversion.LOG.log(Level.FINE, "isVisible returns {0} in {1} millis", new Object[]{ret, System.currentTimeMillis() - t});
                                }
                                return bl4;
                            }
                            if (!file.isFile()) break block11;
                            bl3 = true;
                            if (!Subversion.LOG.isLoggable(Level.FINE)) break block12;
                            Subversion.LOG.log(Level.FINE, "isVisible returns {0} in {1} millis", new Object[]{ret, System.currentTimeMillis() - t});
                        }
                        return bl3;
                    }
                    if (VersioningSupport.getOwner((VCSFileProxy)file) instanceof SubversionVCS) break block13;
                    bl2 = true;
                    if (!Subversion.LOG.isLoggable(Level.FINE)) break block14;
                    Subversion.LOG.log(Level.FINE, "isVisible returns {0} in {1} millis", new Object[]{ret, System.currentTimeMillis() - t});
                }
                return bl2;
            }
            try {
                FileInformation info = this.getCache().getCachedStatus(file);
                boolean bl5 = bl = info == null || info.getStatus() != 256 || !this.containsMetadata(file);
                if (!Subversion.LOG.isLoggable(Level.FINE)) break block15;
            }
            catch (Exception e) {
                boolean bl6;
                block16: {
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                    bl6 = true;
                    if (!Subversion.LOG.isLoggable(Level.FINE)) break block16;
                    Subversion.LOG.log(Level.FINE, "isVisible returns {0} in {1} millis", new Object[]{ret, System.currentTimeMillis() - t});
                }
                return bl6;
            }
            Subversion.LOG.log(Level.FINE, "isVisible returns {0} in {1} millis", new Object[]{ret, System.currentTimeMillis() - t});
        }
        return bl;
    }

    private synchronized FileStatusCache getCache() {
        if (this.cache == null) {
            this.cache = Subversion.getInstance().getStatusCache();
            this.cache.addVersioningListener(this);
        }
        return this.cache;
    }

    public void versioningEvent(VersioningEvent event) {
        VCSFileProxy file;
        if (event.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED && (file = (VCSFileProxy)event.getParams()[0]) != null && file.isDirectory() && this.containsMetadata(file)) {
            FileInformation old = (FileInformation)event.getParams()[1];
            FileInformation cur = (FileInformation)event.getParams()[2];
            if (old != null && old.getStatus() == 256 || cur.getStatus() == 256) {
                this.fireVisibilityChanged(new VCSFileProxy[]{file});
            }
        }
    }

    static boolean isHiddenFolder(FileInformation info, VCSFileProxy file) {
        return file.isDirectory() && info != null && info.getStatus() == 256;
    }

    private boolean containsMetadata(VCSFileProxy folder) {
        VCSFileProxy[] listFiles = folder.listFiles();
        if (listFiles != null) {
            for (VCSFileProxy child : listFiles) {
                if (!SvnUtils.isAdministrative(child.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

