/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.properties;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.subversion.remote.ui.properties.SvnPropertiesNode;
import org.openide.util.NbBundle;

public class PropertiesTableModel
extends AbstractTableModel {
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_VALUE = "value";
    private SvnPropertiesNode[] nodes;
    private String[] columns;
    private static final Map<String, String[]> columnLabels = new HashMap<String, String[]>(2);

    public PropertiesTableModel(String[] clms) {
        if (Arrays.equals(this.columns, clms)) {
            return;
        }
        this.setColumns(clms);
        this.setNodes(new SvnPropertiesNode[0]);
    }

    public void setColumns(String[] clms) {
        this.columns = clms;
        this.fireTableStructureChanged();
    }

    public void setNodes(SvnPropertiesNode[] nodes) {
        this.nodes = nodes;
        this.fireTableDataChanged();
    }

    public SvnPropertiesNode[] getNodes() {
        return this.nodes;
    }

    public SvnPropertiesNode getNode(int row) {
        return this.nodes[row];
    }

    @Override
    public int getRowCount() {
        return this.nodes.length;
    }

    @Override
    public String getColumnName(int column) {
        return columnLabels.get(this.columns[column])[0];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        String col = this.columns[columnIndex];
        if (COLUMN_NAME_NAME.equals(col) || COLUMN_NAME_VALUE.equals(col)) {
            return String.class;
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String clm = this.columns[columnIndex];
        if (clm.equals(COLUMN_NAME_NAME)) {
            return this.nodes[rowIndex].getName();
        }
        if (clm.equals(COLUMN_NAME_VALUE)) {
            return this.nodes[rowIndex].getValue();
        }
        throw new IllegalArgumentException("The column index is out of index: " + columnIndex);
    }

    static {
        ResourceBundle loc = NbBundle.getBundle(PropertiesTableModel.class);
        columnLabels.put(COLUMN_NAME_NAME, new String[]{loc.getString("CTL_PropertiesTable_Column_Name"), loc.getString("CTL_PropertiesTable_Column_Name")});
        columnLabels.put(COLUMN_NAME_VALUE, new String[]{loc.getString("CTL_PropertiesTable_Column_Value"), loc.getString("CTL_PropertiesTable_Column_Value")});
    }
}

