/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.policy.assertion.net.rm200502;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.ComplexAssertion;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.policy.spi.AssertionCreationException;
import com.sun.xml.ws.rx.policy.assertion.AssertionInstantiator;
import com.sun.xml.ws.rx.policy.assertion.AssertionNamespace;
import com.sun.xml.ws.rx.policy.assertion.RmConfigurator;
import com.sun.xml.ws.rx.rm.ReliableMessagingFeatureBuilder;
import com.sun.xml.ws.rx.rm.RmVersion;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import java.util.Collection;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RmFlowControlAssertion
extends ComplexAssertion
implements RmConfigurator {
    public static final QName NAME = AssertionNamespace.MICROSOFT_200502.getQName("RmFlowControl");
    private static final Logger LOGGER = Logger.getLogger(RmFlowControlAssertion.class);
    private static final QName BUFFER_SIZE_ASSERTION_QNAME = AssertionNamespace.MICROSOFT_200502.getQName("MaxReceiveBufferSize");
    private static final long DEFAULT_DESTINATION_BUFFER_QUOTA = 32L;
    private static AssertionInstantiator instantiator = new AssertionInstantiator(){

        @Override
        public PolicyAssertion newInstance(AssertionData data, Collection<PolicyAssertion> assertionParameters, AssertionSet nestedAlternative) throws AssertionCreationException {
            return new RmFlowControlAssertion(data, assertionParameters, nestedAlternative);
        }
    };
    private final long maxBufferSize;

    public static AssertionInstantiator getInstantiator() {
        return instantiator;
    }

    private RmFlowControlAssertion(AssertionData data, Collection<? extends PolicyAssertion> assertionParameters, AssertionSet nestedAlternative) throws AssertionCreationException {
        super(data, assertionParameters, nestedAlternative);
        long _maxBufferSize = 32L;
        boolean bufferSizeSet = false;
        if (assertionParameters != null) {
            for (PolicyAssertion policyAssertion : assertionParameters) {
                if (!BUFFER_SIZE_ASSERTION_QNAME.equals(policyAssertion.getName())) continue;
                if (bufferSizeSet) {
                    throw LOGGER.logSevereException(new AssertionCreationException(data, LocalizationMessages.WSRM_1006_MULTIPLE_BUFFER_SIZES_IN_POLICY()));
                }
                _maxBufferSize = Long.parseLong(policyAssertion.getValue());
            }
        }
        this.maxBufferSize = _maxBufferSize;
    }

    public long getMaximumBufferSize() {
        return this.maxBufferSize;
    }

    @Override
    public ReliableMessagingFeatureBuilder update(ReliableMessagingFeatureBuilder builder) {
        return builder.destinationBufferQuota(this.maxBufferSize);
    }

    @Override
    public boolean isCompatibleWith(RmVersion version) {
        return RmVersion.WSRM200502 == version || RmVersion.WSRM200702 == version;
    }
}

