/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.impl;

import org.clang.basic.OpenMPClauseKind;
import org.clang.basic.OpenMPDefaultClauseKind;
import org.clang.basic.OpenMPDependClauseKind;
import org.clang.basic.OpenMPDirectiveKind;
import org.clang.basic.OpenMPLinearClauseKind;
import org.clang.basic.OpenMPMapClauseKind;
import org.clang.basic.OpenMPProcBindClauseKind;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.StringSwitchUInt;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public final class OpenMPKindsClangGlobals {
    public static OpenMPDirectiveKind getOpenMPDirectiveKind(StringRef Str) {
        return (OpenMPDirectiveKind)((Object)new StringSwitch(Str).Case("threadprivate", (Object)OpenMPDirectiveKind.OMPD_threadprivate).Case("parallel", (Object)OpenMPDirectiveKind.OMPD_parallel).Case("task", (Object)OpenMPDirectiveKind.OMPD_task).Case("simd", (Object)OpenMPDirectiveKind.OMPD_simd).Case("for", (Object)OpenMPDirectiveKind.OMPD_for).Case("sections", (Object)OpenMPDirectiveKind.OMPD_sections).Case("section", (Object)OpenMPDirectiveKind.OMPD_section).Case("single", (Object)OpenMPDirectiveKind.OMPD_single).Case("master", (Object)OpenMPDirectiveKind.OMPD_master).Case("critical", (Object)OpenMPDirectiveKind.OMPD_critical).Case("taskyield", (Object)OpenMPDirectiveKind.OMPD_taskyield).Case("barrier", (Object)OpenMPDirectiveKind.OMPD_barrier).Case("taskwait", (Object)OpenMPDirectiveKind.OMPD_taskwait).Case("taskgroup", (Object)OpenMPDirectiveKind.OMPD_taskgroup).Case("flush", (Object)OpenMPDirectiveKind.OMPD_flush).Case("ordered", (Object)OpenMPDirectiveKind.OMPD_ordered).Case("atomic", (Object)OpenMPDirectiveKind.OMPD_atomic).Case("target", (Object)OpenMPDirectiveKind.OMPD_target).Case("teams", (Object)OpenMPDirectiveKind.OMPD_teams).Case("cancel", (Object)OpenMPDirectiveKind.OMPD_cancel).Case("target data", (Object)OpenMPDirectiveKind.OMPD_target_data).Case("target enter data", (Object)OpenMPDirectiveKind.OMPD_target_enter_data).Case("target exit data", (Object)OpenMPDirectiveKind.OMPD_target_exit_data).Case("target parallel", (Object)OpenMPDirectiveKind.OMPD_target_parallel).Case("target parallel for", (Object)OpenMPDirectiveKind.OMPD_target_parallel_for).Case("target update", (Object)OpenMPDirectiveKind.OMPD_target_update).Case("parallel for", (Object)OpenMPDirectiveKind.OMPD_parallel_for).Case("parallel for simd", (Object)OpenMPDirectiveKind.OMPD_parallel_for_simd).Case("parallel sections", (Object)OpenMPDirectiveKind.OMPD_parallel_sections).Case("for simd", (Object)OpenMPDirectiveKind.OMPD_for_simd).Case("cancellation point", (Object)OpenMPDirectiveKind.OMPD_cancellation_point).Case("declare reduction", (Object)OpenMPDirectiveKind.OMPD_declare_reduction).Case("declare simd", (Object)OpenMPDirectiveKind.OMPD_declare_simd).Case("taskloop", (Object)OpenMPDirectiveKind.OMPD_taskloop).Case("taskloop simd", (Object)OpenMPDirectiveKind.OMPD_taskloop_simd).Case("distribute", (Object)OpenMPDirectiveKind.OMPD_distribute).Case("declare target", (Object)OpenMPDirectiveKind.OMPD_declare_target).Case("end declare target", (Object)OpenMPDirectiveKind.OMPD_end_declare_target).Case("distribute parallel for", (Object)OpenMPDirectiveKind.OMPD_distribute_parallel_for).Case("distribute parallel for simd", (Object)OpenMPDirectiveKind.OMPD_distribute_parallel_for_simd).Case("distribute simd", (Object)OpenMPDirectiveKind.OMPD_distribute_simd).Case("target parallel for simd", (Object)OpenMPDirectiveKind.OMPD_target_parallel_for_simd).Default((Object)OpenMPDirectiveKind.OMPD_unknown));
    }

    public static char.ptr getOpenMPDirectiveName(OpenMPDirectiveKind Kind2) {
        assert (Kind2.getValue() <= OpenMPDirectiveKind.OMPD_unknown.getValue());
        switch (Kind2) {
            case OMPD_unknown: {
                return NativePointer.$unknown;
            }
            case OMPD_threadprivate: {
                return NativePointer.$((String)"threadprivate");
            }
            case OMPD_parallel: {
                return NativePointer.$((String)"parallel");
            }
            case OMPD_task: {
                return NativePointer.$((String)"task");
            }
            case OMPD_simd: {
                return NativePointer.$((String)"simd");
            }
            case OMPD_for: {
                return NativePointer.$for;
            }
            case OMPD_sections: {
                return NativePointer.$((String)"sections");
            }
            case OMPD_section: {
                return NativePointer.$((String)"section");
            }
            case OMPD_single: {
                return NativePointer.$((String)"single");
            }
            case OMPD_master: {
                return NativePointer.$((String)"master");
            }
            case OMPD_critical: {
                return NativePointer.$((String)"critical");
            }
            case OMPD_taskyield: {
                return NativePointer.$((String)"taskyield");
            }
            case OMPD_barrier: {
                return NativePointer.$((String)"barrier");
            }
            case OMPD_taskwait: {
                return NativePointer.$((String)"taskwait");
            }
            case OMPD_taskgroup: {
                return NativePointer.$((String)"taskgroup");
            }
            case OMPD_flush: {
                return NativePointer.$((String)"flush");
            }
            case OMPD_ordered: {
                return NativePointer.$((String)"ordered");
            }
            case OMPD_atomic: {
                return NativePointer.$((String)"atomic");
            }
            case OMPD_target: {
                return NativePointer.$((String)"target");
            }
            case OMPD_teams: {
                return NativePointer.$((String)"teams");
            }
            case OMPD_cancel: {
                return NativePointer.$((String)"cancel");
            }
            case OMPD_target_data: {
                return NativePointer.$((String)"target data");
            }
            case OMPD_target_enter_data: {
                return NativePointer.$((String)"target enter data");
            }
            case OMPD_target_exit_data: {
                return NativePointer.$((String)"target exit data");
            }
            case OMPD_target_parallel: {
                return NativePointer.$((String)"target parallel");
            }
            case OMPD_target_parallel_for: {
                return NativePointer.$((String)"target parallel for");
            }
            case OMPD_target_update: {
                return NativePointer.$((String)"target update");
            }
            case OMPD_parallel_for: {
                return NativePointer.$((String)"parallel for");
            }
            case OMPD_parallel_for_simd: {
                return NativePointer.$((String)"parallel for simd");
            }
            case OMPD_parallel_sections: {
                return NativePointer.$((String)"parallel sections");
            }
            case OMPD_for_simd: {
                return NativePointer.$((String)"for simd");
            }
            case OMPD_cancellation_point: {
                return NativePointer.$((String)"cancellation point");
            }
            case OMPD_declare_reduction: {
                return NativePointer.$((String)"declare reduction");
            }
            case OMPD_declare_simd: {
                return NativePointer.$((String)"declare simd");
            }
            case OMPD_taskloop: {
                return NativePointer.$((String)"taskloop");
            }
            case OMPD_taskloop_simd: {
                return NativePointer.$((String)"taskloop simd");
            }
            case OMPD_distribute: {
                return NativePointer.$((String)"distribute");
            }
            case OMPD_declare_target: {
                return NativePointer.$((String)"declare target");
            }
            case OMPD_end_declare_target: {
                return NativePointer.$((String)"end declare target");
            }
            case OMPD_distribute_parallel_for: {
                return NativePointer.$((String)"distribute parallel for");
            }
            case OMPD_distribute_parallel_for_simd: {
                return NativePointer.$((String)"distribute parallel for simd");
            }
            case OMPD_distribute_simd: {
                return NativePointer.$((String)"distribute simd");
            }
            case OMPD_target_parallel_for_simd: {
                return NativePointer.$((String)"target parallel for simd");
            }
        }
        throw new llvm_unreachable("Invalid OpenMP directive kind");
    }

    public static OpenMPClauseKind getOpenMPClauseKind(StringRef Str) {
        if (llvm.$eq_StringRef((StringRef)Str, (String)"flush")) {
            return OpenMPClauseKind.OMPC_unknown;
        }
        return (OpenMPClauseKind)((Object)new StringSwitch(Str).Case("if", (Object)OpenMPClauseKind.OMPC_if).Case("final", (Object)OpenMPClauseKind.OMPC_final).Case("num_threads", (Object)OpenMPClauseKind.OMPC_num_threads).Case("safelen", (Object)OpenMPClauseKind.OMPC_safelen).Case("simdlen", (Object)OpenMPClauseKind.OMPC_simdlen).Case("collapse", (Object)OpenMPClauseKind.OMPC_collapse).Case("default", (Object)OpenMPClauseKind.OMPC_default).Case("private", (Object)OpenMPClauseKind.OMPC_private).Case("firstprivate", (Object)OpenMPClauseKind.OMPC_firstprivate).Case("lastprivate", (Object)OpenMPClauseKind.OMPC_lastprivate).Case("shared", (Object)OpenMPClauseKind.OMPC_shared).Case("reduction", (Object)OpenMPClauseKind.OMPC_reduction).Case("linear", (Object)OpenMPClauseKind.OMPC_linear).Case("aligned", (Object)OpenMPClauseKind.OMPC_aligned).Case("copyin", (Object)OpenMPClauseKind.OMPC_copyin).Case("copyprivate", (Object)OpenMPClauseKind.OMPC_copyprivate).Case("proc_bind", (Object)OpenMPClauseKind.OMPC_proc_bind).Case("schedule", (Object)OpenMPClauseKind.OMPC_schedule).Case("ordered", (Object)OpenMPClauseKind.OMPC_ordered).Case("nowait", (Object)OpenMPClauseKind.OMPC_nowait).Case("untied", (Object)OpenMPClauseKind.OMPC_untied).Case("mergeable", (Object)OpenMPClauseKind.OMPC_mergeable).Case("flush", (Object)OpenMPClauseKind.OMPC_flush).Case("read", (Object)OpenMPClauseKind.OMPC_read).Case("write", (Object)OpenMPClauseKind.OMPC_write).Case("update", (Object)OpenMPClauseKind.OMPC_update).Case("capture", (Object)OpenMPClauseKind.OMPC_capture).Case("seq_cst", (Object)OpenMPClauseKind.OMPC_seq_cst).Case("depend", (Object)OpenMPClauseKind.OMPC_depend).Case("device", (Object)OpenMPClauseKind.OMPC_device).Case("threads", (Object)OpenMPClauseKind.OMPC_threads).Case("simd", (Object)OpenMPClauseKind.OMPC_simd).Case("map", (Object)OpenMPClauseKind.OMPC_map).Case("num_teams", (Object)OpenMPClauseKind.OMPC_num_teams).Case("thread_limit", (Object)OpenMPClauseKind.OMPC_thread_limit).Case("priority", (Object)OpenMPClauseKind.OMPC_priority).Case("grainsize", (Object)OpenMPClauseKind.OMPC_grainsize).Case("nogroup", (Object)OpenMPClauseKind.OMPC_nogroup).Case("num_tasks", (Object)OpenMPClauseKind.OMPC_num_tasks).Case("hint", (Object)OpenMPClauseKind.OMPC_hint).Case("dist_schedule", (Object)OpenMPClauseKind.OMPC_dist_schedule).Case("defaultmap", (Object)OpenMPClauseKind.OMPC_defaultmap).Case("to", (Object)OpenMPClauseKind.OMPC_to).Case("from", (Object)OpenMPClauseKind.OMPC_from).Case("use_device_ptr", (Object)OpenMPClauseKind.OMPC_use_device_ptr).Case("is_device_ptr", (Object)OpenMPClauseKind.OMPC_is_device_ptr).Case("uniform", (Object)OpenMPClauseKind.OMPC_uniform).Default((Object)OpenMPClauseKind.OMPC_unknown));
    }

    public static char.ptr getOpenMPClauseName(OpenMPClauseKind Kind2) {
        assert (Kind2.getValue() <= OpenMPClauseKind.OMPC_unknown.getValue());
        switch (Kind2) {
            case OMPC_unknown: {
                return NativePointer.$unknown;
            }
            case OMPC_if: {
                return NativePointer.$if;
            }
            case OMPC_final: {
                return NativePointer.$((String)"final");
            }
            case OMPC_num_threads: {
                return NativePointer.$((String)"num_threads");
            }
            case OMPC_safelen: {
                return NativePointer.$((String)"safelen");
            }
            case OMPC_simdlen: {
                return NativePointer.$((String)"simdlen");
            }
            case OMPC_collapse: {
                return NativePointer.$((String)"collapse");
            }
            case OMPC_default: {
                return NativePointer.$default;
            }
            case OMPC_private: {
                return NativePointer.$private;
            }
            case OMPC_firstprivate: {
                return NativePointer.$((String)"firstprivate");
            }
            case OMPC_lastprivate: {
                return NativePointer.$((String)"lastprivate");
            }
            case OMPC_shared: {
                return NativePointer.$((String)"shared");
            }
            case OMPC_reduction: {
                return NativePointer.$((String)"reduction");
            }
            case OMPC_linear: {
                return NativePointer.$((String)"linear");
            }
            case OMPC_aligned: {
                return NativePointer.$((String)"aligned");
            }
            case OMPC_copyin: {
                return NativePointer.$((String)"copyin");
            }
            case OMPC_copyprivate: {
                return NativePointer.$((String)"copyprivate");
            }
            case OMPC_proc_bind: {
                return NativePointer.$((String)"proc_bind");
            }
            case OMPC_schedule: {
                return NativePointer.$((String)"schedule");
            }
            case OMPC_ordered: {
                return NativePointer.$((String)"ordered");
            }
            case OMPC_nowait: {
                return NativePointer.$((String)"nowait");
            }
            case OMPC_untied: {
                return NativePointer.$((String)"untied");
            }
            case OMPC_mergeable: {
                return NativePointer.$((String)"mergeable");
            }
            case OMPC_flush: {
                return NativePointer.$((String)"flush");
            }
            case OMPC_read: {
                return NativePointer.$((String)"read");
            }
            case OMPC_write: {
                return NativePointer.$((String)"write");
            }
            case OMPC_update: {
                return NativePointer.$((String)"update");
            }
            case OMPC_capture: {
                return NativePointer.$((String)"capture");
            }
            case OMPC_seq_cst: {
                return NativePointer.$((String)"seq_cst");
            }
            case OMPC_depend: {
                return NativePointer.$((String)"depend");
            }
            case OMPC_device: {
                return NativePointer.$((String)"device");
            }
            case OMPC_threads: {
                return NativePointer.$((String)"threads");
            }
            case OMPC_simd: {
                return NativePointer.$((String)"simd");
            }
            case OMPC_map: {
                return NativePointer.$((String)"map");
            }
            case OMPC_num_teams: {
                return NativePointer.$((String)"num_teams");
            }
            case OMPC_thread_limit: {
                return NativePointer.$((String)"thread_limit");
            }
            case OMPC_priority: {
                return NativePointer.$((String)"priority");
            }
            case OMPC_grainsize: {
                return NativePointer.$((String)"grainsize");
            }
            case OMPC_nogroup: {
                return NativePointer.$((String)"nogroup");
            }
            case OMPC_num_tasks: {
                return NativePointer.$((String)"num_tasks");
            }
            case OMPC_hint: {
                return NativePointer.$((String)"hint");
            }
            case OMPC_dist_schedule: {
                return NativePointer.$((String)"dist_schedule");
            }
            case OMPC_defaultmap: {
                return NativePointer.$((String)"defaultmap");
            }
            case OMPC_to: {
                return NativePointer.$((String)"to");
            }
            case OMPC_from: {
                return NativePointer.$((String)"from");
            }
            case OMPC_use_device_ptr: {
                return NativePointer.$((String)"use_device_ptr");
            }
            case OMPC_is_device_ptr: {
                return NativePointer.$((String)"is_device_ptr");
            }
            case OMPC_uniform: {
                return NativePointer.$((String)"uniform");
            }
            case OMPC_threadprivate: {
                return NativePointer.$((String)"threadprivate or thread local");
            }
        }
        throw new llvm_unreachable("Invalid OpenMP clause kind");
    }

    public static int getOpenMPSimpleClauseType(OpenMPClauseKind Kind2, StringRef Str) {
        switch (Kind2) {
            case OMPC_default: {
                return ((OpenMPDefaultClauseKind)((Object)new StringSwitch(Str).Case("none", (Object)OpenMPDefaultClauseKind.OMPC_DEFAULT_none).Case("shared", (Object)OpenMPDefaultClauseKind.OMPC_DEFAULT_shared).Default((Object)OpenMPDefaultClauseKind.OMPC_DEFAULT_unknown))).getValue();
            }
            case OMPC_proc_bind: {
                return ((OpenMPProcBindClauseKind)((Object)new StringSwitch(Str).Case("master", (Object)OpenMPProcBindClauseKind.OMPC_PROC_BIND_master).Case("close", (Object)OpenMPProcBindClauseKind.OMPC_PROC_BIND_close).Case("spread", (Object)OpenMPProcBindClauseKind.OMPC_PROC_BIND_spread).Default((Object)OpenMPProcBindClauseKind.OMPC_PROC_BIND_unknown))).getValue();
            }
            case OMPC_schedule: {
                return new StringSwitchUInt(Str).Case("static", 0).Case("dynamic", 1).Case("guided", 2).Case("auto", 3).Case("runtime", 4).Case("monotonic", 6).Case("nonmonotonic", 7).Case("simd", 8).Default(5);
            }
            case OMPC_depend: {
                return ((OpenMPDependClauseKind)((Object)new StringSwitch(Str).Case("in", (Object)OpenMPDependClauseKind.OMPC_DEPEND_in).Case("out", (Object)OpenMPDependClauseKind.OMPC_DEPEND_out).Case("inout", (Object)OpenMPDependClauseKind.OMPC_DEPEND_inout).Case("source", (Object)OpenMPDependClauseKind.OMPC_DEPEND_source).Case("sink", (Object)OpenMPDependClauseKind.OMPC_DEPEND_sink).Default((Object)OpenMPDependClauseKind.OMPC_DEPEND_unknown))).getValue();
            }
            case OMPC_linear: {
                return ((OpenMPLinearClauseKind)((Object)new StringSwitch(Str).Case("val", (Object)OpenMPLinearClauseKind.OMPC_LINEAR_val).Case("ref", (Object)OpenMPLinearClauseKind.OMPC_LINEAR_ref).Case("uval", (Object)OpenMPLinearClauseKind.OMPC_LINEAR_uval).Default((Object)OpenMPLinearClauseKind.OMPC_LINEAR_unknown))).getValue();
            }
            case OMPC_map: {
                return ((OpenMPMapClauseKind)((Object)new StringSwitch(Str).Case("alloc", (Object)OpenMPMapClauseKind.OMPC_MAP_alloc).Case("to", (Object)OpenMPMapClauseKind.OMPC_MAP_to).Case("from", (Object)OpenMPMapClauseKind.OMPC_MAP_from).Case("tofrom", (Object)OpenMPMapClauseKind.OMPC_MAP_tofrom).Case("delete", (Object)OpenMPMapClauseKind.OMPC_MAP_delete).Case("release", (Object)OpenMPMapClauseKind.OMPC_MAP_release).Case("always", (Object)OpenMPMapClauseKind.OMPC_MAP_always).Default((Object)OpenMPMapClauseKind.OMPC_MAP_unknown))).getValue();
            }
            case OMPC_dist_schedule: {
                return new StringSwitchUInt(Str).Case("static", 0).Default(1);
            }
            case OMPC_defaultmap: {
                return new StringSwitchUInt(Str).Case("scalar", 0).Case("tofrom", 2).Default(1);
            }
        }
        throw new llvm_unreachable("Invalid OpenMP simple clause kind");
    }

    public static char.ptr getOpenMPSimpleClauseTypeName(OpenMPClauseKind Kind2, int Type2) {
        switch (Kind2) {
            case OMPC_default: {
                switch (OpenMPDefaultClauseKind.valueOf(Type2)) {
                    case OMPC_DEFAULT_unknown: {
                        return NativePointer.$unknown;
                    }
                    case OMPC_DEFAULT_none: {
                        return NativePointer.$((String)"none");
                    }
                    case OMPC_DEFAULT_shared: {
                        return NativePointer.$((String)"shared");
                    }
                }
                throw new llvm_unreachable("Invalid OpenMP 'default' clause type");
            }
            case OMPC_proc_bind: {
                switch (OpenMPProcBindClauseKind.valueOf(Type2)) {
                    case OMPC_PROC_BIND_unknown: {
                        return NativePointer.$unknown;
                    }
                    case OMPC_PROC_BIND_master: {
                        return NativePointer.$((String)"master");
                    }
                    case OMPC_PROC_BIND_close: {
                        return NativePointer.$((String)"close");
                    }
                    case OMPC_PROC_BIND_spread: {
                        return NativePointer.$((String)"spread");
                    }
                }
                throw new llvm_unreachable("Invalid OpenMP 'proc_bind' clause type");
            }
            case OMPC_schedule: {
                switch (Type2) {
                    case 5: 
                    case 9: {
                        return NativePointer.$unknown;
                    }
                    case 0: {
                        return NativePointer.$static;
                    }
                    case 1: {
                        return NativePointer.$((String)"dynamic");
                    }
                    case 2: {
                        return NativePointer.$((String)"guided");
                    }
                    case 3: {
                        return NativePointer.$auto;
                    }
                    case 4: {
                        return NativePointer.$((String)"runtime");
                    }
                    case 6: {
                        return NativePointer.$((String)"monotonic");
                    }
                    case 7: {
                        return NativePointer.$((String)"nonmonotonic");
                    }
                    case 8: {
                        return NativePointer.$((String)"simd");
                    }
                }
                throw new llvm_unreachable("Invalid OpenMP 'schedule' clause type");
            }
            case OMPC_depend: {
                switch (OpenMPDependClauseKind.valueOf(Type2)) {
                    case OMPC_DEPEND_unknown: {
                        return NativePointer.$unknown;
                    }
                    case OMPC_DEPEND_in: {
                        return NativePointer.$((String)"in");
                    }
                    case OMPC_DEPEND_out: {
                        return NativePointer.$((String)"out");
                    }
                    case OMPC_DEPEND_inout: {
                        return NativePointer.$((String)"inout");
                    }
                    case OMPC_DEPEND_source: {
                        return NativePointer.$((String)"source");
                    }
                    case OMPC_DEPEND_sink: {
                        return NativePointer.$((String)"sink");
                    }
                }
                throw new llvm_unreachable("Invalid OpenMP 'depend' clause type");
            }
            case OMPC_linear: {
                switch (OpenMPLinearClauseKind.valueOf(Type2)) {
                    case OMPC_LINEAR_unknown: {
                        return NativePointer.$unknown;
                    }
                    case OMPC_LINEAR_val: {
                        return NativePointer.$((String)"val");
                    }
                    case OMPC_LINEAR_ref: {
                        return NativePointer.$((String)"ref");
                    }
                    case OMPC_LINEAR_uval: {
                        return NativePointer.$((String)"uval");
                    }
                }
                throw new llvm_unreachable("Invalid OpenMP 'linear' clause type");
            }
            case OMPC_map: {
                switch (OpenMPMapClauseKind.valueOf(Type2)) {
                    case OMPC_MAP_unknown: {
                        return NativePointer.$unknown;
                    }
                    case OMPC_MAP_alloc: {
                        return NativePointer.$((String)"alloc");
                    }
                    case OMPC_MAP_to: {
                        return NativePointer.$((String)"to");
                    }
                    case OMPC_MAP_from: {
                        return NativePointer.$((String)"from");
                    }
                    case OMPC_MAP_tofrom: {
                        return NativePointer.$((String)"tofrom");
                    }
                    case OMPC_MAP_delete: {
                        return NativePointer.$delete;
                    }
                    case OMPC_MAP_release: {
                        return NativePointer.$((String)"release");
                    }
                    case OMPC_MAP_always: {
                        return NativePointer.$((String)"always");
                    }
                }
                throw new llvm_unreachable("Invalid OpenMP 'map' clause type");
            }
            case OMPC_dist_schedule: {
                switch (Type2) {
                    case 1: {
                        return NativePointer.$unknown;
                    }
                    case 0: {
                        return NativePointer.$static;
                    }
                }
                throw new llvm_unreachable("Invalid OpenMP 'dist_schedule' clause type");
            }
            case OMPC_defaultmap: {
                switch (Type2) {
                    case 1: 
                    case 3: {
                        return NativePointer.$unknown;
                    }
                    case 0: {
                        return NativePointer.$((String)"scalar");
                    }
                    case 2: {
                        return NativePointer.$((String)"tofrom");
                    }
                }
                throw new llvm_unreachable("Invalid OpenMP 'schedule' clause type");
            }
        }
        throw new llvm_unreachable("Invalid OpenMP simple clause kind");
    }

    public static boolean isAllowedClauseForDirective(OpenMPDirectiveKind DKind, OpenMPClauseKind CKind) {
        assert (DKind.getValue() <= OpenMPDirectiveKind.OMPD_unknown.getValue());
        assert (CKind.getValue() <= OpenMPClauseKind.OMPC_unknown.getValue());
        switch (DKind) {
            case OMPD_parallel: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_num_threads: {
                        return true;
                    }
                    case OMPC_default: {
                        return true;
                    }
                    case OMPC_proc_bind: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_shared: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                    case OMPC_copyin: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_simd: {
                switch (CKind) {
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_linear: {
                        return true;
                    }
                    case OMPC_aligned: {
                        return true;
                    }
                    case OMPC_safelen: {
                        return true;
                    }
                    case OMPC_simdlen: {
                        return true;
                    }
                    case OMPC_collapse: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_for: {
                switch (CKind) {
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                    case OMPC_collapse: {
                        return true;
                    }
                    case OMPC_schedule: {
                        return true;
                    }
                    case OMPC_ordered: {
                        return true;
                    }
                    case OMPC_nowait: {
                        return true;
                    }
                    case OMPC_linear: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_for_simd: {
                switch (CKind) {
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                    case OMPC_schedule: {
                        return true;
                    }
                    case OMPC_collapse: {
                        return true;
                    }
                    case OMPC_nowait: {
                        return true;
                    }
                    case OMPC_safelen: {
                        return true;
                    }
                    case OMPC_simdlen: {
                        return true;
                    }
                    case OMPC_linear: {
                        return true;
                    }
                    case OMPC_aligned: {
                        return true;
                    }
                    case OMPC_ordered: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_sections: {
                switch (CKind) {
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                    case OMPC_nowait: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_single: {
                switch (CKind) {
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_copyprivate: {
                        return true;
                    }
                    case OMPC_nowait: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_parallel_for: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_num_threads: {
                        return true;
                    }
                    case OMPC_default: {
                        return true;
                    }
                    case OMPC_proc_bind: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_shared: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                    case OMPC_copyin: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_collapse: {
                        return true;
                    }
                    case OMPC_schedule: {
                        return true;
                    }
                    case OMPC_ordered: {
                        return true;
                    }
                    case OMPC_linear: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_parallel_for_simd: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_num_threads: {
                        return true;
                    }
                    case OMPC_default: {
                        return true;
                    }
                    case OMPC_proc_bind: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_shared: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                    case OMPC_copyin: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_collapse: {
                        return true;
                    }
                    case OMPC_schedule: {
                        return true;
                    }
                    case OMPC_safelen: {
                        return true;
                    }
                    case OMPC_simdlen: {
                        return true;
                    }
                    case OMPC_linear: {
                        return true;
                    }
                    case OMPC_aligned: {
                        return true;
                    }
                    case OMPC_ordered: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_parallel_sections: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_num_threads: {
                        return true;
                    }
                    case OMPC_default: {
                        return true;
                    }
                    case OMPC_proc_bind: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_shared: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                    case OMPC_copyin: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_task: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_final: {
                        return true;
                    }
                    case OMPC_default: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_shared: {
                        return true;
                    }
                    case OMPC_untied: {
                        return true;
                    }
                    case OMPC_mergeable: {
                        return true;
                    }
                    case OMPC_depend: {
                        return true;
                    }
                    case OMPC_priority: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_flush: {
                return CKind == OpenMPClauseKind.OMPC_flush;
            }
            case OMPD_atomic: {
                switch (CKind) {
                    case OMPC_read: {
                        return true;
                    }
                    case OMPC_write: {
                        return true;
                    }
                    case OMPC_update: {
                        return true;
                    }
                    case OMPC_capture: {
                        return true;
                    }
                    case OMPC_seq_cst: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_target: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_device: {
                        return true;
                    }
                    case OMPC_map: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_nowait: {
                        return true;
                    }
                    case OMPC_depend: {
                        return true;
                    }
                    case OMPC_defaultmap: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_is_device_ptr: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_target_data: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_device: {
                        return true;
                    }
                    case OMPC_map: {
                        return true;
                    }
                    case OMPC_use_device_ptr: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_target_enter_data: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_device: {
                        return true;
                    }
                    case OMPC_map: {
                        return true;
                    }
                    case OMPC_nowait: {
                        return true;
                    }
                    case OMPC_depend: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_target_exit_data: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_device: {
                        return true;
                    }
                    case OMPC_map: {
                        return true;
                    }
                    case OMPC_nowait: {
                        return true;
                    }
                    case OMPC_depend: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_target_parallel: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_device: {
                        return true;
                    }
                    case OMPC_map: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_nowait: {
                        return true;
                    }
                    case OMPC_depend: {
                        return true;
                    }
                    case OMPC_defaultmap: {
                        return true;
                    }
                    case OMPC_num_threads: {
                        return true;
                    }
                    case OMPC_default: {
                        return true;
                    }
                    case OMPC_proc_bind: {
                        return true;
                    }
                    case OMPC_shared: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_target_parallel_for: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_device: {
                        return true;
                    }
                    case OMPC_map: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_nowait: {
                        return true;
                    }
                    case OMPC_depend: {
                        return true;
                    }
                    case OMPC_defaultmap: {
                        return true;
                    }
                    case OMPC_num_threads: {
                        return true;
                    }
                    case OMPC_default: {
                        return true;
                    }
                    case OMPC_proc_bind: {
                        return true;
                    }
                    case OMPC_shared: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                    case OMPC_collapse: {
                        return true;
                    }
                    case OMPC_schedule: {
                        return true;
                    }
                    case OMPC_ordered: {
                        return true;
                    }
                    case OMPC_linear: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_target_update: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_device: {
                        return true;
                    }
                    case OMPC_to: {
                        return true;
                    }
                    case OMPC_from: {
                        return true;
                    }
                    case OMPC_nowait: {
                        return true;
                    }
                    case OMPC_depend: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_teams: {
                switch (CKind) {
                    case OMPC_default: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_shared: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                    case OMPC_num_teams: {
                        return true;
                    }
                    case OMPC_thread_limit: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_declare_simd: {
                break;
            }
            case OMPD_cancel: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_ordered: {
                switch (CKind) {
                    case OMPC_threads: {
                        return true;
                    }
                    case OMPC_simd: {
                        return true;
                    }
                    case OMPC_depend: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_taskloop: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_shared: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_default: {
                        return true;
                    }
                    case OMPC_collapse: {
                        return true;
                    }
                    case OMPC_final: {
                        return true;
                    }
                    case OMPC_untied: {
                        return true;
                    }
                    case OMPC_mergeable: {
                        return true;
                    }
                    case OMPC_priority: {
                        return true;
                    }
                    case OMPC_grainsize: {
                        return true;
                    }
                    case OMPC_nogroup: {
                        return true;
                    }
                    case OMPC_num_tasks: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_taskloop_simd: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_shared: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_default: {
                        return true;
                    }
                    case OMPC_collapse: {
                        return true;
                    }
                    case OMPC_final: {
                        return true;
                    }
                    case OMPC_untied: {
                        return true;
                    }
                    case OMPC_mergeable: {
                        return true;
                    }
                    case OMPC_priority: {
                        return true;
                    }
                    case OMPC_linear: {
                        return true;
                    }
                    case OMPC_aligned: {
                        return true;
                    }
                    case OMPC_safelen: {
                        return true;
                    }
                    case OMPC_simdlen: {
                        return true;
                    }
                    case OMPC_grainsize: {
                        return true;
                    }
                    case OMPC_nogroup: {
                        return true;
                    }
                    case OMPC_num_tasks: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_critical: {
                switch (CKind) {
                    case OMPC_hint: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_distribute: {
                switch (CKind) {
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_collapse: {
                        return true;
                    }
                    case OMPC_dist_schedule: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_distribute_parallel_for: {
                switch (CKind) {
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_collapse: {
                        return true;
                    }
                    case OMPC_dist_schedule: {
                        return true;
                    }
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_num_threads: {
                        return true;
                    }
                    case OMPC_default: {
                        return true;
                    }
                    case OMPC_proc_bind: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_shared: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                    case OMPC_copyin: {
                        return true;
                    }
                    case OMPC_schedule: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_distribute_parallel_for_simd: {
                switch (CKind) {
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_collapse: {
                        return true;
                    }
                    case OMPC_dist_schedule: {
                        return true;
                    }
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_num_threads: {
                        return true;
                    }
                    case OMPC_default: {
                        return true;
                    }
                    case OMPC_proc_bind: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_shared: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                    case OMPC_copyin: {
                        return true;
                    }
                    case OMPC_schedule: {
                        return true;
                    }
                    case OMPC_linear: {
                        return true;
                    }
                    case OMPC_aligned: {
                        return true;
                    }
                    case OMPC_safelen: {
                        return true;
                    }
                    case OMPC_simdlen: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_distribute_simd: {
                switch (CKind) {
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_collapse: {
                        return true;
                    }
                    case OMPC_dist_schedule: {
                        return true;
                    }
                    case OMPC_linear: {
                        return true;
                    }
                    case OMPC_aligned: {
                        return true;
                    }
                    case OMPC_safelen: {
                        return true;
                    }
                    case OMPC_simdlen: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                }
                break;
            }
            case OMPD_target_parallel_for_simd: {
                switch (CKind) {
                    case OMPC_if: {
                        return true;
                    }
                    case OMPC_device: {
                        return true;
                    }
                    case OMPC_map: {
                        return true;
                    }
                    case OMPC_private: {
                        return true;
                    }
                    case OMPC_firstprivate: {
                        return true;
                    }
                    case OMPC_lastprivate: {
                        return true;
                    }
                    case OMPC_nowait: {
                        return true;
                    }
                    case OMPC_depend: {
                        return true;
                    }
                    case OMPC_defaultmap: {
                        return true;
                    }
                    case OMPC_num_threads: {
                        return true;
                    }
                    case OMPC_default: {
                        return true;
                    }
                    case OMPC_proc_bind: {
                        return true;
                    }
                    case OMPC_shared: {
                        return true;
                    }
                    case OMPC_reduction: {
                        return true;
                    }
                    case OMPC_collapse: {
                        return true;
                    }
                    case OMPC_schedule: {
                        return true;
                    }
                    case OMPC_ordered: {
                        return true;
                    }
                    case OMPC_linear: {
                        return true;
                    }
                    case OMPC_safelen: {
                        return true;
                    }
                    case OMPC_simdlen: {
                        return true;
                    }
                    case OMPC_aligned: {
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    public static boolean isOpenMPLoopDirective(OpenMPDirectiveKind DKind) {
        return DKind == OpenMPDirectiveKind.OMPD_simd || DKind == OpenMPDirectiveKind.OMPD_for || DKind == OpenMPDirectiveKind.OMPD_for_simd || DKind == OpenMPDirectiveKind.OMPD_parallel_for || DKind == OpenMPDirectiveKind.OMPD_parallel_for_simd || DKind == OpenMPDirectiveKind.OMPD_taskloop || DKind == OpenMPDirectiveKind.OMPD_taskloop_simd || DKind == OpenMPDirectiveKind.OMPD_distribute || DKind == OpenMPDirectiveKind.OMPD_target_parallel_for || DKind == OpenMPDirectiveKind.OMPD_distribute_parallel_for || DKind == OpenMPDirectiveKind.OMPD_distribute_parallel_for_simd || DKind == OpenMPDirectiveKind.OMPD_distribute_simd || DKind == OpenMPDirectiveKind.OMPD_target_parallel_for_simd;
    }

    public static boolean isOpenMPWorksharingDirective(OpenMPDirectiveKind DKind) {
        return DKind == OpenMPDirectiveKind.OMPD_for || DKind == OpenMPDirectiveKind.OMPD_for_simd || DKind == OpenMPDirectiveKind.OMPD_sections || DKind == OpenMPDirectiveKind.OMPD_section || DKind == OpenMPDirectiveKind.OMPD_single || DKind == OpenMPDirectiveKind.OMPD_parallel_for || DKind == OpenMPDirectiveKind.OMPD_parallel_for_simd || DKind == OpenMPDirectiveKind.OMPD_parallel_sections || DKind == OpenMPDirectiveKind.OMPD_target_parallel_for || DKind == OpenMPDirectiveKind.OMPD_distribute_parallel_for || DKind == OpenMPDirectiveKind.OMPD_distribute_parallel_for_simd || DKind == OpenMPDirectiveKind.OMPD_target_parallel_for_simd;
    }

    public static boolean isOpenMPTaskLoopDirective(OpenMPDirectiveKind DKind) {
        return DKind == OpenMPDirectiveKind.OMPD_taskloop || DKind == OpenMPDirectiveKind.OMPD_taskloop_simd;
    }

    public static boolean isOpenMPParallelDirective(OpenMPDirectiveKind DKind) {
        return DKind == OpenMPDirectiveKind.OMPD_parallel || DKind == OpenMPDirectiveKind.OMPD_parallel_for || DKind == OpenMPDirectiveKind.OMPD_parallel_for_simd || DKind == OpenMPDirectiveKind.OMPD_parallel_sections || DKind == OpenMPDirectiveKind.OMPD_target_parallel || DKind == OpenMPDirectiveKind.OMPD_target_parallel_for || DKind == OpenMPDirectiveKind.OMPD_distribute_parallel_for || DKind == OpenMPDirectiveKind.OMPD_distribute_parallel_for_simd || DKind == OpenMPDirectiveKind.OMPD_target_parallel_for_simd;
    }

    public static boolean isOpenMPTargetExecutionDirective(OpenMPDirectiveKind DKind) {
        return DKind == OpenMPDirectiveKind.OMPD_target || DKind == OpenMPDirectiveKind.OMPD_target_parallel || DKind == OpenMPDirectiveKind.OMPD_target_parallel_for || DKind == OpenMPDirectiveKind.OMPD_target_parallel_for_simd;
    }

    public static boolean isOpenMPTargetDataManagementDirective(OpenMPDirectiveKind DKind) {
        return DKind == OpenMPDirectiveKind.OMPD_target_data || DKind == OpenMPDirectiveKind.OMPD_target_enter_data || DKind == OpenMPDirectiveKind.OMPD_target_exit_data || DKind == OpenMPDirectiveKind.OMPD_target_update;
    }

    public static boolean isOpenMPTeamsDirective(OpenMPDirectiveKind DKind) {
        return DKind == OpenMPDirectiveKind.OMPD_teams;
    }

    public static boolean isOpenMPSimdDirective(OpenMPDirectiveKind DKind) {
        return DKind == OpenMPDirectiveKind.OMPD_simd || DKind == OpenMPDirectiveKind.OMPD_for_simd || DKind == OpenMPDirectiveKind.OMPD_parallel_for_simd || DKind == OpenMPDirectiveKind.OMPD_taskloop_simd || DKind == OpenMPDirectiveKind.OMPD_distribute_parallel_for_simd || DKind == OpenMPDirectiveKind.OMPD_distribute_simd;
    }

    public static boolean isOpenMPDistributeDirective(OpenMPDirectiveKind Kind2) {
        return Kind2 == OpenMPDirectiveKind.OMPD_distribute || Kind2 == OpenMPDirectiveKind.OMPD_distribute_parallel_for || Kind2 == OpenMPDirectiveKind.OMPD_distribute_parallel_for_simd || Kind2 == OpenMPDirectiveKind.OMPD_distribute_simd;
    }

    public static boolean isOpenMPPrivate(OpenMPClauseKind Kind2) {
        return Kind2 == OpenMPClauseKind.OMPC_private || Kind2 == OpenMPClauseKind.OMPC_firstprivate || Kind2 == OpenMPClauseKind.OMPC_lastprivate || Kind2 == OpenMPClauseKind.OMPC_linear || Kind2 == OpenMPClauseKind.OMPC_reduction;
    }

    public static boolean isOpenMPThreadPrivate(OpenMPClauseKind Kind2) {
        return Kind2 == OpenMPClauseKind.OMPC_threadprivate || Kind2 == OpenMPClauseKind.OMPC_copyin;
    }

    public static boolean isOpenMPTaskingDirective(OpenMPDirectiveKind Kind2) {
        return Kind2 == OpenMPDirectiveKind.OMPD_task || OpenMPKindsClangGlobals.isOpenMPTaskLoopDirective(Kind2);
    }

    public static boolean isOpenMPLoopBoundSharingDirective(OpenMPDirectiveKind Kind2) {
        return Kind2 == OpenMPDirectiveKind.OMPD_distribute_parallel_for || Kind2 == OpenMPDirectiveKind.OMPD_distribute_parallel_for_simd || Kind2 == OpenMPDirectiveKind.OMPD_distribute_simd;
    }
}

