/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.impl;

import org.clang.basic.impl.Entry;
import org.clang.basic.impl.EntryKind;
import org.clang.basic.impl.RedirectingDirectoryEntry;
import org.clang.basic.impl.RedirectingFileEntry;
import org.clang.basic.impl.RedirectingFileSystem;
import org.clang.basic.llvm.impl.DenseMapInfoStringRef;
import org.clang.basic.vfs.Status;
import org.clang.basic.vfs.VfsGlobals;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.sys.TimeValue;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;
import org.llvm.support.yaml.KeyValueNode;
import org.llvm.support.yaml.MappingNode;
import org.llvm.support.yaml.Node;
import org.llvm.support.yaml.ScalarNode;
import org.llvm.support.yaml.SequenceNode;
import org.llvm.support.yaml.Stream;
import org.llvm.support.yaml.basic_collection_iterator;

public class RedirectingFileSystemParser {
    private Stream Stream;

    private void error(Node N, Twine Msg) {
        this.Stream.printError(N, Msg);
    }

    private boolean parseScalarString(Node N, StringRef Result, SmallString Storage2) {
        ScalarNode S = (ScalarNode)llvm.dyn_cast(ScalarNode.class, (Object)N);
        if (S == null) {
            this.error(N, new Twine("expected string"));
            return false;
        }
        Result.$assignMove(S.getValue(Storage2));
        return true;
    }

    private boolean parseScalarBool(Node N, bool.ref Result) {
        StringRef Value = new StringRef();
        SmallString Storage2 = new SmallString(5);
        if (!this.parseScalarString(N, Value, Storage2)) {
            return false;
        }
        if (Value.equals_lower("true") || Value.equals_lower("on") || Value.equals_lower("yes") || llvm.$eq_StringRef((StringRef)Value, (String)"1")) {
            Result.$set(true);
            return true;
        }
        if (Value.equals_lower("false") || Value.equals_lower("off") || Value.equals_lower("no") || llvm.$eq_StringRef((StringRef)Value, (String)"0")) {
            Result.$set(false);
            return true;
        }
        this.error(N, new Twine("expected boolean value"));
        return false;
    }

    private boolean checkDuplicateOrUnknownKey(Node KeyNode, StringRef Key, DenseMap<StringRef, KeyStatus> Keys) {
        if (Keys.count((Object)Key) == 0) {
            this.error(KeyNode, new Twine("unknown key"));
            return false;
        }
        KeyStatus S = (KeyStatus)Keys.$at((Object)Key);
        if (S.Seen) {
            this.error(KeyNode, llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine("duplicate key '"), (Twine)new Twine(Key)), (Twine)new Twine(NativePointer.$SGL_QUOTE)));
            return false;
        }
        S.Seen = true;
        return true;
    }

    private boolean checkMissingKeys(Node Obj, DenseMap<StringRef, KeyStatus> Keys) {
        DenseMapIterator I = Keys.begin();
        DenseMapIterator E = Keys.end();
        while (I.$noteq(E)) {
            if (((KeyStatus)I.$arrow().second).Required && !((KeyStatus)I.$arrow().second).Seen) {
                this.error(Obj, llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine("missing key '"), (Twine)new Twine((StringRef)I.$arrow().first)), (Twine)new Twine(NativePointer.$SGL_QUOTE)));
                return false;
            }
            I.$preInc();
        }
        return true;
    }

    private Entry lookupOrCreateEntry(RedirectingFileSystem FS, StringRef Name) {
        return this.lookupOrCreateEntry(FS, Name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry lookupOrCreateEntry(RedirectingFileSystem FS, StringRef Name, Entry ParentEntry) {
        std_ptr.unique_ptr E = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            Entry DE;
            if (ParentEntry == null) {
                for (std_ptr.unique_ptr Root : FS.Roots) {
                    if (!Name.equals(((Entry)Root.$arrow()).getName())) continue;
                    Entry entry = ParentEntry = (Entry)Root.get();
                    return entry;
                }
            } else {
                DE = (RedirectingDirectoryEntry)llvm.dyn_cast(RedirectingDirectoryEntry.class, (Object)ParentEntry);
                for (std_ptr.unique_ptr Content : llvm.make_range(((RedirectingDirectoryEntry)DE).contents_begin(), ((RedirectingDirectoryEntry)DE).contents_end())) {
                    RedirectingDirectoryEntry DirContent = (RedirectingDirectoryEntry)llvm.dyn_cast(RedirectingDirectoryEntry.class, (Object)Content.get());
                    if (DirContent == null || !Name.equals(((Entry)Content.$arrow()).getName())) continue;
                    RedirectingDirectoryEntry redirectingDirectoryEntry = DirContent;
                    return redirectingDirectoryEntry;
                }
            }
            E = (std_ptr.unique_ptr)$c$.clean((Object)new std_ptr.unique_ptr($c$.track(llvm.make_unique((Object)new RedirectingDirectoryEntry(Name, new Status(new StringRef(NativePointer.$EMPTY), VfsGlobals.getNextVirtualUniqueID(), TimeValue.now(), 0, 0, 0L, fs.file_type.directory_file, 511))))));
            if (ParentEntry == null) {
                FS.Roots.push_back((Object)std.move((std_ptr.unique_ptr)E));
                DE = ParentEntry = (Entry)((std_ptr.unique_ptr)FS.Roots.back()).get();
                return DE;
            }
            DE = (RedirectingDirectoryEntry)llvm.dyn_cast(RedirectingDirectoryEntry.class, (Object)ParentEntry);
            ((RedirectingDirectoryEntry)DE).addContent((std_ptr.unique_ptr<Entry>)$c$.track(new std_ptr.unique_ptr(JavaDifferentiators.JD.Move.INSTANCE, std.move((std_ptr.unique_ptr)E))));
            $c$.clean();
            Entry entry = ((RedirectingDirectoryEntry)DE).getLastContent();
            return entry;
        }
        finally {
            if (E != null) {
                E.$destroy();
            }
            $c$.$destroy();
        }
    }

    private void uniqueOverlayTree(RedirectingFileSystem FS, Entry SrcE) {
        this.uniqueOverlayTree(FS, SrcE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uniqueOverlayTree(RedirectingFileSystem FS, Entry SrcE, Entry NewParentE) {
        StringRef Name = SrcE.getName();
        switch (SrcE.getKind()) {
            case EK_Directory: {
                RedirectingDirectoryEntry DE = (RedirectingDirectoryEntry)llvm.dyn_cast(RedirectingDirectoryEntry.class, (Object)SrcE);
                assert (DE != null) : "Must be a directory";
                if (!Name.empty()) {
                    NewParentE = this.lookupOrCreateEntry(FS, new StringRef(Name), NewParentE);
                }
                for (std_ptr.unique_ptr SubEntry : llvm.make_range(DE.contents_begin(), DE.contents_end())) {
                    this.uniqueOverlayTree(FS, (Entry)SubEntry.get(), NewParentE);
                }
                break;
            }
            case EK_File: {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    RedirectingFileEntry FE = (RedirectingFileEntry)llvm.dyn_cast(RedirectingFileEntry.class, (Object)SrcE);
                    assert (FE != null) : "Must be a file";
                    assert (NewParentE != null) : "Parent entry must exist";
                    RedirectingDirectoryEntry DE = (RedirectingDirectoryEntry)llvm.dyn_cast(RedirectingDirectoryEntry.class, (Object)NewParentE);
                    DE.addContent((std_ptr.unique_ptr<Entry>)$c$.track(new std_ptr.unique_ptr($c$.track(llvm.make_unique((Object)new RedirectingFileEntry(Name, FE.getExternalContentsPath(), FE.getUseName()))))));
                    $c$.clean();
                    break;
                }
                finally {
                    $c$.$destroy();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private std_ptr.unique_ptr<Entry> parseEntry(Node N, RedirectingFileSystem FS) {
        std.vector EntryArrayContents = null;
        std_ptr.unique_ptr Result = null;
        try {
            path.reverse_iterator E;
            path.reverse_iterator I;
            std_ptr.unique_ptr unique_ptr2;
            MappingNode M = (MappingNode)llvm.dyn_cast(MappingNode.class, (Object)N);
            if (M == null) {
                this.error(N, new Twine("expected mapping node for file or directory entry"));
                std_ptr.unique_ptr unique_ptr3 = new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
                return unique_ptr3;
            }
            Object[] Fields = new std_pair.pair[]{new std_pair.pair((Object)new StringRef("name"), (Object)new KeyStatus(true)), new std_pair.pair((Object)new StringRef("type"), (Object)new KeyStatus(true)), new std_pair.pair((Object)new StringRef("contents"), (Object)new KeyStatus(false)), new std_pair.pair((Object)new StringRef("external-contents"), (Object)new KeyStatus(false)), new std_pair.pair((Object)new StringRef("use-external-name"), (Object)new KeyStatus(false))};
            DenseMap Keys = new DenseMap((DenseMapInfo)new DenseMapInfoStringRef(), (type.iterator)std.begin((Object[])Fields), (type.iterator)std.end((Object[])Fields), (Object)new KeyStatus());
            boolean HasContents = false;
            EntryArrayContents = new std.vector((Object)new std_ptr.unique_ptr());
            std.string ExternalContentsPath = new std.string();
            std.string Name = new std.string();
            RedirectingFileEntry.NameKind UseExternalName = RedirectingFileEntry.NameKind.NK_NotSet;
            EntryKind Kind2 = EntryKind.EK_Directory;
            basic_collection_iterator I2 = M.begin();
            basic_collection_iterator E2 = M.end();
            while (true) {
                block71: {
                    basic_collection_iterator _E;
                    basic_collection_iterator _I;
                    block78: {
                        StringRef Value;
                        block74: {
                            SequenceNode Contents;
                            SmallString Buffer2;
                            StringRef Key;
                            block77: {
                                std_ptr.unique_ptr Path;
                                block76: {
                                    block75: {
                                        if (!I2.$noteq(E2)) break block74;
                                        Key = new StringRef();
                                        Buffer2 = new SmallString(256);
                                        if (!this.parseScalarString(((KeyValueNode)I2.$arrow()).getKey(), Key, Buffer2)) {
                                            unique_ptr2 = new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
                                            return unique_ptr2;
                                        }
                                        if (!this.checkDuplicateOrUnknownKey(((KeyValueNode)I2.$arrow()).getKey(), new StringRef(Key), (DenseMap<StringRef, KeyStatus>)Keys)) {
                                            unique_ptr2 = new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
                                            return unique_ptr2;
                                        }
                                        Value = new StringRef();
                                        if (!llvm.$eq_StringRef((StringRef)Key, (String)"name")) break block75;
                                        if (!this.parseScalarString(((KeyValueNode)I2.$arrow()).getValue(), Value, Buffer2)) {
                                            std_ptr.unique_ptr unique_ptr4 = new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
                                            return unique_ptr4;
                                        }
                                        if (FS.UseCanonicalizedPaths) {
                                            Path = new SmallString(new StringRef(Value), 256);
                                            Path.$assign(path.remove_leading_dotslash((StringRef)Path.$StringRef()));
                                            path.remove_dots((SmallString)Path, (boolean)true);
                                            Name.$assignMove(Path.str().$basic_string());
                                            break block71;
                                        } else {
                                            Name.$assignMove(Value.$basic_string());
                                        }
                                        break block71;
                                    }
                                    if (!llvm.$eq_StringRef((StringRef)Key, (String)"type")) break block76;
                                    if (!this.parseScalarString(((KeyValueNode)I2.$arrow()).getValue(), Value, Buffer2)) {
                                        Path = new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
                                        return Path;
                                    }
                                    if (llvm.$eq_StringRef((StringRef)Value, (String)"file")) {
                                        Kind2 = EntryKind.EK_File;
                                        break block71;
                                    } else {
                                        if (!llvm.$eq_StringRef((StringRef)Value, (String)"directory")) {
                                            this.error(((KeyValueNode)I2.$arrow()).getValue(), new Twine("unknown value for 'type'"));
                                            Path = new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
                                            return Path;
                                        }
                                        Kind2 = EntryKind.EK_Directory;
                                    }
                                    break block71;
                                }
                                if (!llvm.$eq_StringRef((StringRef)Key, (String)"contents")) break block77;
                                if (HasContents) {
                                    this.error(((KeyValueNode)I2.$arrow()).getKey(), new Twine("entry already has 'contents' or 'external-contents'"));
                                    Path = new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
                                    return Path;
                                }
                                HasContents = true;
                                Contents = (SequenceNode)llvm.dyn_cast(SequenceNode.class, (Object)((KeyValueNode)I2.$arrow()).getValue());
                                if (Contents == null) {
                                    this.error(((KeyValueNode)I2.$arrow()).getValue(), new Twine("expected array"));
                                    std_ptr.unique_ptr unique_ptr5 = new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
                                    return unique_ptr5;
                                }
                                _I = Contents.begin();
                                _E = Contents.end();
                                break block78;
                            }
                            if (llvm.$eq_StringRef((StringRef)Key, (String)"external-contents")) {
                                if (HasContents) {
                                    this.error(((KeyValueNode)I2.$arrow()).getKey(), new Twine("entry already has 'contents' or 'external-contents'"));
                                    Contents = new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
                                    return Contents;
                                }
                                HasContents = true;
                                if (!this.parseScalarString(((KeyValueNode)I2.$arrow()).getValue(), Value, Buffer2)) {
                                    Contents = new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
                                    return Contents;
                                }
                                SmallString FullPath = new SmallString(256);
                                if (FS.IsRelativeOverlay$Ref.$deref()) {
                                    FullPath.$assign(FS.getExternalContentsPrefixDir());
                                    assert (!FullPath.empty()) : "External contents prefix directory must exist";
                                    path.append((SmallString)FullPath, (Twine)new Twine(Value));
                                } else {
                                    FullPath.$assign(Value);
                                }
                                if (FS.UseCanonicalizedPaths) {
                                    FullPath.$assign(path.remove_leading_dotslash((StringRef)FullPath.$StringRef()));
                                    path.remove_dots((SmallString)FullPath, (boolean)true);
                                }
                                ExternalContentsPath.$assignMove(FullPath.str().$basic_string());
                                break block71;
                            } else {
                                if (!llvm.$eq_StringRef((StringRef)Key, (String)"use-external-name")) throw new llvm_unreachable("key missing from Keys");
                                bool.ref Val = NativePointer.create_bool$ref();
                                if (!this.parseScalarBool(((KeyValueNode)I2.$arrow()).getValue(), Val)) {
                                    _I = new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
                                    return _I;
                                }
                                UseExternalName = Val.$deref() ? RedirectingFileEntry.NameKind.NK_External : RedirectingFileEntry.NameKind.NK_Virtual;
                            }
                            break block71;
                        }
                        if (this.Stream.failed()) {
                            I2 = new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
                            return I2;
                        }
                        if (!HasContents) {
                            this.error(N, new Twine("missing key 'contents' or 'external-contents'"));
                            I2 = new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
                            return I2;
                        }
                        if (!this.checkMissingKeys(N, (DenseMap<StringRef, KeyStatus>)Keys)) {
                            I2 = new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
                            return I2;
                        }
                        if (Kind2 == EntryKind.EK_Directory && UseExternalName != RedirectingFileEntry.NameKind.NK_NotSet) {
                            this.error(N, new Twine("'use-external-name' is not supported for directories"));
                            I2 = new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
                            return I2;
                        }
                        StringRef Trimmed = new StringRef(Name);
                        int RootPathLen = path.root_path((StringRef)Trimmed).size();
                        while (Unsigned.$greater_uint((int)Trimmed.size(), (int)RootPathLen) && path.is_separator((byte)Trimmed.back())) {
                            Trimmed.$assignMove(Trimmed.slice(0, Trimmed.size() - 1));
                        }
                        StringRef LastComponent = path.filename((StringRef)Trimmed);
                        Result = new std_ptr.unique_ptr();
                        switch (Kind2) {
                            case EK_File: {
                                JavaCleaner $c$ = Native.$createJavaCleaner();
                                try {
                                    $c$.clean((Object)Result.$assign$ConvertibleNotArray((Object)$c$.track(llvm.make_unique((Object)new RedirectingFileEntry(LastComponent, new StringRef(std.move((std.string)ExternalContentsPath)), UseExternalName)))));
                                    break;
                                }
                                finally {
                                    $c$.$destroy();
                                }
                            }
                            case EK_Directory: {
                                JavaCleaner $c$ = Native.$createJavaCleaner();
                                try {
                                    $c$.clean((Object)Result.$assign$ConvertibleNotArray((Object)$c$.track(llvm.make_unique((Object)new RedirectingDirectoryEntry(LastComponent, (std.vector<std_ptr.unique_ptr<Entry>>)((std.vector)std.move((Object)EntryArrayContents)), new Status(new StringRef(NativePointer.$EMPTY), VfsGlobals.getNextVirtualUniqueID(), TimeValue.now(), 0, 0, 0L, fs.file_type.directory_file, 511))))));
                                    break;
                                }
                                finally {
                                    $c$.$destroy();
                                }
                            }
                        }
                        StringRef Parent = path.parent_path((StringRef)Trimmed);
                        if (Parent.empty()) {
                            Value = new std_ptr.unique_ptr(JavaDifferentiators.JD.Move.INSTANCE, Result);
                            return Value;
                        }
                        I = path.rbegin((StringRef)Parent);
                        E = path.rend((StringRef)Parent);
                        break;
                    }
                    while (_I.$noteq(_E)) {
                        std_ptr.unique_ptr<Entry> _Entry = null;
                        try {
                            _Entry = this.parseEntry((Node)_I.$star(), FS);
                            if (!_Entry.$bool()) {
                                std_ptr.unique_ptr unique_ptr6 = new std_ptr.unique_ptr(JavaDifferentiators.JD$NullPtr.INSTANCE, null);
                                return unique_ptr6;
                            }
                            EntryArrayContents.push_back((Object)std.move(_Entry));
                        }
                        finally {
                            if (_Entry != null) {
                                _Entry.$destroy();
                            }
                        }
                        _I.$preInc();
                    }
                }
                I2.$preInc();
            }
            while (I.$noteq((Object)E)) {
                std.vector Entries = null;
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    Entries = new std.vector((Object)new std_ptr.unique_ptr());
                    Entries.push_back((Object)std.move((std_ptr.unique_ptr)Result));
                    $c$.clean((Object)Result.$assign$ConvertibleNotArray((Object)$c$.track(llvm.make_unique((Object)new RedirectingDirectoryEntry(I.$star(), (std.vector<std_ptr.unique_ptr<Entry>>)((std.vector)std.move((Object)Entries)), new Status(new StringRef(NativePointer.$EMPTY), VfsGlobals.getNextVirtualUniqueID(), TimeValue.now(), 0, 0, 0L, fs.file_type.directory_file, 511))))));
                }
                finally {
                    if (Entries != null) {
                        Entries.$destroy();
                    }
                    $c$.$destroy();
                }
                I.$preInc();
            }
            unique_ptr2 = new std_ptr.unique_ptr(JavaDifferentiators.JD.Move.INSTANCE, Result);
            return unique_ptr2;
        }
        finally {
            if (Result != null) {
                Result.$destroy();
            }
            if (EntryArrayContents != null) {
                EntryArrayContents.$destroy();
            }
        }
    }

    public RedirectingFileSystemParser(Stream S) {
        this.Stream = S;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(Node Root, RedirectingFileSystem FS) {
        std.vector RootEntries = null;
        try {
            MappingNode Top = (MappingNode)llvm.dyn_cast(MappingNode.class, (Object)Root);
            if (Top == null) {
                this.error(Root, new Twine("expected mapping node"));
                boolean bl = false;
                return bl;
            }
            Object[] Fields = new std_pair.pair[]{new std_pair.pair((Object)new StringRef("version"), (Object)new KeyStatus(true)), new std_pair.pair((Object)new StringRef("case-sensitive"), (Object)new KeyStatus(false)), new std_pair.pair((Object)new StringRef("use-external-names"), (Object)new KeyStatus(false)), new std_pair.pair((Object)new StringRef("overlay-relative"), (Object)new KeyStatus(false)), new std_pair.pair((Object)new StringRef("roots"), (Object)new KeyStatus(true))};
            DenseMap Keys = new DenseMap((DenseMapInfo)new DenseMapInfoStringRef(), (type.iterator)std.begin((Object[])Fields), (type.iterator)std.end((Object[])Fields), (Object)new KeyStatus());
            RootEntries = new std.vector((Object)new std_ptr.unique_ptr());
            basic_collection_iterator I = Top.begin();
            basic_collection_iterator E2 = Top.end();
            while (I.$noteq(E2)) {
                SmallString KeyBuffer = new SmallString(10);
                StringRef Key = new StringRef();
                if (!this.parseScalarString(((KeyValueNode)I.$arrow()).getKey(), Key, KeyBuffer)) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.checkDuplicateOrUnknownKey(((KeyValueNode)I.$arrow()).getKey(), new StringRef(Key), (DenseMap<StringRef, KeyStatus>)Keys)) {
                    boolean bl = false;
                    return bl;
                }
                if (llvm.$eq_StringRef((StringRef)Key, (String)"roots")) {
                    SequenceNode Roots = (SequenceNode)llvm.dyn_cast(SequenceNode.class, (Object)((KeyValueNode)I.$arrow()).getValue());
                    if (Roots == null) {
                        this.error(((KeyValueNode)I.$arrow()).getValue(), new Twine("expected array"));
                        boolean bl = false;
                        return bl;
                    }
                    basic_collection_iterator _I = Roots.begin();
                    basic_collection_iterator _E = Roots.end();
                    while (_I.$noteq(_E)) {
                        block49: {
                            std_ptr.unique_ptr<Entry> _Entry = null;
                            try {
                                _Entry = this.parseEntry((Node)_I.$star(), FS);
                                if (_Entry.$bool()) {
                                    RootEntries.push_back((Object)std.move(_Entry));
                                    break block49;
                                }
                                boolean bl = false;
                                return bl;
                            }
                            finally {
                                if (_Entry != null) {
                                    _Entry.$destroy();
                                }
                            }
                        }
                        _I.$preInc();
                    }
                } else if (llvm.$eq_StringRef((StringRef)Key, (String)"version")) {
                    StringRef VersionString = new StringRef();
                    SmallString Storage2 = new SmallString(4);
                    if (!this.parseScalarString(((KeyValueNode)I.$arrow()).getValue(), VersionString, Storage2)) {
                        boolean _E = false;
                        return _E;
                    }
                    int.ref Version = NativePointer.create_int$ref();
                    if (VersionString.getAsInteger$Signed(10, Version)) {
                        this.error(((KeyValueNode)I.$arrow()).getValue(), new Twine("expected integer"));
                        boolean bl = false;
                        return bl;
                    }
                    if (Version.$deref() < 0) {
                        this.error(((KeyValueNode)I.$arrow()).getValue(), new Twine("invalid version number"));
                        boolean bl = false;
                        return bl;
                    }
                    if (Version.$deref() != 0) {
                        this.error(((KeyValueNode)I.$arrow()).getValue(), new Twine("version mismatch, expected 0"));
                        boolean bl = false;
                        return bl;
                    }
                } else if (llvm.$eq_StringRef((StringRef)Key, (String)"case-sensitive")) {
                    if (!this.parseScalarBool(((KeyValueNode)I.$arrow()).getValue(), FS.CaseSensitive$Ref)) {
                        boolean bl = false;
                        return bl;
                    }
                } else if (llvm.$eq_StringRef((StringRef)Key, (String)"overlay-relative")) {
                    if (!this.parseScalarBool(((KeyValueNode)I.$arrow()).getValue(), FS.IsRelativeOverlay$Ref)) {
                        boolean bl = false;
                        return bl;
                    }
                } else if (llvm.$eq_StringRef((StringRef)Key, (String)"use-external-names")) {
                    if (!this.parseScalarBool(((KeyValueNode)I.$arrow()).getValue(), FS.UseExternalNames$Ref)) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    throw new llvm_unreachable("key missing from Keys");
                }
                I.$preInc();
            }
            if (this.Stream.failed()) {
                boolean bl = false;
                return bl;
            }
            if (!this.checkMissingKeys((Node)Top, (DenseMap<StringRef, KeyStatus>)Keys)) {
                boolean bl = false;
                return bl;
            }
            for (basic_collection_iterator E2 : RootEntries) {
                this.uniqueOverlayTree(FS, (Entry)E2.get());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (RootEntries != null) {
                RootEntries.$destroy();
            }
        }
    }

    public String toString() {
        return "Stream=" + this.Stream;
    }

    private static class KeyStatus {
        public boolean Required;
        public boolean Seen;

        public KeyStatus() {
            this(false);
        }

        public KeyStatus(boolean Required) {
            this.Required = Required;
            this.Seen = false;
        }

        public KeyStatus(KeyStatus $Prm0) {
            this.Required = $Prm0.Required;
            this.Seen = $Prm0.Seen;
        }

        public KeyStatus(JavaDifferentiators.JD.Move _dparam, KeyStatus $Prm0) {
            this.Required = $Prm0.Required;
            this.Seen = $Prm0.Seen;
        }

        public String toString() {
            return "Required=" + this.Required + ", Seen=" + this.Seen;
        }
    }
}

