/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.wizard;

import java.io.File;
import java.util.ArrayList;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.makefile.wizard.DirectoryChooserPanel;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizard;
import org.netbeans.modules.cnd.utils.CndPathUtilities;

public class BaseDirectoryPanel
extends DirectoryChooserPanel {
    private boolean baseIsValid;
    static final long serialVersionUID = -4831717621793094L;
    private boolean initialized;

    public BaseDirectoryPanel(MakefileWizard wd) {
        super(wd);
        String subtitle = this.getString("LBL_BaseDirectoryPanel");
        this.setSubTitle(subtitle);
        this.getAccessibleContext().setAccessibleDescription(subtitle);
        this.initialized = false;
        this.baseIsValid = false;
    }

    @Override
    public void validateData(ArrayList<String> msgs, int key) {
        File file = new File(this.getMakefileData().getBaseDirectory(true));
        if (file.exists()) {
            if (!file.isDirectory()) {
                this.warn(msgs, WARN_CWD_NOT_DIR, file.getPath());
            }
        } else {
            this.warn(msgs, WARN_CWD_DOES_NOT_EXIST, file.getPath());
        }
    }

    @Override
    public boolean isPanelValid() {
        return this.baseIsValid;
    }

    @Override
    protected final void onOk() {
        this.checkit();
    }

    private void validateCurrentBase() {
        JTextField tf = this.getText();
        File dir = null;
        this.baseIsValid = false;
        String text = CndPathUtilities.expandPath((String)tf.getText());
        if (text.length() > 0) {
            dir = text.charAt(0) == File.separatorChar ? new File(text) : new File(".", text);
        }
        if (dir != null && !dir.isFile()) {
            this.baseIsValid = true;
            MakefileWizard.getMakefileWizard().updateState();
        }
    }

    private void create() {
        this.create(this.getString("LBL_BaseDirectory"), 1, this.getString("HLP_BaseDirectory"));
        JTextField tf = this.getText();
        tf.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                BaseDirectoryPanel.this.checkit();
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                BaseDirectoryPanel.this.checkit();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                BaseDirectoryPanel.this.checkit();
            }
        });
        this.getLabel().setLabelFor(tf);
        this.getLabel().setDisplayedMnemonic(this.getString("MNEM_BaseDirectory").charAt(0));
    }

    private final void checkit() {
        boolean oldVal = this.baseIsValid;
        this.validateCurrentBase();
        if (this.baseIsValid != oldVal) {
            MakefileWizard.getMakefileWizard().updateState();
        }
    }

    @Override
    public void addNotify() {
        if (!this.initialized) {
            this.initialized = true;
            MakefileWizard.getMakefileWizard().initDirPaths();
            this.create();
        }
        super.addNotify();
        this.getText().setText(this.getMakefileData().getBaseDirectory());
        this.validateCurrentBase();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        JTextField tf = this.getText();
        if (tf != null) {
            String base = tf.getText();
            if (!base.equals(this.getMakefileData().getBaseDirectory())) {
                this.getMakefileData().setBaseDirectory(base);
            }
            MakefileWizard.getMakefileWizard().initMakefileName();
        }
    }
}

