/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.openide.util.NbBundle;

public class TimestampType {
    public static final Locale LOCALE = Locale.UK;
    public static final String DEFAULT_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final DateFormat[] TIMESTAMP_PARSING_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"), DateFormat.getDateTimeInstance(), DateFormat.getTimeInstance(3), DateFormat.getTimeInstance(1, LOCALE), DateFormat.getTimeInstance(3, LOCALE), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("MM-dd-yyyy"), new SimpleDateFormat("HH:mm:ss")};

    public TimestampType() {
        for (int i = 0; i < TIMESTAMP_PARSING_FORMATS.length; ++i) {
            TIMESTAMP_PARSING_FORMATS[i].setLenient(false);
        }
    }

    public static Timestamp convert(Object value) throws DBException {
        if (null == value) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof java.sql.Date) {
            return new Timestamp(((java.sql.Date)value).getTime());
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        if (value instanceof String) {
            Date dVal = TimestampType.doParse((String)value);
            if (dVal == null) {
                throw new DBException(NbBundle.getMessage(TimestampType.class, (String)"LBL_invalid_timestamp"));
            }
            return new Timestamp(dVal.getTime());
        }
        throw new DBException(NbBundle.getMessage(TimestampType.class, (String)"LBL_invalid_timestamp"));
    }

    private static synchronized Date doParse(String sVal) {
        Date dVal = null;
        for (DateFormat format : TIMESTAMP_PARSING_FORMATS) {
            try {
                dVal = format.parse(sVal);
                break;
            }
            catch (ParseException ex) {
                Logger.getLogger(TimestampType.class.getName()).log(Level.FINEST, ex.getLocalizedMessage(), ex);
            }
        }
        return dVal;
    }
}

