/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.Project;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.javascript2.debug.NamesTranslator;
import org.netbeans.modules.web.common.api.RemoteFileCache;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.netbeans.modules.web.common.sourcemap.SourceMap;
import org.netbeans.modules.web.common.sourcemap.SourceMapsTranslator;
import org.netbeans.modules.web.javascript.debugger.browser.ProjectContext;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.modules.web.webkit.debugging.api.debugger.Script;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.viewmodel.Models;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class MiscEditorUtil {
    public static final String HTML_MIME_TYPE = "text/html";
    public static final String PHP_MIME_TYPE = "text/x-php5";
    public static final String JAVASCRIPT_MIME_TYPE = "text/javascript";
    public static final String BREAKPOINT_ANNOTATION_TYPE = "Breakpoint";
    public static final String DISABLED_BREAKPOINT_ANNOTATION_TYPE = "DisabledBreakpoint";
    public static final String CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE = "CondBreakpoint";
    public static final String DISABLED_CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE = "DisabledCondBreakpoint";
    public static final String DEACTIVATED_BREAKPOINT_SUFFIX = "_stroke";
    public static final String BROKEN_BREAKPOINT_SUFFIX = "_broken";
    public static final String CURRENT_LINE_ANNOTATION_TYPE = "CurrentPC";
    public static final String CALL_STACK_FRAME_ANNOTATION_TYPE = "CallSite";
    public static final String PROP_LINE_NUMBER = "lineNumber";
    private static final Logger LOG = Logger.getLogger(MiscEditorUtil.class.getName());
    private static final boolean USE_SOURCE_MAPS = Boolean.parseBoolean(System.getProperty("javascript.debugger.useSourceMaps", "true"));
    private static final Map<Object, SourceMapsTranslator> TRANSLATORS = new WeakHashMap<Object, SourceMapsTranslator>();
    private static final RequestProcessor RP = new RequestProcessor(MiscEditorUtil.class.getName());

    public static String getAnnotationTooltip(String annotationType) {
        return MiscEditorUtil.getMessage("TOOLTIP_" + annotationType);
    }

    private static String getMessage(String key) {
        return NbBundle.getBundle(MiscEditorUtil.class).getString(key);
    }

    public static void openFileObject(FileObject fileObject) {
        if (fileObject == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie cookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            cookie.open();
        }
        catch (DataObjectNotFoundException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SourceMapsTranslator getSourceMapsTranslator(Debugger debugger) {
        SourceMapsTranslator smt;
        if (!USE_SOURCE_MAPS) {
            return null;
        }
        Map<Object, SourceMapsTranslator> map = TRANSLATORS;
        synchronized (map) {
            smt = TRANSLATORS.get(debugger);
            if (smt == null) {
                smt = SourceMapsTranslator.create();
                TRANSLATORS.put(debugger, smt);
            }
        }
        return smt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerProjectsSourceMapTranslator(Debugger debugger, SourceMapsTranslator psmt) {
        if (!USE_SOURCE_MAPS) {
            return;
        }
        Map<Object, SourceMapsTranslator> map = TRANSLATORS;
        synchronized (map) {
            SourceMapsTranslator smt = TRANSLATORS.get(debugger);
            if (smt instanceof SourceMapsTranslatorDelegate) {
                return;
            }
            if (smt == null) {
                smt = SourceMapsTranslator.create();
            }
            smt = new SourceMapsTranslatorDelegate(smt, psmt);
            TRANSLATORS.put(debugger, smt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterSourceMapsTranslator(Debugger debugger) {
        if (!USE_SOURCE_MAPS) {
            return;
        }
        Map<Object, SourceMapsTranslator> map = TRANSLATORS;
        synchronized (map) {
            TRANSLATORS.remove(debugger);
        }
    }

    public static NamesTranslator createNamesTranslator(Debugger debugger, Project project, String scriptURL, int lineNumber, int columnNumber) {
        if (!USE_SOURCE_MAPS) {
            return null;
        }
        FileObject fileObject = MiscEditorUtil.getFile(project, scriptURL);
        if (fileObject == null) {
            return null;
        }
        SourceMapsTranslator smt = MiscEditorUtil.getSourceMapsTranslator(debugger);
        return NamesTranslator.create((SourceMapsTranslator)smt, (FileObject)fileObject, (int)lineNumber, (int)columnNumber);
    }

    public static Line getLine(String filePath, int lineNumber, int columnNumber) {
        return MiscEditorUtil.getLineImpl(null, null, filePath, lineNumber, columnNumber);
    }

    public static Line getLine(Debugger debugger, Project project, Script script, int lineNumber, int columnNumber) {
        return MiscEditorUtil.getLineImpl(debugger, project, script.getURL(), lineNumber, columnNumber);
    }

    public static Line getLine(Debugger debugger, Project project, String stringURL, int lineNumber, int columnNumber) {
        return MiscEditorUtil.getLineImpl(debugger, project, stringURL, lineNumber, columnNumber);
    }

    private static Line getLineImpl(Debugger debugger, Project project, String filePath, int lineNumber, int columnNumber) {
        LineCookie lineCookie;
        if (filePath == null || lineNumber < 0) {
            return null;
        }
        FileObject fileObject = MiscEditorUtil.getFile(project, filePath);
        if (fileObject == null) {
            LOG.log(Level.INFO, "Cannot resolve \"{0}\"", filePath);
            return null;
        }
        if (debugger != null && USE_SOURCE_MAPS) {
            SourceMapsTranslator smt = MiscEditorUtil.getSourceMapsTranslator(debugger);
            SourceMapsTranslator.Location location = new SourceMapsTranslator.Location(fileObject, lineNumber, columnNumber);
            location = smt.getSourceLocation(location);
            fileObject = location.getFile();
            lineNumber = location.getLine();
            columnNumber = location.getColumn();
        }
        if ((lineCookie = MiscEditorUtil.getLineCookie(fileObject)) == null) {
            LOG.log(Level.INFO, "No line cookie for \"{0}\"", fileObject);
            return null;
        }
        try {
            return lineCookie.getLineSet().getCurrent(lineNumber);
        }
        catch (IndexOutOfBoundsException ioob) {
            List lines = lineCookie.getLineSet().getLines();
            if (lines.size() > 0) {
                return (Line)lines.get(lines.size() - 1);
            }
            return null;
        }
    }

    private static FileObject getFile(Project project, String filePath) {
        FileObject fileObject = null;
        try {
            URI uri = URI.create(filePath);
            if (uri.isAbsolute()) {
                URL url;
                try {
                    url = uri.toURL();
                }
                catch (MalformedURLException muex) {
                    LOG.log(Level.INFO, "Cannot resolve " + filePath, muex);
                    return null;
                }
                if (project != null) {
                    fileObject = ServerURLMapping.fromServer((Project)project, (URL)url);
                }
                if (fileObject == null && (filePath.startsWith("http:") || filePath.startsWith("https:"))) {
                    fileObject = RemoteFileCache.getRemoteFile((URL)url);
                }
            }
            if (fileObject == null) {
                File file = filePath.startsWith("file:/") ? org.openide.util.Utilities.toFile((URI)uri) : new File(filePath);
                fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return fileObject;
    }

    public static List<FileObject> registerScriptSourceMap(Project project, Debugger debugger, Script script) {
        String url;
        List mappedSourceFiles = Collections.EMPTY_LIST;
        if (USE_SOURCE_MAPS && !(url = script.getURL()).isEmpty()) {
            boolean success;
            String smurl;
            SourceMapsTranslator smt = MiscEditorUtil.getSourceMapsTranslator(debugger);
            FileObject file = MiscEditorUtil.getFile(project, url);
            if (file != null && (smurl = script.getSourceMapURL()) != null && !smurl.isEmpty() && (success = smt.registerTranslation(file, smurl))) {
                mappedSourceFiles = smt.getSourceFiles(file);
            }
        }
        return mappedSourceFiles;
    }

    public static Line getLine(FileObject fileObject, int lineNumber) {
        Line.Set ls;
        LineCookie lineCookie;
        if (fileObject != null && (lineCookie = MiscEditorUtil.getLineCookie(fileObject)) != null && (ls = lineCookie.getLineSet()) != null) {
            try {
                return ls.getCurrent(lineNumber - 1);
            }
            catch (IndexOutOfBoundsException ioob) {
                List lines = ls.getLines();
                if (lines.size() > 0) {
                    return (Line)lines.get(lines.size() - 1);
                }
                return null;
            }
        }
        return null;
    }

    public static LineCookie getLineCookie(FileObject fo) {
        LineCookie result = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fo);
            if (dataObject != null) {
                result = (LineCookie)dataObject.getCookie(LineCookie.class);
            }
        }
        catch (DataObjectNotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void showLine(final Line line, final boolean toFront) {
        if (line == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                line.show(Line.ShowOpenType.REUSE, toFront ? Line.ShowVisibilityType.FRONT : Line.ShowVisibilityType.FOCUS);
            }
        });
    }

    public static void showLine(Line line) {
        MiscEditorUtil.showLine(line, false);
    }

    public static Line getCurrentLine() {
        FileObject fo = EditorContextDispatcher.getDefault().getCurrentFile();
        if (fo == null) {
            return null;
        }
        if (!MiscEditorUtil.isJavascriptSource(fo) && !MiscEditorUtil.isJSWrapperSource(fo)) {
            return null;
        }
        return EditorContextDispatcher.getDefault().getCurrentLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInJavaScript(Line line) {
        LOG.log(Level.FINER, "\nisInJavaScript({0}):", line);
        FileObject fo = (FileObject)line.getLookup().lookup(FileObject.class);
        if (MiscEditorUtil.isJavascriptSource(fo)) {
            LOG.fine("is JavaScript source file => true");
            return true;
        }
        EditorCookie editorCookie = (EditorCookie)line.getLookup().lookup(EditorCookie.class);
        StyledDocument document = editorCookie.getDocument();
        Boolean isJS = null;
        ((AbstractDocument)((Object)document)).readLock();
        try {
            TokenHierarchy th = TokenHierarchy.get((Document)document);
            int ln = line.getLineNumber();
            int offset = NbDocument.findLineOffset((StyledDocument)document, (int)ln);
            int maxOffset = document.getLength() - 1;
            int maxLine = NbDocument.findLineNumber((StyledDocument)document, (int)maxOffset);
            int offset2 = ln + 1 > maxLine ? maxOffset : NbDocument.findLineOffset((StyledDocument)document, (int)(ln + 1)) - 1;
            Set languagePaths = th.languagePaths();
            block3: for (LanguagePath lp : languagePaths) {
                List tsl = th.tokenSequenceList(lp, offset, offset2);
                for (TokenSequence ts : tsl) {
                    if (!ts.moveNext()) continue;
                    TokenSequence ets = ts.embedded();
                    if (ets != null) {
                        ts = ets;
                    }
                    String mimeType = ts.language().mimeType();
                    LOG.log(Level.FINER, "Have language {0}", mimeType);
                    if (isJS != null || !JAVASCRIPT_MIME_TYPE.equals(mimeType)) continue;
                    isJS = true;
                    if (LOG.isLoggable(Level.FINER)) continue;
                    continue block3;
                }
            }
        }
        finally {
            ((AbstractDocument)((Object)document)).readUnlock();
        }
        LOG.log(Level.FINER, "isJS = {0}", isJS);
        return isJS != null && isJS != false;
    }

    public static boolean isJSWrapperSource(FileObject fo) {
        String mimeType = fo.getMIMEType();
        return HTML_MIME_TYPE.equals(mimeType) || PHP_MIME_TYPE.equals(mimeType);
    }

    public static boolean isJavascriptSource(FileObject fo) {
        return JAVASCRIPT_MIME_TYPE.equals(fo.getMIMEType());
    }

    public static boolean isJSOrWrapperMIMEType(String mimeType) {
        switch (mimeType) {
            case "text/javascript": 
            case "text/html": 
            case "text/x-php5": {
                return true;
            }
        }
        return false;
    }

    public static Action createDebuggerGoToAction(final ProjectContext pc, final Debugger debugger) {
        Models.ActionPerformer actionPerform = new Models.ActionPerformer(){

            public boolean isEnabled(Object object) {
                return true;
            }

            public void perform(Object[] nodes) {
                Object node = nodes[0];
                if (node instanceof CallFrame) {
                    CallFrame cf = (CallFrame)node;
                    Project project = pc.getProject();
                    Line line = MiscEditorUtil.getLine(debugger, project, cf.getScript(), cf.getLineNumber(), cf.getColumnNumber());
                    if (line != null) {
                        MiscEditorUtil.showLine(line, true);
                    }
                }
            }
        };
        return Models.createAction((String)NbBundle.getMessage(MiscEditorUtil.class, (String)"CTL_GoToSource"), (Models.ActionPerformer)actionPerform, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    public static void setupContext(final JEditorPane editorPane, final Runnable contextSetUp) {
        DebuggerEngine en = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (EventQueue.isDispatchThread() && en != null) {
            final DebuggerEngine den = en;
            RP.post(new Runnable(){

                @Override
                public void run() {
                    Context c = MiscEditorUtil.retrieveContext(den);
                    if (c != null) {
                        MiscEditorUtil.setupContext(editorPane, c.url, c.line, c.debugger);
                        if (contextSetUp != null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    contextSetUp.run();
                                }
                            });
                        }
                    }
                }
            });
            Context c = MiscEditorUtil.retrieveContext(null);
            if (c != null) {
                MiscEditorUtil.setupContext(editorPane, c.url, c.line, c.debugger);
            } else {
                MiscEditorUtil.setupUI(editorPane);
            }
            return;
        }
        Context c = MiscEditorUtil.retrieveContext(en);
        if (c != null) {
            MiscEditorUtil.setupContext(editorPane, c.url, c.line, c.debugger);
        } else {
            MiscEditorUtil.setupUI(editorPane);
        }
        if (contextSetUp != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    contextSetUp.run();
                }
            });
        }
    }

    private static Context retrieveContext(DebuggerEngine en) {
        Context c;
        Script script;
        CallFrame cf = null;
        Debugger d = null;
        if (en != null && (d = (Debugger)en.lookupFirst(null, Debugger.class)) != null) {
            cf = d.getCurrentCallFrame();
        }
        boolean adjustContext = true;
        if (cf != null && (script = cf.getScript()) != null) {
            Session session = (Session)en.lookupFirst(null, Session.class);
            String language = session.getCurrentLanguage();
            c = new Context();
            c.url = script.getURL();
            c.line = cf.getLineNumber();
            c.debugger = d;
            if (c.line > 0) {
                adjustContext = false;
                --c.line;
            }
        } else {
            EditorContextDispatcher context = EditorContextDispatcher.getDefault();
            String url = context.getMostRecentURLAsString();
            if (url != null && url.length() > 0) {
                c = new Context();
                c.url = url;
                c.line = context.getMostRecentLineNumber();
                c.debugger = d;
            } else {
                return null;
            }
        }
        if (!adjustContext || !EventQueue.isDispatchThread()) {
            // empty if block
        }
        return c;
    }

    public static void setupContext(JEditorPane editorPane, String url, int line) {
        MiscEditorUtil.setupContext(editorPane, url, line, null);
    }

    public static void setupContext(final JEditorPane editorPane, String url, final int line, Debugger debugger) {
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
            if (file == null) {
                return;
            }
        }
        catch (MalformedURLException e) {
            return;
        }
        if (file.getMIMEType().startsWith("text/")) {
            Runnable bindComponentToDocument = new Runnable(){

                @Override
                public void run() {
                    String origText = editorPane.getText();
                    DialogBinding.bindComponentToFile((FileObject)file, (int)(line >= 0 ? line : 0), (int)0, (int)0, (JTextComponent)editorPane);
                    Document editPaneDoc = editorPane.getDocument();
                    editorPane.setText(origText);
                }
            };
            if (EventQueue.isDispatchThread()) {
                bindComponentToDocument.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(bindComponentToDocument);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        MiscEditorUtil.setupUI(editorPane);
    }

    private static void setupUI(final JEditorPane editorPane) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                EditorUI eui = Utilities.getEditorUI((JTextComponent)editorPane);
                if (eui == null) {
                    return;
                }
                editorPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
                try {
                    Field textLimitLineField = EditorUI.class.getDeclaredField("textLimitLineVisible");
                    textLimitLineField.setAccessible(true);
                    textLimitLineField.set(eui, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                editorPane.repaint();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static class SourceMapsTranslatorDelegate
    implements SourceMapsTranslator {
        private final SourceMapsTranslator smt1;
        private final SourceMapsTranslator smt2;

        public SourceMapsTranslatorDelegate(SourceMapsTranslator smt1, SourceMapsTranslator smt2) {
            this.smt1 = smt1;
            this.smt2 = smt2;
        }

        public boolean registerTranslation(FileObject source, String sourceMapFileName) {
            return this.smt1.registerTranslation(source, sourceMapFileName);
        }

        public boolean registerTranslation(FileObject source, SourceMap sourceMap) {
            return this.smt1.registerTranslation(source, sourceMap);
        }

        public void unregisterTranslation(FileObject source) {
            this.smt1.unregisterTranslation(source);
        }

        public SourceMapsTranslator.Location getSourceLocation(SourceMapsTranslator.Location loc) {
            SourceMapsTranslator.Location l = this.smt1.getSourceLocation(loc);
            if (l == loc) {
                l = this.smt2.getSourceLocation(loc);
            }
            return l;
        }

        public SourceMapsTranslator.Location getSourceLocation(SourceMapsTranslator.Location loc, String sourceMapFileName) {
            SourceMapsTranslator.Location l = this.smt1.getSourceLocation(loc, sourceMapFileName);
            if (l == loc) {
                l = this.smt2.getSourceLocation(loc, sourceMapFileName);
            }
            return l;
        }

        public SourceMapsTranslator.Location getCompiledLocation(SourceMapsTranslator.Location loc) {
            SourceMapsTranslator.Location l = this.smt1.getCompiledLocation(loc);
            if (l == loc) {
                l = this.smt2.getCompiledLocation(loc);
            }
            return l;
        }

        public List<FileObject> getSourceFiles(FileObject compiledFile) {
            List sourceFiles = this.smt1.getSourceFiles(compiledFile);
            if (sourceFiles == null) {
                sourceFiles = this.smt2.getSourceFiles(compiledFile);
            }
            return sourceFiles;
        }
    }

    private static final class Context {
        public String url;
        public int line;
        public Debugger debugger;

        private Context() {
        }
    }
}

