/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Collection;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.web.browser.api.BrowserUISupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.api.WebBrowsers;
import org.netbeans.modules.web.browser.spi.ProjectBrowserProvider;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;

public class WebProjectBrowserProvider
implements ProjectBrowserProvider {
    private WebProject project;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public WebProjectBrowserProvider(WebProject project) {
        this.project = project;
        project.evaluator().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("selected.browser")) {
                    WebProjectBrowserProvider.this.pcs.firePropertyChange("activeConfiguration", null, null);
                }
            }
        });
    }

    public Collection<WebBrowser> getBrowsers() {
        return WebBrowsers.getInstance().getAll(false, true, true);
    }

    public WebBrowser getActiveBrowser() {
        String selectedBrowser = this.project.evaluator().getProperty("selected.browser");
        if (selectedBrowser == null) {
            return BrowserUISupport.getDefaultBrowserChoice((boolean)true);
        }
        return BrowserUISupport.getBrowser((String)selectedBrowser);
    }

    public void setActiveBrowser(final WebBrowser browser) throws IllegalArgumentException, IOException {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                AntProjectHelper helper = WebProjectBrowserProvider.this.project.getAntProjectHelper();
                EditableProperties privateProps = helper.getProperties("nbproject/private/private.properties");
                privateProps.put("selected.browser", browser.getId());
                helper.putProperties("nbproject/private/private.properties", privateProps);
            }
        });
        this.pcs.firePropertyChange("activeConfiguration", null, null);
    }

    public boolean hasCustomizer() {
        return true;
    }

    public void customize() {
        ((CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class)).showCustomizer("Run");
    }

    public void addPropertyChangeListener(PropertyChangeListener lst) {
        this.pcs.addPropertyChangeListener(lst);
    }

    public void removePropertyChangeListener(PropertyChangeListener lst) {
        this.pcs.removePropertyChangeListener(lst);
    }
}

