/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.performance.utilities;

import java.io.PrintStream;
import java.util.ArrayList;

public class LoggingScanClasspath {
    private static ArrayList<PerformanceScanData> data = new ArrayList();

    public void reportScanOfFile(String file, Long measuredTime) {
        data.add(new PerformanceScanData(file, measuredTime));
    }

    public static ArrayList<PerformanceScanData> getData() {
        return data;
    }

    public static void printMeasuredValues(PrintStream ps) {
        for (PerformanceScanData performanceScanData : data) {
            ps.println(performanceScanData);
        }
    }

    public class PerformanceScanData {
        private String name;
        private long value;
        private String fullyQualifiedName;

        public PerformanceScanData() {
        }

        public PerformanceScanData(String name, Long value) {
            this(name, value, name);
        }

        public PerformanceScanData(String name, Long value, String fullyQualifiedName) {
            try {
                int beginIndex = name.substring(0, name.lastIndexOf(47) - 1).lastIndexOf(47) + 1;
                int endIndex = name.indexOf(33, beginIndex);
                if (endIndex == -1) {
                    endIndex = name.length() - 1;
                    beginIndex = name.lastIndexOf(47, beginIndex - 2) + 1;
                }
                this.setName(name.substring(beginIndex, endIndex));
            }
            catch (Exception exc) {
                exc.printStackTrace(System.err);
                this.setName(name);
            }
            this.setValue(value);
            this.setFullyQualifiedName(fullyQualifiedName);
        }

        public String toString() {
            return "name =[" + this.getName() + "] value=" + this.getValue() + " FQN=[" + this.getFullyQualifiedName() + "]";
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public long getValue() {
            return this.value;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public void setFullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }
    }
}

